/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webviewer.servlet;

import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.web.cache.StiCacheOptions;
import com.stimulsoft.web.helper.StiWebActionResult;
import com.stimulsoft.web.proxyee.StiHttpServletRequest;
import com.stimulsoft.web.proxyee.StiHttpServletResponse;
import com.stimulsoft.webviewer.StiWebViewerActions;
import com.stimulsoft.webviewer.StiWebViewerExceptionHandler;
import com.stimulsoft.webviewer.helper.StiAngularViewerHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StiWebViewerActionServletHelper {
    protected static final Logger LOG = Logger.getLogger(StiWebViewerActionServletHelper.class.getName());
    public static String ACTION_PARAM = "a";
    public static String AJAX_SERVLET_MAPPING = "stimulsoft_webviewer_action";

    public static void processing(StiHttpServletRequest request, StiHttpServletResponse response) {
        try {
            String action = request.getParameter(ACTION_PARAM);
            if (action != null) {
                response.setHeader("X-UA-Compatible", "IE=Edge");
                if ("Design".equals(action)) {
                    response.sendRedirect("designer.jsp?report=" + request.getParameter("report"));
                } else {
                    Object result = null;
                    if ("ViewEvent".equals(action)) {
                        result = StiWebViewerActions.viewerEventResult(request, response);
                    } else if ("ViewerIteraction".equals(action)) {
                        result = StiWebViewerActions.interactionResult(request, response);
                    } else if ("GetReport".equals(action)) {
                        result = StiWebViewerActions.getReportResult(request, response);
                    } else if ("Email".equals(action)) {
                        result = StiWebViewerActions.emailReportResult(request, response);
                    } else if ("InitViewer".equals(action)) {
                        result = StiAngularViewerHelper.initViewer(request, response);
                    }
                    if (result instanceof StiWebActionResult) {
                        StiWebActionResult res = (StiWebActionResult)result;
                        if (StiValidationUtil.equals((Object)"text/javascript", (Object)res.getContentType()) || StiValidationUtil.equals((Object)"text/css", (Object)res.getContentType())) {
                            response.setHeader("Cache-Control", "public, max-age=31536000");
                        }
                        ((StiWebActionResult)result).writeFile(response);
                    } else if (result instanceof String) {
                        StiIOUtil.writeString((OutputStream)response.getOutputStream(), (String)((String)result));
                    }
                }
            }
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, "", e);
            StiWebViewerExceptionHandler handler = (StiWebViewerExceptionHandler)StiCacheOptions.cache.getObject(request, "exceptionHandlerwebviewer_cached_report");
            if (handler != null) {
                handler.onError(e);
            }
            try {
                StiIOUtil.writeString((OutputStream)response.getOutputStream(), (String)("ServerError:" + StiLoggingUtil.getHtmlError((String)e.getMessage(), (Throwable)e, (String)"<br>")));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }
}

