/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webviewer;

import com.stimulsoft.base.StiAttribute;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.json.StiJSONHelper;
import com.stimulsoft.base.licenses.StiLicenseKeyValidator;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.lib.base64.StiBase64EncoderUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.lib.utils.StiXmlUtil;
import com.stimulsoft.web.classes.StiDefaultExportSettings;
import com.stimulsoft.web.helper.StiExportsHelper;
import com.stimulsoft.web.helper.StiLicenseHelper;
import com.stimulsoft.web.helper.StiReportResourceHelper;
import com.stimulsoft.web.html.StiHtmlElement;
import com.stimulsoft.web.proxyee.StiServletContext;
import com.stimulsoft.webviewer.StiWebViewerOptions;
import com.stimulsoft.webviewer.servlet.StiWebViewerActionServletHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;

public class StiWebViewerRender {
    protected static final Logger LOG = Logger.getLogger(StiWebViewerRender.class.getName());
    public static final String VERSION = StiAttribute.getSimpleVersion();
    private StiWebViewerOptions options;
    private String id;
    private boolean reportDesignerMode = false;

    public StiWebViewerRender(StiWebViewerOptions options, URL context, boolean reportDesignerMode) {
        this.options = options;
        this.id = options.getViewerID();
        String localizationFileName = options.getLocalization();
        if (options.getLocalizationStream() != null && !reportDesignerMode) {
            try {
                StiLocalization localization = StiLocalization.load((InputStream)options.getLocalizationStream());
                StiLocalization.setLocalization((StiLocalization)localization);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "", e);
            }
        } else if (StiValidationUtil.isNotNullOrEmpty((String)localizationFileName)) {
            File localizationFile = new File(localizationFileName);
            if (localizationFile.exists()) {
                try {
                    StiLocalization localization = StiLocalization.load((InputStream)new FileInputStream(localizationFile));
                    StiLocalization.setLocalization((StiLocalization)localization);
                }
                catch (FileNotFoundException e) {
                    LOG.log(Level.SEVERE, "", e);
                }
                catch (StiException e) {
                    LOG.log(Level.SEVERE, "", e);
                }
            } else {
                LOG.log(Level.SEVERE, "Unable to load localization file: " + localizationFile.getAbsolutePath());
            }
        }
    }

    private String renderJsonParameters(URL context, StiServletContext servletContext) {
        boolean isTrial;
        String url = StiValidationUtil.isNotNullOrEmpty((String)this.options.getServer().getController()) ? this.options.getServer().getController() : context.toString();
        String productVersion = StiAttribute.getVersion().trim();
        boolean bl = isTrial = !StiLicenseKeyValidator.isValidOnJavaFramework(null);
        if (!isTrial) {
            productVersion = productVersion + " ";
        }
        JSONObject jsOptions = new JSONObject();
        try {
            String height = StiValidationUtil.isNotNullOrEmpty((String)this.options.getHeight()) ? this.options.getHeight() : null;
            jsOptions.put("viewerId", (Object)this.id);
            jsOptions.put("theme", (Object)this.options.getTheme().toString());
            jsOptions.put("clientGuid", (Object)StiGuid.newGuid());
            jsOptions.put("requestAbsoluteUrl", (Object)(url + "/" + StiWebViewerActionServletHelper.AJAX_SERVLET_MAPPING + "?a={action}"));
            jsOptions.put("requestUrl", (Object)(url + "/" + StiWebViewerActionServletHelper.AJAX_SERVLET_MAPPING + "?a={action}"));
            jsOptions.put("requestStylesUrl", (Object)(url + "/" + StiWebViewerActionServletHelper.AJAX_SERVLET_MAPPING + "?a={action}"));
            jsOptions.put("routes", (Object)"[]");
            jsOptions.put("formValues", (Object)"{}");
            jsOptions.put("cultureName", (Object)StiLocalization.getLocalization().getCultureName());
            jsOptions.put("localization", (Object)this.options.getLocalization());
            jsOptions.put("shortProductVersion", (Object)StiAttribute.getSimpleVersion());
            jsOptions.put("productVersion", (Object)productVersion);
            jsOptions.put("heightType", (Object)(height == null ? "Pixel" : (height.substring(height.length() - 1).equals("%") ? "Percentage" : "Pixel")));
            jsOptions.put("reportDesignerMode", this.reportDesignerMode);
            jsOptions.put("frameworkType", (Object)"Java");
            jsOptions.put("alternateValid", StiLicenseHelper.checkAnyLicense());
            jsOptions.put("buildDate", (Object)StiAttribute.CREATED.toString("MM/dd/yyyy hh:mm:ss a"));
            jsOptions.put("stimulsoftFontContent", (Object)(this.reportDesignerMode ? null : StiReportResourceHelper.getStimulsoftFontBase64Data()));
            jsOptions.put("licenseUserName", (Object)StiLicenseHelper.getUserName());
            jsOptions.put("licenseIsValid", StiLicenseKeyValidator.isValidOnJavaFramework(null));
            jsOptions.put("viewerHeightType", (Object)(height == null ? "Pixel" : (height.substring(height.length() - 1).equals("%") ? "Percentage" : "Pixel")));
            jsOptions.put("actions", (Object)this.options.getActions());
            jsOptions.put("server", (Object)StiJSONHelper.toHash((Object)this.options.getServer()));
            jsOptions.put("appearance", (Object)StiJSONHelper.toHash((Object)this.options.getAppearance()));
            jsOptions.put("toolbar", (Object)StiJSONHelper.toHash((Object)this.options.getToolbar()));
            jsOptions.put("exports", (Object)StiJSONHelper.toHash((Object)this.options.getExports()));
            jsOptions.put("email", (Object)StiJSONHelper.toHash((Object)this.options.getEmail()));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        String jsonOptions = jsOptions.toString();
        String jsonDefaultExportSettings = new JSONObject((Map)StiExportsHelper.getDefaultExportSettings((StiDefaultExportSettings)this.options.getExports().getDefaultSettings())).toString();
        String jsonScriptsUrl = this.reportDesignerMode ? this.getScriptsUrl(context, url) : "";
        return String.format("{options:%s,defaultExportSettings:%s,scriptsUrl:\"%s\"}", jsonOptions, jsonDefaultExportSettings, jsonScriptsUrl);
    }

    public String getViewer(URL context, StiServletContext servletContext) throws IOException, ParserConfigurationException {
        DocumentBuilderFactory docFactory = StiXmlUtil.getBuilderFactory();
        DocumentBuilder docBuilder = null;
        docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        ProcessingInstruction disableEscaping = doc.createProcessingInstruction("javax.xml.transform.disable-output-escaping", "");
        doc.appendChild(disableEscaping);
        Element rootPanel = StiHtmlElement.createPanelHtmlElement((Document)doc);
        doc.appendChild(rootPanel);
        StiHtmlElement.setID((Element)rootPanel, (String)this.id);
        return this.createChildControls(rootPanel, doc, context, servletContext);
    }

    protected String createChildControls(Element root, Document doc, URL context, StiServletContext servletContext) throws IOException {
        StiHtmlElement.addStyle((Element)root, (String)"width", (String)this.options.getWidth());
        StiHtmlElement.addStyle((Element)root, (String)"height", (String)(StiValidationUtil.isNotNullOrEmpty((String)this.options.getHeight()) ? this.options.getHeight() : (this.options.getAppearance().isScrollbarsMode() ? "650px" : "100%")));
        StiHtmlElement.setBackColor((Element)root, (StiColor)this.options.getAppearance().getBackgroundColor());
        String url = StiValidationUtil.isNotNullOrEmpty((String)this.options.getServer().getController()) ? this.options.getServer().getController() : context.toString();
        Element mainPanel = StiHtmlElement.createPanelHtmlElement((Document)doc);
        StiHtmlElement.setCssClass((Element)mainPanel, (String)"stiJsViewerMainPanel");
        StiHtmlElement.setID((Element)mainPanel, (String)(this.id + "_JsViewerMainPanel"));
        root.appendChild(mainPanel);
        String jsParameters = this.renderJsonParameters(context, servletContext);
        if (this.isReportDesignerMode()) {
            Element scriptInit = StiHtmlElement.createJavascriptHtmlElement((Document)doc);
            scriptInit.setTextContent(String.format("var js%sParameters = %s;", this.id, jsParameters));
            root.appendChild(scriptInit);
            StiHtmlElement.addStyle((Element)root, (String)"display", (String)"none");
        } else {
            Element scriptEngine = StiHtmlElement.createJavascriptHtmlElement((Document)doc);
            String scriptUrl = this.getScriptsUrl(context, url);
            scriptEngine.setAttribute("src", scriptUrl);
            mainPanel.appendChild(scriptEngine);
            Element scriptInit = StiHtmlElement.createJavascriptHtmlElement((Document)doc);
            scriptInit.setTextContent(String.format("var js%s = new StiJsViewer(%s); if (document.readyState == 'complete') js%s.postAction(); else js%s.addEvent(window, 'load', function () { js%s.postAction() });", this.id, jsParameters, this.id, this.id, this.id));
            mainPanel.appendChild(scriptInit);
            if (this.options.getRefreshTimeout() > 0) {
                Element refreshScript = StiHtmlElement.createJavascriptHtmlElement((Document)doc);
                refreshScript.setTextContent(String.format("function refreshSession(){ js%s.postAjax('%s' + '?refresh=' + Math.random(),'', function(){} ); setTimeout('refreshSession()',%s);}refreshSession();", this.id, url + "/" + StiWebViewerActionServletHelper.AJAX_SERVLET_MAPPING, this.options.getRefreshTimeout() * 60000));
                root.appendChild(refreshScript);
            }
        }
        return StiWebViewerRender.serialize(doc, true);
    }

    private String getScriptsUrl(URL context, String url) {
        String localizationBase64 = "";
        if (StiValidationUtil.isNotNullOrEmpty((String)this.options.getLocalization())) {
            try {
                localizationBase64 = new String(StiBase64EncoderUtil.encode((byte[])this.options.getLocalization().getBytes("UTF-8")), "UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.options.getLocalizationStream() != null) {
            try {
                localizationBase64 = new String(StiBase64EncoderUtil.encode((byte[])StiLocalization.getLocalization().getLanguage().getBytes("UTF-8")), "UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String scriptUrl = url + "/" + StiWebViewerActionServletHelper.AJAX_SERVLET_MAPPING + "?stiweb_data=scripts&stiweb_component=Viewer&a=ViewEvent&stiweb_action=Resource&stiweb_theme=" + this.options.getTheme().toString() + "&stiweb_version=" + VERSION;
        if (StiValidationUtil.isNotNullOrEmpty((String)localizationBase64)) {
            scriptUrl = scriptUrl + "&stiweb_loc=" + localizationBase64;
        }
        return scriptUrl;
    }

    public boolean isReportDesignerMode() {
        return this.reportDesignerMode;
    }

    public void setReportDesignerMode(boolean reportDesignerMode) {
        this.reportDesignerMode = reportDesignerMode;
    }

    public static String serialize(Document doc, boolean omitXMLDeclaration) throws IOException {
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer t = transFactory.newTransformer();
            t.setOutputProperty("method", "html");
            t.setOutputProperty("omit-xml-declaration", "yes");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            t.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter((OutputStream)bos, "UTF-8")));
            bos.close();
            return new String(bos.toByteArray(), "UTF8");
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "", e);
            return "";
        }
    }
}

