/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.units;

import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.StiSerializedObject;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.enums.StiReportUnitType;
import com.stimulsoft.report.units.StiCentimetersUnit;
import com.stimulsoft.report.units.StiHundredthsOfInchUnit;
import com.stimulsoft.report.units.StiInchesUnit;
import com.stimulsoft.report.units.StiMillimetersUnit;

public abstract class StiUnit
extends StiSerializedObject {
    public static StiCentimetersUnit Centimeters = new StiCentimetersUnit();
    public static StiHundredthsOfInchUnit HundredthsOfInch = new StiHundredthsOfInchUnit();
    public static StiInchesUnit Inches = new StiInchesUnit();
    public static StiMillimetersUnit Millimeters = new StiMillimetersUnit();

    public static StiUnit GetUnitFromReportUnit(StiReportUnitType reportUnit) {
        StiUnit result = null;
        switch (reportUnit) {
            case HundredthsOfInch: {
                result = HundredthsOfInch;
                break;
            }
            case Inches: {
                result = Inches;
                break;
            }
            case Millimeters: {
                result = Millimeters;
                break;
            }
            default: {
                result = Centimeters;
            }
        }
        result.cleanReference();
        return result;
    }

    public abstract double getRollerStep();

    public abstract double getFactor();

    public abstract String getShortName();

    public abstract double ConvertToHInches(double var1);

    public abstract double ConvertFromHInches(double var1);

    public final StiRectangle ConvertToHInches(StiRectangle rect) {
        return new StiRectangle(this.ConvertToHInches(rect.getLeft()), this.ConvertToHInches(rect.getTop()), this.ConvertToHInches(rect.getWidth()), this.ConvertToHInches(rect.getHeight()));
    }

    public final StiRectangle ConvertToHInchesStiRectangle(StiRectangle rect) {
        return new StiRectangle(this.ConvertToHInches(rect.getLeft()), this.ConvertToHInches(rect.getTop()), this.ConvertToHInches(rect.getWidth()), this.ConvertToHInches(rect.getHeight()));
    }

    public final StiRectangle ConvertFromHInches(StiRectangle rect) {
        return new StiRectangle(this.ConvertFromHInches(rect.getLeft()), this.ConvertFromHInches(rect.getTop()), this.ConvertFromHInches(rect.getWidth()), this.ConvertFromHInches(rect.getHeight()));
    }

    public final StiSize ConvertToHInches(StiSize size) {
        return new StiSize(this.ConvertToHInches(size.getWidth()), this.ConvertToHInches(size.getHeight()));
    }

    public final StiSize ConvertFromHInches(StiSize size) {
        return new StiSize(this.ConvertFromHInches(size.getWidth()), this.ConvertFromHInches(size.getHeight()));
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JSONObject SaveToJsonObject(StiUnit unit) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyIdent("Ident", ((Object)((Object)unit)).getClass().getName());
        return jObject;
    }

    public static StiUnit LoadFromJsonObject(JSONObject jObject) throws JSONException {
        String ident = jObject.Properties().FirstOrDefault((String)"Ident").Value.toString();
        if (ident.equals("StiMillimetersUnit")) {
            return new StiMillimetersUnit();
        }
        if (ident.equals("StiInchesUnit")) {
            return new StiInchesUnit();
        }
        if (ident.equals("StiHundredthsOfInchUnit")) {
            return new StiHundredthsOfInchUnit();
        }
        if (ident.equals("StiCentimetersUnit")) {
            return new StiCentimetersUnit();
        }
        return null;
    }
}

