/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.styles;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.crossTab.StiCrossTab;
import com.stimulsoft.report.enums.StiStyleElements;
import com.stimulsoft.report.styles.StiBaseStyle;
import com.stimulsoft.report.styles.conditions.StiStyleConditionHelper;
import com.stimulsoft.report.styles.conditions.StiStyleConditionsCollection;

public class StiCrossTabStyle
extends StiBaseStyle {
    private StiColor color = StiColor.White;

    @StiSerializable
    public final StiColor getColor() {
        return this.color;
    }

    public final void setColor(StiColor value) {
        this.color = value;
    }

    public StiCrossTabStyle(String name, String description, StiReport report) {
        super(name, description, report);
    }

    public StiCrossTabStyle(String name, String description) {
        this(name, description, null);
    }

    public StiCrossTabStyle(String name) {
        this(name, "");
    }

    public StiCrossTabStyle() {
        this("");
    }

    @Override
    public void GetStyleFromComponent(StiComponent component, StiStyleElements styleElements) {
    }

    @Override
    public void SetStyleToComponent(StiComponent component) {
        StiCrossTab crossTab;
        StiCrossTab stiCrossTab = crossTab = component instanceof StiCrossTab ? (StiCrossTab)component : null;
        if (crossTab != null) {
            if (!StiStyleConditionHelper.isAllowStyle(component, this)) {
                return;
            }
            crossTab.setCrossTabStyleColor(this.getColor());
            crossTab.UpdateStyles();
        }
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyStringNullOfEmpty("Color", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.getColor(), (StiColorEnum)StiColorEnum.White));
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (!property.Name.equals("Color")) continue;
            this.color = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
        }
    }

    @Override
    public Object clone() {
        StiCrossTabStyle style = new StiCrossTabStyle();
        style.setColor(this.getColor().clone());
        style.setCollectionName(this.getCollectionName());
        style.setConditions((StiStyleConditionsCollection)this.getConditions().clone());
        style.setDescription(this.getDescription());
        style.setName(this.getName());
        return style;
    }
}

