/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.print;

import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.enums.StiPageOrientation;
import com.stimulsoft.report.print.StiPagePrintable;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.List;

public class StiPrintHelper {
    public static void printJob(PrinterJob printerJob, StiReport report) throws PrinterException {
        StiPrintHelper.printJob(printerJob, report, false);
    }

    public static void printJob(PrinterJob printerJob, StiReport report, Boolean showPrintDialog) throws PrinterException {
        if (showPrintDialog.booleanValue() && printerJob.printDialog() || !showPrintDialog.booleanValue()) {
            try {
                StiPrintHelper.preparePrinterJob(report.getRenderedPages(), printerJob);
                report.setIsPrinting(true);
                printerJob.print();
            }
            finally {
                report.setIsPrinting(false);
            }
        }
    }

    private static void preparePrinterJob(List<StiPage> pages, PrinterJob printerJob) {
        Book book = new Book();
        for (StiPage page : pages) {
            if (!(page.getDenyDrawSegmentMode() || page.getSegmentPerWidth() <= 1 && page.getSegmentPerHeight() <= 1)) {
                for (int segmentY = 0; segmentY < page.getSegmentPerHeight(); ++segmentY) {
                    for (int segmentX = 0; segmentX < page.getSegmentPerWidth(); ++segmentX) {
                        Double width = page.getUnit().ConvertToHInches(page.getWidth() / (double)page.getSegmentPerWidth() + page.getMargins().getLeft() + page.getMargins().getRight());
                        Double height = page.getUnit().ConvertToHInches(page.getHeight() / (double)page.getSegmentPerHeight() + page.getMargins().getTop() + page.getMargins().getBottom());
                        StiPrintHelper.appendPrintPage(printerJob, book, page, width, height, segmentX, segmentY);
                    }
                }
                continue;
            }
            Double width = page.getUnit().ConvertToHInches(page.getWidth() + page.getMargins().getLeft() + page.getMargins().getRight());
            Double height = page.getUnit().ConvertToHInches(page.getHeight() + page.getMargins().getTop() + page.getMargins().getBottom());
            StiPrintHelper.appendPrintPage(printerJob, book, page, width, height, -1, -1);
        }
        printerJob.setPageable(book);
    }

    private static void appendPrintPage(PrinterJob printerJob, Book book, StiPage page, double width, double height, int segmentX, int segmentY) {
        PageFormat documentPageFormat = printerJob.getPageFormat(null);
        Paper paper = printerJob.defaultPage().getPaper();
        paper.setImageableArea(0.0, 0.0, paper.getWidth(), paper.getHeight());
        documentPageFormat.setOrientation(page.getOrientation() == StiPageOrientation.Portrait ? 1 : 0);
        documentPageFormat.setPaper(paper);
        book.append(new StiPagePrintable(page, segmentX, segmentY, width, height), documentPageFormat);
    }
}

