/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters.indicator;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiPen;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.enums.StiBrushType;
import com.stimulsoft.report.components.enums.StiDataBarDirection;
import com.stimulsoft.report.components.indicators.StiDataBarIndicator;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.painters.indicator.StiIndicatorTypePainter;

public class StiDataBarIndicatorTypePainter
extends StiIndicatorTypePainter {
    @Override
    public StiRectangle paint(StiGraphics g, StiComponent component, StiRectangle rect) {
        StiText textComp = (StiText)component;
        Double zoom = component.getReport().getInfo().getZoom();
        Double pageZoom = component.getReport().getInfo().getPageZoom();
        StiRectangle rectComp = rect.clone();
        if (zoom > 1.0) {
            rectComp.inflate(Double.valueOf(-2.0 * zoom), Double.valueOf(-2.0 * zoom));
        } else {
            rectComp.inflate(Double.valueOf(-2.0), Double.valueOf(-2.0));
        }
        StiDataBarIndicator barIndicator = (StiDataBarIndicator)textComp.getIndicator();
        if (barIndicator != null && barIndicator.getValue() != 0.0f) {
            float totalWidth = barIndicator.getMaximum() + Math.abs(barIndicator.getMinimum());
            StiRectangle barRect = rectComp.clone();
            double minimumPart = barRect.getWidth() * (double)Math.abs(barIndicator.getMinimum()) / (double)totalWidth;
            double maximumPart = barRect.getWidth() * (double)barIndicator.getMaximum() / (double)totalWidth;
            double valuePart = barRect.getWidth() * (double)Math.abs(barIndicator.getValue()) / (double)totalWidth;
            StiDataBarDirection direction = barIndicator.getDirection();
            if (direction.equals((Object)StiDataBarDirection.Default)) {
                direction = component instanceof StiText ? (textComp.getTextOptions() != null && textComp.getTextOptions().getRightToLeft() ? StiDataBarDirection.RighToLeft : StiDataBarDirection.LeftToRight) : StiDataBarDirection.LeftToRight;
            }
            double angle = 0.0;
            if (direction.equals((Object)StiDataBarDirection.LeftToRight)) {
                if (barIndicator.getValue() < 0.0f) {
                    barRect.setX(barRect.getX() + minimumPart - valuePart);
                } else {
                    barRect.setX(barRect.getX() + minimumPart);
                }
                barRect.setWidth(valuePart);
            } else {
                angle = 180.0;
                if (barIndicator.getValue() < 0.0f) {
                    barRect.setX(barRect.getRight() - minimumPart);
                } else {
                    barRect.setX(barRect.getRight() - minimumPart - valuePart);
                }
                barRect.setWidth(valuePart);
            }
            if (barIndicator.getValue() < 0.0f) {
                angle += 180.0;
            }
            if (barRect.getWidth() > 0.0 && barRect.getHeight() > 0.0) {
                if (barIndicator.getBrushType().equals((Object)StiBrushType.Gradient)) {
                    StiRectangle fillRect = new StiRectangle(0.0, 0.0, 0.0, 0.0);
                    fillRect = direction.equals((Object)StiDataBarDirection.LeftToRight) ? (barIndicator.getValue() > 0.0f ? new StiRectangle(rect.getLeft() + minimumPart, rect.getTop(), maximumPart, rect.getHeight()) : new StiRectangle(rect.getLeft(), rect.getTop(), minimumPart, rect.getHeight())) : (barIndicator.getValue() < 0.0f ? new StiRectangle(rect.getLeft() + maximumPart, rect.getTop(), minimumPart, rect.getHeight()) : new StiRectangle(rect.getLeft(), rect.getTop(), maximumPart, rect.getHeight()));
                    if (barRect.getWidth() > 0.0 && barRect.getWidth() < 1.0) {
                        barRect.setWidth(1.0);
                    }
                    if (fillRect.getWidth() > 0.0 && fillRect.getWidth() < 1.0) {
                        fillRect.setWidth(1.0);
                    }
                    if (fillRect.getWidth() > 0.0 && barRect.getWidth() > 0.0) {
                        StiColor startColor = barIndicator.getValue() < 0.0f ? barIndicator.getNegativeColor() : barIndicator.getPositiveColor();
                        StiColor endColor = startColor.light(200);
                        fillRect.setX(fillRect.getX() - fillRect.getWidth() * 0.1);
                        fillRect.setWidth(fillRect.getWidth() + fillRect.getWidth() * 0.2);
                        StiGradientBrush gradientBrush = new StiGradientBrush(startColor, endColor, angle);
                        gradientBrush.setRectangle(fillRect);
                        g.drawRectangle(barRect, null, (StiBrush)gradientBrush, zoom, pageZoom);
                    }
                } else {
                    StiSolidBrush brush = new StiSolidBrush(barIndicator.getValue() < 0.0f ? barIndicator.getNegativeColor() : barIndicator.getPositiveColor());
                    g.drawRectangle(barRect, null, (StiBrush)brush, zoom, pageZoom);
                }
                if (barIndicator.getShowBorder()) {
                    StiPen pen = new StiPen(1.0, barIndicator.getValue() < 0.0f ? barIndicator.getNegativeBorderColor() : barIndicator.getPositiveBorderColor());
                    g.drawRectangle(barRect, pen, null, zoom, pageZoom);
                }
            }
        }
        return rect;
    }
}

