/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters.components;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiPen;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.simplecomponents.StiZipCode;
import com.stimulsoft.report.painters.StiPaintArgs;
import com.stimulsoft.report.painters.components.StiComponentPainter;

public class StiZipCodePainter
extends StiComponentPainter {
    private void drawHorizLineUp(StiGraphics g, StiRectangle drawRect, StiPen pen, Double zoom) {
        Double z = pen.getWidth() * zoom;
        if (pen.getDashStyle() == StiPenStyle.Solid) {
            z = pen.getWidth() * zoom / 2.0;
        }
        if (!StiOptions.Engine.isUseOldZipCodePaintMode()) {
            z = 0.0;
        }
        Double x1 = drawRect.getX() + z;
        Double y1 = drawRect.getY() + z;
        Double x2 = drawRect.getRight() - z;
        Double y2 = drawRect.getY() + z;
        g.drawLineXY(x1, y1, x2, y2, pen, zoom);
    }

    private void drawHorizLineCenter(StiGraphics g, StiRectangle drawRect, StiPen pen, Double zoom) {
        Double z = pen.getWidth() * zoom;
        if (pen.getDashStyle() == StiPenStyle.Solid) {
            z = pen.getWidth() * zoom / 2.0;
        }
        if (!StiOptions.Engine.isUseOldZipCodePaintMode()) {
            z = 0.0;
        }
        Double x1 = drawRect.getX() + z;
        Double y1 = drawRect.getY() + drawRect.getHeight() / 2.0;
        Double x2 = drawRect.getRight() - z;
        Double y2 = drawRect.getY() + drawRect.getHeight() / 2.0;
        g.drawLineXY(x1, y1, x2, y2, pen, zoom);
    }

    private void drawHorizLineDown(StiGraphics g, StiRectangle drawRect, StiPen pen, Double zoom) {
        Double z = pen.getWidth() * zoom;
        if (pen.getDashStyle() == StiPenStyle.Solid) {
            z = pen.getWidth() * zoom / 2.0;
        }
        if (!StiOptions.Engine.isUseOldZipCodePaintMode()) {
            z = 0.0;
        }
        Double x1 = drawRect.getX() + z;
        Double y1 = drawRect.getBottom() - z;
        Double x2 = drawRect.getRight() - z;
        Double y2 = drawRect.getBottom() - z;
        g.drawLineXY(x1, y1, x2, y2, pen, zoom);
    }

    private void drawVerticalLineUpRight(StiGraphics g, StiRectangle drawRect, StiPen pen, Double zoom) {
        Double z = pen.getWidth() * zoom;
        if (pen.getDashStyle() == StiPenStyle.Solid) {
            z = pen.getWidth() * zoom / 2.0;
        }
        if (!StiOptions.Engine.isUseOldZipCodePaintMode()) {
            z = 0.0;
        }
        Double x1 = drawRect.getRight() - z;
        Double y1 = drawRect.getY() + z;
        Double x2 = drawRect.getRight() - z;
        Double y2 = drawRect.getY() + drawRect.getHeight() / 2.0;
        g.drawLineXY(x1, y1, x2, y2, pen, zoom);
    }

    private void drawVerticalLineUpLeft(StiGraphics g, StiRectangle drawRect, StiPen pen, Double zoom) {
        Double z = pen.getWidth() * zoom;
        if (pen.getDashStyle() == StiPenStyle.Solid) {
            z = pen.getWidth() * zoom / 2.0;
        }
        if (!StiOptions.Engine.isUseOldZipCodePaintMode()) {
            z = 0.0;
        }
        Double x1 = drawRect.getX() + z;
        Double y1 = drawRect.getY() + z;
        Double x2 = drawRect.getX() + z;
        Double y2 = drawRect.getY() + drawRect.getHeight() / 2.0;
        g.drawLineXY(x1, y1, x2, y2, pen, zoom);
    }

    private void drawVerticalLineDownRight(StiGraphics g, StiRectangle drawRect, StiPen pen, Double zoom) {
        Double z = pen.getWidth() * zoom;
        if (pen.getDashStyle() == StiPenStyle.Solid) {
            z = pen.getWidth() * zoom / 2.0;
        }
        if (!StiOptions.Engine.isUseOldZipCodePaintMode()) {
            z = 0.0;
        }
        Double x1 = drawRect.getRight() - z;
        Double y1 = drawRect.getY() + drawRect.getHeight() / 2.0;
        Double x2 = drawRect.getRight() - z;
        Double y2 = drawRect.getBottom() - z;
        g.drawLineXY(x1, y1, x2, y2, pen, zoom);
    }

    private void drawVerticalLineDownLeft(StiGraphics g, StiRectangle drawRect, StiPen pen, Double zoom) {
        Double z = pen.getWidth() * zoom;
        if (pen.getDashStyle() == StiPenStyle.Solid) {
            z = pen.getWidth() * zoom / 2.0;
        }
        if (!StiOptions.Engine.isUseOldZipCodePaintMode()) {
            z = 0.0;
        }
        Double x1 = drawRect.getX() + z;
        Double y1 = drawRect.getY() + drawRect.getHeight() / 2.0;
        Double x2 = drawRect.getX() + z;
        Double y2 = drawRect.getBottom() - z;
        g.drawLineXY(x1, y1, x2, y2, pen, zoom);
    }

    private void drawDioganalLineUp(StiGraphics g, StiRectangle drawRect, StiPen pen, Double zoom) {
        Double z = pen.getWidth() * zoom;
        if (pen.getDashStyle() == StiPenStyle.Solid) {
            z = pen.getWidth() * zoom / 2.0;
        }
        if (!StiOptions.Engine.isUseOldZipCodePaintMode()) {
            z = 0.0;
        }
        Double x1 = drawRect.getRight() - z;
        Double y1 = drawRect.getY() + z;
        Double x2 = drawRect.getX() + z;
        Double y2 = drawRect.getY() + drawRect.getHeight() / 2.0;
        g.drawLineXY(x1, y1, x2, y2, pen, zoom);
    }

    private void drawDioganalLineDown(StiGraphics g, StiRectangle drawRect, StiPen pen, Double zoom) {
        Double z = pen.getWidth() * zoom;
        if (pen.getDashStyle() == StiPenStyle.Solid) {
            z = pen.getWidth() * zoom / 2.0;
        }
        if (!StiOptions.Engine.isUseOldZipCodePaintMode()) {
            z = 0.0;
        }
        Double x1 = drawRect.getRight() - z;
        Double y1 = drawRect.getY() + drawRect.getHeight() / 2.0;
        Double x2 = drawRect.getX() + z;
        Double y2 = drawRect.getBottom() - z;
        g.drawLineXY(x1, y1, x2, y2, pen, zoom);
    }

    private void drawIndex1(StiGraphics g, StiRectangle drawRect, StiPen penSolid, StiPen penDash, Double zoom) {
        this.drawHorizLineUp(g, drawRect, penDash, zoom / 2.5);
        this.drawHorizLineCenter(g, drawRect, penDash, zoom / 2.5);
        this.drawHorizLineDown(g, drawRect, penDash, zoom / 2.5);
        this.drawVerticalLineUpLeft(g, drawRect, penDash, zoom / 2.5);
        this.drawVerticalLineDownLeft(g, drawRect, penDash, zoom / 2.5);
        this.drawVerticalLineUpRight(g, drawRect, penSolid, zoom);
        this.drawVerticalLineDownRight(g, drawRect, penSolid, zoom);
        this.drawDioganalLineUp(g, drawRect, penSolid, zoom);
        this.drawDioganalLineDown(g, drawRect, penDash, zoom / 2.5);
    }

    private void drawIndex2(StiGraphics g, StiRectangle drawRect, StiPen penSolid, StiPen penDash, Double zoom) {
        this.drawHorizLineUp(g, drawRect, penSolid, zoom);
        this.drawHorizLineCenter(g, drawRect, penDash, zoom / 2.5);
        this.drawHorizLineDown(g, drawRect, penSolid, zoom);
        this.drawVerticalLineUpLeft(g, drawRect, penDash, zoom / 2.5);
        this.drawVerticalLineDownLeft(g, drawRect, penDash, zoom / 2.5);
        this.drawVerticalLineUpRight(g, drawRect, penSolid, zoom);
        this.drawVerticalLineDownRight(g, drawRect, penDash, zoom / 2.5);
        this.drawDioganalLineUp(g, drawRect, penDash, zoom / 2.5);
        this.drawDioganalLineDown(g, drawRect, penSolid, zoom);
    }

    private void drawIndex3(StiGraphics g, StiRectangle drawRect, StiPen penSolid, StiPen penDash, Double zoom) {
        this.drawHorizLineUp(g, drawRect, penSolid, zoom);
        this.drawHorizLineCenter(g, drawRect, penSolid, zoom);
        this.drawHorizLineDown(g, drawRect, penDash, zoom / 2.5);
        this.drawVerticalLineUpLeft(g, drawRect, penDash, zoom / 2.5);
        this.drawVerticalLineDownLeft(g, drawRect, penDash, zoom / 2.5);
        this.drawVerticalLineUpRight(g, drawRect, penDash, zoom / 2.5);
        this.drawVerticalLineDownRight(g, drawRect, penDash, zoom / 2.5);
        this.drawDioganalLineUp(g, drawRect, penSolid, zoom);
        this.drawDioganalLineDown(g, drawRect, penSolid, zoom);
    }

    private void drawIndex4(StiGraphics g, StiRectangle drawRect, StiPen penSolid, StiPen penDash, Double zoom) {
        this.drawHorizLineUp(g, drawRect, penDash, zoom / 2.5);
        this.drawHorizLineCenter(g, drawRect, penSolid, zoom);
        this.drawHorizLineDown(g, drawRect, penDash, zoom / 2.5);
        this.drawVerticalLineUpLeft(g, drawRect, penSolid, zoom);
        this.drawVerticalLineDownLeft(g, drawRect, penDash, zoom / 2.5);
        this.drawVerticalLineUpRight(g, drawRect, penSolid, zoom);
        this.drawVerticalLineDownRight(g, drawRect, penSolid, zoom);
        this.drawDioganalLineUp(g, drawRect, penDash, zoom / 2.5);
        this.drawDioganalLineDown(g, drawRect, penDash, zoom / 2.5);
    }

    private void drawIndex5(StiGraphics g, StiRectangle drawRect, StiPen penSolid, StiPen penDash, Double zoom) {
        this.drawHorizLineUp(g, drawRect, penSolid, zoom);
        this.drawHorizLineCenter(g, drawRect, penSolid, zoom);
        this.drawHorizLineDown(g, drawRect, penSolid, zoom);
        this.drawVerticalLineUpLeft(g, drawRect, penSolid, zoom);
        this.drawVerticalLineDownLeft(g, drawRect, penDash, zoom / 2.5);
        this.drawVerticalLineUpRight(g, drawRect, penDash, zoom / 2.5);
        this.drawVerticalLineDownRight(g, drawRect, penSolid, zoom);
        this.drawDioganalLineUp(g, drawRect, penDash, zoom / 2.5);
        this.drawDioganalLineDown(g, drawRect, penDash, zoom / 2.5);
    }

    private void drawIndex6(StiGraphics g, StiRectangle drawRect, StiPen penSolid, StiPen penDash, Double zoom) {
        this.drawHorizLineUp(g, drawRect, penDash, zoom / 2.5);
        this.drawHorizLineCenter(g, drawRect, penSolid, zoom);
        this.drawHorizLineDown(g, drawRect, penSolid, zoom);
        this.drawVerticalLineUpLeft(g, drawRect, penDash, zoom / 2.5);
        this.drawVerticalLineDownLeft(g, drawRect, penSolid, zoom);
        this.drawVerticalLineUpRight(g, drawRect, penDash, zoom / 2.5);
        this.drawVerticalLineDownRight(g, drawRect, penSolid, zoom);
        this.drawDioganalLineUp(g, drawRect, penSolid, zoom);
        this.drawDioganalLineDown(g, drawRect, penDash, zoom / 2.5);
    }

    private void drawIndex7(StiGraphics g, StiRectangle drawRect, StiPen penSolid, StiPen penDash, Double zoom) {
        this.drawHorizLineUp(g, drawRect, penSolid, zoom);
        this.drawHorizLineCenter(g, drawRect, penDash, zoom / 2.5);
        this.drawHorizLineDown(g, drawRect, penDash, zoom / 2.5);
        this.drawVerticalLineUpLeft(g, drawRect, penDash, zoom / 2.5);
        this.drawVerticalLineDownLeft(g, drawRect, penSolid, zoom);
        this.drawVerticalLineUpRight(g, drawRect, penDash, zoom / 2.5);
        this.drawVerticalLineDownRight(g, drawRect, penDash, zoom / 2.5);
        this.drawDioganalLineUp(g, drawRect, penSolid, zoom);
        this.drawDioganalLineDown(g, drawRect, penDash, zoom / 2.5);
    }

    private void drawIndex8(StiGraphics g, StiRectangle drawRect, StiPen penSolid, StiPen penDash, Double zoom) {
        this.drawHorizLineUp(g, drawRect, penSolid, zoom);
        this.drawHorizLineCenter(g, drawRect, penSolid, zoom);
        this.drawHorizLineDown(g, drawRect, penSolid, zoom);
        this.drawVerticalLineUpLeft(g, drawRect, penSolid, zoom);
        this.drawVerticalLineDownLeft(g, drawRect, penSolid, zoom);
        this.drawVerticalLineUpRight(g, drawRect, penSolid, zoom);
        this.drawVerticalLineDownRight(g, drawRect, penSolid, zoom);
        this.drawDioganalLineUp(g, drawRect, penDash, zoom / 2.5);
        this.drawDioganalLineDown(g, drawRect, penDash, zoom / 2.5);
    }

    private void drawIndex9(StiGraphics g, StiRectangle drawRect, StiPen penSolid, StiPen penDash, Double zoom) {
        this.drawHorizLineUp(g, drawRect, penSolid, zoom);
        this.drawHorizLineCenter(g, drawRect, penSolid, zoom);
        this.drawHorizLineDown(g, drawRect, penDash, zoom / 2.5);
        this.drawVerticalLineUpLeft(g, drawRect, penSolid, zoom);
        this.drawVerticalLineDownLeft(g, drawRect, penDash, zoom / 2.5);
        this.drawVerticalLineUpRight(g, drawRect, penSolid, zoom);
        this.drawVerticalLineDownRight(g, drawRect, penDash, zoom / 2.5);
        this.drawDioganalLineUp(g, drawRect, penDash, zoom / 2.5);
        this.drawDioganalLineDown(g, drawRect, penSolid, zoom);
    }

    private void drawIndex0(StiGraphics g, StiRectangle drawRect, StiPen penSolid, StiPen penDash, Double zoom) {
        this.drawHorizLineUp(g, drawRect, penSolid, zoom);
        this.drawHorizLineCenter(g, drawRect, penDash, zoom / 2.5);
        this.drawHorizLineDown(g, drawRect, penSolid, zoom);
        this.drawVerticalLineUpLeft(g, drawRect, penSolid, zoom);
        this.drawVerticalLineDownLeft(g, drawRect, penSolid, zoom);
        this.drawVerticalLineUpRight(g, drawRect, penSolid, zoom);
        this.drawVerticalLineDownRight(g, drawRect, penSolid, zoom);
        this.drawDioganalLineUp(g, drawRect, penDash, zoom / 2.5);
        this.drawDioganalLineDown(g, drawRect, penDash, zoom / 2.5);
    }

    private void drawIndexSpace(StiGraphics g, StiRectangle drawRect, StiPen penSolid, StiPen penDash, int count, int index, Double pageZoom) {
        double z = penSolid.getWidth() / 2.5;
        g.drawLineXY(Double.valueOf(drawRect.x - z), Double.valueOf(drawRect.y - z), Double.valueOf(drawRect.x + drawRect.width + z), Double.valueOf(drawRect.y - z), penSolid, pageZoom);
    }

    private void drawSpace(StiGraphics g, StiRectangle rect, StiPen penDash, Double zoom, Double pageZoom) {
        g.drawRectangle(rect, penDash, null, zoom, pageZoom);
        g.drawLineXY(Double.valueOf(rect.getX()), Double.valueOf(rect.getY() + rect.getHeight() / 2.0), Double.valueOf(rect.getX() + rect.getWidth()), Double.valueOf(rect.getY()), penDash, Double.valueOf(zoom / 2.5));
        g.drawLineXY(Double.valueOf(rect.getX()), Double.valueOf(rect.getY() + rect.getHeight() / 2.0), Double.valueOf(rect.getX() + rect.getWidth()), Double.valueOf(rect.getY() + rect.getHeight() / 2.0), penDash, Double.valueOf(zoom / 2.5));
        g.drawLineXY(Double.valueOf(rect.getX() + rect.getWidth()), Double.valueOf(rect.getY() + rect.getHeight() / 2.0), Double.valueOf(rect.getX()), Double.valueOf(rect.getY() + rect.getHeight()), penDash, Double.valueOf(zoom / 2.5));
    }

    public void drawZipCode(StiZipCode zipCode, StiGraphics g, StiRectangle rect, Double zoom) {
        String code;
        Double pageZoom = zipCode.getReport().getInfo().getPageZoom();
        if (zipCode.getBrush() instanceof StiSolidBrush && StiColorEnum.Transparent.color().equals(((StiSolidBrush)zipCode.getBrush()).getColor()) && zipCode.getReport().getInfo().getFillComponent() && zipCode.getIsDesigning()) {
            StiColor color = StiColor.fromAColor((int)150, (StiColor)StiColorEnum.White.color());
            g.drawRectangle(rect, null, (StiBrush)new StiSolidBrush(color), zoom, pageZoom);
        } else {
            g.drawRectangle(rect, null, zipCode.getBrush(), zoom, pageZoom);
        }
        StiPen penDash = new StiPen(1.0, zipCode.getForeColor(), StiPenStyle.Dot);
        StiPen penSolid = new StiPen(zipCode.getSize() * 2.0, zipCode.getForeColor(), StiPenStyle.Solid);
        penSolid.setCaps(1);
        code = zipCode.getCodeValue() != null ? (code = zipCode.getCodeValue()) : zipCode.getCode().getValue().replaceAll("[^\\d]", "");
        for (int index = 0; index < code.length(); ++index) {
            StiRectangle markRect = new StiRectangle();
            StiRectangle drawRect = zipCode.calculateRect(rect, code.length(), index, markRect);
            switch (code.charAt(index)) {
                case '1': {
                    this.drawIndex1(g, drawRect, penSolid, penDash, zoom);
                    break;
                }
                case '2': {
                    this.drawIndex2(g, drawRect, penSolid, penDash, zoom);
                    break;
                }
                case '3': {
                    this.drawIndex3(g, drawRect, penSolid, penDash, zoom);
                    break;
                }
                case '4': {
                    this.drawIndex4(g, drawRect, penSolid, penDash, zoom);
                    break;
                }
                case '5': {
                    this.drawIndex5(g, drawRect, penSolid, penDash, zoom);
                    break;
                }
                case '6': {
                    this.drawIndex6(g, drawRect, penSolid, penDash, zoom);
                    break;
                }
                case '7': {
                    this.drawIndex7(g, drawRect, penSolid, penDash, zoom);
                    break;
                }
                case '8': {
                    this.drawIndex8(g, drawRect, penSolid, penDash, zoom);
                    break;
                }
                case '9': {
                    this.drawIndex9(g, drawRect, penSolid, penDash, zoom);
                    break;
                }
                case '0': {
                    this.drawIndex0(g, drawRect, penSolid, penDash, zoom);
                    break;
                }
                case ' ': {
                    if (StiOptions.Engine.isUseOldZipCodePaintMode()) break;
                    this.drawIndexSpace(g, drawRect, penSolid, penDash, code.length(), index, zoom);
                }
            }
            if (!zipCode.getUpperMarks() || StiOptions.Engine.isUseOldZipCodePaintMode()) continue;
            g.drawRectangle(markRect, null, (StiBrush)new StiSolidBrush(penSolid.getColor()), zoom, pageZoom);
        }
    }

    @Override
    public void paint(StiComponent component, StiPaintArgs args) {
        StiZipCode zipCode = (StiZipCode)component;
        StiGraphics g = args.getG();
        StiRectangle rect = zipCode.getPaintRectangle();
        Double zoom = zipCode.getPage().getZoom();
        Double pageZoom = zipCode.getReport().getInfo().getPageZoom();
        Boolean topMost = args.getDrawTopmostBorderSides();
        if (rect.getWidth() > 0.0 && rect.getHeight() > 0.0 && args.intersectsWith(rect).booleanValue()) {
            if (!topMost.booleanValue()) {
                g.setTransformedClip(rect);
                this.drawZipCode(zipCode, g, rect, zoom);
                g.restoreClip();
                this.paintMarkers(zipCode, g, rect, zoom, pageZoom);
                this.paintBorder(zipCode, g, rect, topMost, args.isThumbPaint(), zoom, pageZoom);
                this.paintEvents(zipCode, g, rect);
                this.paintConditions(zipCode, g, rect);
            } else {
                this.paintBorder(zipCode, g, rect, topMost, args.isThumbPaint(), zoom, pageZoom);
            }
        }
    }
}

