/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters.components;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.enums.StiHighlightState;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.enums.StiQuickInfoType;
import com.stimulsoft.report.components.enums.StiTextQuality;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.painters.StiPaintArgs;
import com.stimulsoft.report.painters.components.StiComponentPainter;
import com.stimulsoft.report.painters.indicator.StiIndicatorTypePainter;
import java.io.IOException;

public class StiTextPainter
extends StiComponentPainter {
    public StiRectangle paintIndicator(StiText textComp, StiGraphics g, StiRectangle rect) {
        if (textComp.getIndicator() == null) {
            return rect;
        }
        StiIndicatorTypePainter painter = StiIndicatorTypePainter.getPainter(textComp.getIndicator());
        try {
            return painter.paint(g, textComp, rect);
        }
        catch (IOException e) {
            e.printStackTrace();
            return rect;
        }
    }

    public void paintText(StiText textComp, StiGraphics g, StiRectangle rect, Double zoom) {
        if (zoom == null) {
            zoom = textComp.getPage().getZoom();
        }
        String text = textComp.getTextInternal();
        if (textComp.getIsDesigning() && !textComp.getReport().getInfo().getQuickInfoOverlay() && !textComp.getReport().getInfo().getQuickInfoType().equals((Object)StiQuickInfoType.None)) {
            text = textComp.getQuickInfo();
        }
        if (text != null && text.length() > 0) {
            if (textComp.getAllowHtmlTags()) {
                g.drawHTMLText(text, rect, textComp.getFont(), StiBrush.ToColor((StiBrush)textComp.getTextBrush()), textComp.getHorAlignment(), textComp.getVertAlignment(), Boolean.valueOf(textComp.getWordWrap()), textComp.getLinesOfUnderline(), textComp.getBorder(), textComp.getTextOptions(), textComp.getLineSpacing(), zoom);
            } else {
                if (textComp.getTextQuality() == StiTextQuality.Standard) {
                    rect = rect.clone().inflate(Double.valueOf(-zoom.doubleValue()), Double.valueOf(-zoom.doubleValue()));
                }
                g.drawText(text, rect, textComp.getFont(), textComp.getTextBrush(), textComp.getHorAlignment(), textComp.getVertAlignment(), Boolean.valueOf(textComp.getWordWrap()), textComp.getLineSpacing(), zoom, textComp.getLinesOfUnderline(), textComp.getBorder(), textComp.getTextOptions());
            }
        }
    }

    public void paintBackground(StiText text, StiGraphics g, StiRectangle rect, Double zoom, Double pageZoom) {
        if (text.getBrush() instanceof StiSolidBrush && StiColor.Transparent.equals(StiSolidBrush.ToColor((StiBrush)text.getBrush())) && text.getReport().getInfo().getFillComponent() && text.getIsDesigning()) {
            StiColor color = StiColorEnum.White.color();
            color.setA(150);
            g.drawRectangle(rect, null, (StiBrush)new StiSolidBrush(color), Double.valueOf(0.0), zoom, pageZoom);
        } else {
            g.drawRectangle(rect, null, text.getBrush(), Double.valueOf(0.0), zoom, pageZoom);
        }
    }

    public void paintBorder(StiComponent component, StiGraphics g, StiRectangle rect, Boolean topMost, Boolean isThumbPaint, Double zoom) {
        super.paintBorder(component, g, rect, topMost, isThumbPaint, component.getReport().getInfo().getZoom(), component.getReport().getInfo().getPageZoom());
    }

    public Object getImage(StiComponent component, Double zoom, int format) {
        return null;
    }

    @Override
    public void paint(StiComponent component, StiPaintArgs args) {
        if (component.getEnabled() || component.getIsDesigning()) {
            StiGraphics g = args.getG();
            StiRectangle rect = component.getPaintRectangle();
            StiRectangle borderRect = rect.clone();
            Boolean topMost = args.getDrawTopmostBorderSides();
            if (rect.getWidth() > 0.0 && rect.getHeight() > 0.0 && args.intersectsWith(rect).booleanValue()) {
                StiText text = (StiText)component;
                if (!topMost.booleanValue()) {
                    this.paintBackground(text, g, rect, component.getReport().getInfo().getZoom(), component.getReport().getInfo().getPageZoom());
                    if (text.getHighlightState() == StiHighlightState.Hide && !text.getBorder().getSide().contains((IStiEnum)StiBorderSides.All)) {
                        this.paintMarkers(text, g, rect, text.getReport().getInfo().getZoom(), text.getReport().getInfo().getPageZoom());
                    }
                    rect = this.paintIndicator(text, g, rect);
                    rect = text.convertTextMargins(rect, true);
                    rect = text.convertTextBorders(rect, true);
                    this.paintText(text, g, rect, null);
                    this.paintBorder(text, g, borderRect, topMost, args.isThumbPaint(), null);
                } else {
                    this.paintBorder(text, g, borderRect, topMost, args.isThumbPaint(), null);
                }
            }
        }
    }
}

