/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters.components;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.enums.StiHighlightState;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.simplecomponents.StiRichText;
import com.stimulsoft.report.painters.StiPaintArgs;
import com.stimulsoft.report.painters.components.StiTextPainter;

public class StiRichTextPainter
extends StiTextPainter {
    @Override
    public void paint(StiComponent stiComponent, StiPaintArgs args) {
        if (stiComponent.getEnabled() || stiComponent.getIsDesigning()) {
            StiGraphics g = args.getG();
            StiRectangle rect = stiComponent.getPaintRectangle();
            Boolean topMost = args.getDrawTopmostBorderSides();
            StiRichText richText = (StiRichText)stiComponent;
            StiRectangle borderRect = rect.clone();
            if (rect.getWidth() > 0.0 && rect.getHeight() > 0.0 && args.intersectsWith(rect).booleanValue()) {
                if (!topMost.booleanValue()) {
                    g.drawRectangle(rect, null, (StiBrush)new StiSolidBrush(richText.getBackColor()), Double.valueOf(0.0), Double.valueOf(stiComponent.getReport().getInfo().getZoom()), Double.valueOf(stiComponent.getReport().getInfo().getPageZoom()));
                    rect = richText.convertTextMargins(rect, true);
                    g.drawRTFText(richText.unpackRTF(), rect, Double.valueOf(richText.getPage().getZoom()));
                    if (richText.getHighlightState() == StiHighlightState.Hide) {
                        this.paintBorder(richText, g, borderRect, topMost, args.isThumbPaint(), null);
                    }
                } else if (richText.getHighlightState() == StiHighlightState.Hide) {
                    this.paintBorder(richText, g, borderRect, topMost, args.isThumbPaint(), null);
                }
            }
        }
    }
}

