/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters.components;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiPen;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.drawing.path.StiPathLineTo;
import com.stimulsoft.base.drawing.path.StiPathMoveTo;
import com.stimulsoft.base.enums.StiHighlightState;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.simplecomponents.StiRectanglePrimitive;
import com.stimulsoft.report.painters.StiPaintArgs;
import com.stimulsoft.report.painters.components.StiLinePrimitivePainter;
import java.util.ArrayList;

public class StiRectanglePrimitivePainter
extends StiLinePrimitivePainter {
    protected void paintPrimitive(StiRectanglePrimitive primitive, StiGraphics g, StiRectangle rect) {
        Double zoom = primitive.getReport().getInfo().getZoom();
        Double pageZoom = primitive.getReport().getInfo().getPageZoom();
        if (!(primitive.getHighlightState() != StiHighlightState.Show && primitive.getHighlightState() != StiHighlightState.Active || primitive.getReport().getInfo().getIsComponentsMoving())) {
            StiPen pen2 = new StiPen(primitive.getSize(), StiColor.fromAColor((int)150, (StiColor)StiColorEnum.Gold.color()));
            ArrayList<Object> path = new ArrayList<Object>();
            path.add(new StiPathMoveTo(Double.valueOf(rect.getX()), Double.valueOf(rect.getY())));
            path.add(new StiPathLineTo(Double.valueOf(rect.getRight()), Double.valueOf(rect.getY())));
            path.add(new StiPathLineTo(Double.valueOf(rect.getRight()), Double.valueOf(rect.getBottom())));
            path.add(new StiPathLineTo(Double.valueOf(rect.getX()), Double.valueOf(rect.getBottom())));
            path.add(new StiPathLineTo(Double.valueOf(rect.getX()), Double.valueOf(rect.getY())));
            g.drawPath(path, pen2, null, zoom.doubleValue(), zoom.doubleValue());
        }
        StiPen pen = new StiPen(primitive.getSize(), primitive.getColor(), primitive.getStyle());
        if (primitive.getStyle() == StiPenStyle.Double) {
            StiBorder border = new StiBorder();
            border.setColor(primitive.getColor());
            border.setStyle(StiPenStyle.Double);
            border.setSide(StiBorderSides.None);
            if (primitive.getTopSide()) {
                border.setSide(border.getSide().OR((IStiEnum)StiBorderSides.Top));
            }
            if (primitive.getLeftSide()) {
                border.setSide(border.getSide().OR((IStiEnum)StiBorderSides.Left));
            }
            if (primitive.getBottomSide()) {
                border.setSide(border.getSide().OR((IStiEnum)StiBorderSides.Bottom));
            }
            if (primitive.getRightSide()) {
                border.setSide(border.getSide().OR((IStiEnum)StiBorderSides.Right));
            }
            border.draw(g, rect, zoom.doubleValue(), null, primitive.getHighlightState(), Boolean.valueOf(primitive.getReport().getIsPrinting()), Boolean.valueOf(false), pageZoom.doubleValue());
        } else if (primitive.getTopSide() && primitive.getLeftSide() && primitive.getBottomSide() && primitive.getRightSide()) {
            g.drawRectangle(rect, pen, null, zoom, pageZoom);
        } else {
            if (primitive.getTopSide()) {
                g.drawLineXY(Double.valueOf(rect.getX()), Double.valueOf(rect.getY()), Double.valueOf(rect.getRight()), Double.valueOf(rect.getY()), pen, zoom);
            }
            if (primitive.getBottomSide()) {
                g.drawLineXY(Double.valueOf(rect.getX()), Double.valueOf(rect.getBottom()), Double.valueOf(rect.getRight()), Double.valueOf(rect.getBottom()), pen, zoom);
            }
            if (primitive.getLeftSide()) {
                g.drawLineXY(Double.valueOf(rect.getX()), Double.valueOf(rect.getY()), Double.valueOf(rect.getX()), Double.valueOf(rect.getBottom()), pen, zoom);
            }
            if (primitive.getRightSide()) {
                g.drawLineXY(Double.valueOf(rect.getRight()), Double.valueOf(rect.getY()), Double.valueOf(rect.getRight()), Double.valueOf(rect.getBottom()), pen, zoom);
            }
        }
    }

    @Override
    public void paint(StiComponent component, StiPaintArgs args) {
        StiRectanglePrimitive primitive = (StiRectanglePrimitive)component;
        if ((component.getEnabled() || component.getIsDesigning()) && !args.getDrawTopmostBorderSides().booleanValue()) {
            StiGraphics g = args.getG();
            StiRectangle rect = component.getPaintRectangle();
            this.checkRectForOverflow(rect);
            if (rect.getWidth() > 0.0 && rect.getHeight() > 0.0 && args.intersectsWith(rect).booleanValue()) {
                this.paintPrimitive(primitive, g, rect);
                this.paintEvents(primitive, g, rect);
                this.paintConditions(primitive, g, rect);
            }
        }
    }

    @Override
    public void paintSelection(StiComponent component, StiPaintArgs args) {
        StiGraphics g = args.getG();
        if (component.getIsDesigning() && component.getIsSelected() && !component.getReport().getInfo().getIsComponentsMoving()) {
            StiRectangle rect = component.getPaintRectangle();
            Double zoom = component.getReport().getInfo().getZoom();
            Double pageZoom = component.getReport().getInfo().getPageZoom();
            StiPen pen = StiPen.DIM_GRAY;
            if (component.getLocked()) {
                pen = StiPen.RED;
            }
            Double size = 3.5;
            if (component.getLinked()) {
                size = 4.7;
            }
            this.drawDot(g, pen, rect.getX(), rect.getY(), size, zoom, pageZoom);
            this.drawDot(g, pen, rect.getRight(), rect.getY(), size, zoom, pageZoom);
            this.drawDot(g, pen, rect.getX(), rect.getBottom(), size, zoom, pageZoom);
            this.drawDot(g, pen, rect.getRight(), rect.getBottom(), size, zoom, pageZoom);
            this.drawDot(g, pen, rect.getX() + rect.getWidth() / 2.0, rect.getY(), size, zoom, pageZoom);
            this.drawDot(g, pen, rect.getRight(), rect.getY() + rect.getHeight() / 2.0, size, zoom, pageZoom);
            this.drawDot(g, pen, rect.getX() + rect.getWidth() / 2.0, rect.getBottom(), size, zoom, pageZoom);
            this.drawDot(g, pen, rect.getX(), rect.getY() + rect.getHeight() / 2.0, size, zoom, pageZoom);
        }
    }
}

