/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters.components;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.enums.StiHighlightState;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.signature.StiPdfDigitalSignature;
import com.stimulsoft.report.painters.StiPaintArgs;
import com.stimulsoft.report.painters.components.StiComponentPainter;

public class StiPdfDigitalSignaturePainter
extends StiComponentPainter {
    @Override
    public void paint(StiComponent stiComponent, StiPaintArgs e) {
        StiPdfDigitalSignature signature = (StiPdfDigitalSignature)stiComponent;
        signature.invokePainting(signature, e);
        Double zoom = signature.getPage().getZoom();
        Double pageZoom = signature.getReport().getInfo().getPageZoom();
        if (signature.getEnabled() || signature.isDesigning()) {
            StiGraphics g = e.getG();
            StiRectangle rect = signature.getPaintRectangle();
            if (rect.width > 0.0 && rect.height > 0.0 && (e.getClipRectangles().isEmpty() || rect.intersectsWith(rect).booleanValue())) {
                this.paintSignature(signature, g, rect, e.getDrawTopmostBorderSides());
                if (signature.getHighlightState() == StiHighlightState.Hide && !signature.getBorder().getSide().contains((IStiEnum)StiBorderSides.All)) {
                    this.paintMarkers(signature, g, rect, zoom, pageZoom);
                }
            }
        }
    }

    private void paintSignature(StiPdfDigitalSignature signature, StiGraphics g, StiRectangle rect, boolean drawBorder) {
        this.drawSignature(signature, g, rect);
        Double zoom = signature.getPage().getZoom();
        Double pageZoom = signature.getReport().getInfo().getPageZoom();
        if ((drawBorder && signature.getBorder().getTopmost() || !signature.getBorder().getTopmost()) && signature.getHighlightState() == StiHighlightState.Hide) {
            this.paintBorder(signature, g, rect, drawBorder, true, zoom, pageZoom);
        }
    }

    private void drawSignature(StiPdfDigitalSignature signature, StiGraphics g, StiRectangle rect) {
        Double zoom = signature.getPage().getZoom();
        Double pageZoom = signature.getReport().getInfo().getPageZoom();
        StiBrush brush = StiBrush.getBrush((StiBrush)signature.brush, (StiRectangle)rect);
        g.drawRectangle(rect, null, brush, zoom, pageZoom);
        StiFont font = new StiFont("Segoe UI", 10.0);
        String text = signature.getPlaceholder();
        if (StiValidationUtil.isNullOrEmpty((String)text)) {
            text = StiLocalization.Get((String)"Signature", (String)"DigitalSignatureEmptyWatermark");
        }
        g.drawText(text, rect, font, (StiBrush)new StiSolidBrush(StiColorEnum.Red), StiTextHorAlignment.Center, StiVertAlignment.Center, Boolean.valueOf(true), 1.0f, zoom, null, null, null);
    }
}

