/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.StringFormat;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.infographics.gauge.StiGauge;
import com.stimulsoft.report.painters.context.gauge.geoms.StiEllipseGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGraphicsArcGeometryGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGraphicsPathGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiPieGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiPopTranformGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiPushMatrixGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiRadialRangeGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiRectangleGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiRoundedRectangleGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiTextGaugeGeom;
import java.util.ArrayList;
import java.util.List;

public abstract class StiGaugeContextPainter {
    public double zoom;
    public double pageZoom;
    public StiRectangle rect;
    public StiGauge gauge;
    public List<StiGaugeGeom> geoms = new ArrayList<StiGaugeGeom>();

    public static StiFont changeFontSize(StiFont font, double zoom) {
        double newFontSize = font.size * zoom;
        if (newFontSize < 1.0) {
            newFontSize = 1.0;
        }
        return new StiFont(font.getName(), newFontSize, font.getStyle(), font.getUnit());
    }

    public abstract StiSize measureString(String var1, StiFont var2);

    public void addPieGaugeGeom(StiRectangle rect, StiBrush background, StiBrush borderBrush, double borderWidth, double startAngle, double sweepAngle) {
        if (rect.width > 0.0 && rect.height > 0.0) {
            this.geoms.add(new StiPieGaugeGeom(rect, background, borderBrush, borderWidth, startAngle, sweepAngle));
        }
    }

    public void addEllipseGaugeGeom(StiRectangle rect, StiBrush background, StiBrush borderBrush, double borderWidth) {
        if (rect.width > 0.0 && rect.height > 0.0) {
            this.geoms.add(new StiEllipseGaugeGeom(rect, background, borderBrush, borderWidth));
        }
    }

    public void addGraphicsArcGeometryGaugeGeom(StiRectangle rect, StiBrush background, StiBrush borderBrush, double borderWidth, double startAngle, double sweepAngle, double startWidth, double endWidth) {
        if (rect.width > 0.0 && rect.height > 0.0) {
            this.geoms.add(new StiGraphicsArcGeometryGaugeGeom(rect, background, borderBrush, borderWidth, startAngle, sweepAngle, startWidth, endWidth));
        }
    }

    public void addPopTranformGaugeGeom() {
        this.geoms.add(new StiPopTranformGaugeGeom());
    }

    public void addPushMatrixGaugeGeom(double angle, StiPoint centerPoint) {
        this.geoms.add(new StiPushMatrixGaugeGeom(angle, centerPoint));
    }

    public void addRadialRangeGaugeGeom(StiRectangle rect, StiBrush background, StiBrush borderBrush, double borderWidth, StiPoint centerPoint, double startAngle, double sweepAngle, double radius1, double radius2, double radius3, double radius4) {
        if (rect.width > 0.0 && rect.height > 0.0) {
            this.geoms.add(new StiRadialRangeGaugeGeom(rect, background, borderBrush, borderWidth, centerPoint, startAngle, sweepAngle, radius1, radius2, radius3, radius4));
        }
    }

    public void addRectangleGaugeGeom(StiRectangle rect, StiBrush background, StiBrush borderBrush, double borderWidth) {
        if (rect.width > 0.0 && rect.height > 0.0) {
            this.geoms.add(new StiRectangleGaugeGeom(rect, background, borderBrush, borderWidth));
        }
    }

    public void addRoundedRectangleGaugeGeom(StiRectangle rect, StiBrush background, StiBrush borderBrush, double borderWidth, int leftTop, int rightTop, int rightBottom, int leftBottom) {
        if (rect.width > 0.0 && rect.height > 0.0) {
            this.geoms.add(new StiRoundedRectangleGaugeGeom(rect, background, borderBrush, borderWidth, leftTop, rightTop, rightBottom, leftBottom));
        }
    }

    public void addTextGaugeGeom(String text, StiFont font, StiBrush foreground, StiRectangle rect, StringFormat sf) {
        if (rect.width > 0.0 && rect.height > 0.0) {
            this.geoms.add(new StiTextGaugeGeom(text, font, foreground, rect, sf));
        }
    }

    public void addGraphicsPathGaugeGeom(StiGraphicsPathGaugeGeom geom) {
        if (geom.Rect.width > 0.0 && geom.Rect.height > 0.0) {
            this.geoms.add(geom);
        }
    }

    public abstract void render();

    public StiGaugeContextPainter(StiGauge gauge, StiRectangle rect, double zoom, double pageZoom) {
        this.gauge = gauge;
        this.rect = rect;
        this.zoom = zoom;
        this.pageZoom = pageZoom;
    }
}

