/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.maps.gis;

import com.stimulsoft.report.maps.gis.StiGisPoint;
import com.stimulsoft.report.maps.gis.StiGisTile;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public final class StiGisTileMatrix
implements Closeable {
    private ArrayList<HashMap<StiGisPoint, StiGisTile>> layers = new ArrayList(24);

    public StiGisTileMatrix() {
        for (int index = 0; index < 24; ++index) {
            this.layers.add(new HashMap());
        }
    }

    protected void finalize() throws Throwable {
        this.Dispose(false);
    }

    public void clearAllLevels() {
        if (this.layers == null) {
            return;
        }
        for (HashMap<StiGisPoint, StiGisTile> layer : this.layers) {
            for (StiGisTile pair : layer.values()) {
                pair.Dispose();
            }
            layer.clear();
        }
    }

    public void clearLevelsBelove(int zoom) {
        if (zoom - 1 < this.layers.size()) {
            for (int index = zoom - 1; index >= 0; --index) {
                HashMap<StiGisPoint, StiGisTile> layer = this.layers.get(index);
                Collection<StiGisTile> values = layer.values();
                for (StiGisTile value : values) {
                    value.Dispose();
                }
                layer.clear();
            }
        }
    }

    public void clearLevelsAbove(int zoom) {
        if (zoom + 1 < this.layers.size()) {
            for (int index = zoom + 1; index < this.layers.size(); ++index) {
                HashMap<StiGisPoint, StiGisTile> layer = this.layers.get(index);
                Collection<StiGisTile> values = layer.values();
                for (StiGisTile value : values) {
                    value.Dispose();
                }
                layer.clear();
            }
        }
    }

    public boolean contains(int zoom, StiGisPoint p) {
        return this.layers.get(zoom).containsKey(p);
    }

    public StiGisTile get(int zoom, StiGisPoint p) {
        StiGisTile ret = new StiGisTile();
        ret = this.layers.get(zoom).get(p);
        if (ret == null) {
            ret = new StiGisTile();
        }
        return ret;
    }

    public void set(StiGisTile t) {
        if (t.getZoom() < this.layers.size()) {
            this.layers.get(t.getZoom()).put(t.getPos(), t);
        }
    }

    public void Dispose(boolean disposing) {
        if (disposing) {
            this.clearAllLevels();
        }
        if (this.layers != null) {
            this.layers.clear();
        }
        this.layers = null;
    }

    @Override
    public void close() {
        this.Dispose(true);
        System.gc();
    }
}

