/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.maps.gis;

import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.helpers.StiFontIconsHelper;
import com.stimulsoft.report.maps.gis.StiGisCore;
import com.stimulsoft.report.maps.gis.StiGisPoint;
import com.stimulsoft.report.maps.gis.StiGisPointLatLng;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public final class StiGisPointMapGeometry {
    private StiGisPointLatLng point = new StiGisPointLatLng();
    private StiGisPoint localPoint = new StiGisPoint();
    private StiRectangle iconArea = StiRectangle.empty();
    private String text;
    private boolean showPlacemark;

    public StiGisPointMapGeometry(StiGisPointLatLng point) {
        this.point = point.clone();
    }

    public StiGisPointMapGeometry(double lat, double lng) {
        this.point = new StiGisPointLatLng(lat, lng);
    }

    public String getText() {
        return this.text;
    }

    private void setText(String value) {
        this.text = value;
    }

    public boolean getShowPlacemark() {
        return this.showPlacemark;
    }

    private void setShowPlacemark(boolean value) {
        this.showPlacemark = value;
    }

    public void setDescription(String text) {
        this.setText(text);
        this.setShowPlacemark(!StiValidationUtil.isNullOrEmpty((String)text));
    }

    public boolean contains(StiPoint pos) {
        return this.iconArea.contains(pos);
    }

    public void draw(Graphics2D g, StiGisCore core) {
        if (this.iconArea.isEmpty().booleanValue()) {
            try {
                String fontFamilyIcons = StiFontIconsHelper.getFontFamilyIcons();
                Font font = new Font(fontFamilyIcons, 0, 17);
                String text = StiFontIconsHelper.getContent(core.getIcon());
                Rectangle2D rect = g.getFontMetrics(font).getStringBounds(text, g);
                g.setFont(font);
                g.setColor(core.getIconColorGdi().getAwtColor());
                g.drawString(text, (int)((double)this.localPoint.getX() - rect.getWidth() / 2.0), this.localPoint.getY());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void updateLocalPosition(StiGisCore core) {
        StiGisPoint p = core.fromLatLngToLocal(this.point);
        p.offsetNegative(core.renderOffset);
        this.localPoint = p.clone();
        this.iconArea = StiRectangle.empty();
    }

    public void getAllPoints(StiRefObject<ArrayList<StiGisPointLatLng>> points) {
        ((ArrayList)points.argvalue).add(this.point.clone());
    }
}

