/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.maps.gis;

import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.report.maps.gis.StiGisCore;
import com.stimulsoft.report.maps.gis.StiGisPointLatLng;
import com.stimulsoft.report.maps.gis.StiGisPointMapGeometry;
import java.awt.Graphics2D;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;

public final class StiGisMapViewData
implements Closeable {
    private StiGisCore core;
    public final ArrayList<StiGisPointMapGeometry> geoms = new ArrayList();
    public final ArrayList<StiGisPointMapGeometry> placemarks = new ArrayList();

    public StiGisMapViewData(StiGisCore core) {
        this.core = core;
    }

    public void clear() {
        this.geoms.clear();
    }

    public void forceUpdate() {
        for (StiGisPointMapGeometry geom : this.geoms) {
            geom.updateLocalPosition(this.core);
        }
    }

    public void draw(Graphics2D g) {
        for (StiGisPointMapGeometry geom : this.geoms) {
            geom.draw(g, this.core);
        }
    }

    public ArrayList<StiGisPointLatLng> getAllPoints() {
        ArrayList points = new ArrayList();
        for (StiGisPointMapGeometry geom : this.geoms) {
            StiRefObject tempRefPoints = new StiRefObject(points);
            geom.getAllPoints((StiRefObject<ArrayList<StiGisPointLatLng>>)tempRefPoints);
            points = (ArrayList)tempRefPoints.argvalue;
        }
        return points;
    }

    @Override
    public void close() throws IOException {
        this.geoms.clear();
        this.core = null;
    }
}

