/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.maps.gis;

import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.maps.gis.StiGisCore;
import com.stimulsoft.report.maps.gis.StiGisDrawTile;
import com.stimulsoft.report.maps.gis.StiGisMapData;
import com.stimulsoft.report.maps.gis.StiGisMapImage;
import com.stimulsoft.report.maps.gis.StiGisMapViewData;
import com.stimulsoft.report.maps.gis.StiGisPoint;
import com.stimulsoft.report.maps.gis.StiGisPointLatLng;
import com.stimulsoft.report.maps.gis.StiGisPointMapGeometry;
import com.stimulsoft.report.maps.gis.StiGisRectLatLng;
import com.stimulsoft.report.maps.gis.StiGisTile;
import com.stimulsoft.report.maps.gis.StiOpenStreetMapProvider;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public final class StiGisMapSimpleView {
    private StiGisCore core = new StiGisCore();
    private StiGisMapViewData viewData;
    private ArrayList<StiGisPointMapGeometry> points;
    private StiSize size;
    private int zoom;
    private boolean isComplete;

    public StiGisMapSimpleView(StiGisMapData data) {
        this.size = data.getSize();
        this.points = data.getPoints();
        this.zoom = data.getZoom();
        this.core.setProvider(new StiOpenStreetMapProvider());
        this.core.allowLocalCache = true;
        this.core.setIcon(data.getIcon());
        this.core.setIconColor(data.getIconColor());
        this.core.initGeometryColor(data.getGeometryColor(), data.getGeometryLineSize());
        this.viewData = new StiGisMapViewData(this.core);
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    private void setComplete(boolean value) {
        this.isComplete = value;
    }

    public void runAndWait() {
        this.setComplete(false);
        try {
            this.core.setZoom(8);
            this.core.onMapSizeChanged((int)this.size.width, (int)this.size.height);
            this.initGeoCommands();
            if (this.zoom != 0) {
                this.core.setZoom(this.zoom);
            }
            this.updateBounds();
            this.loadImages();
            this.setComplete(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setComplete(false);
        }
    }

    private void initGeoCommands() {
        this.viewData.clear();
        this.viewData.geoms.addAll(this.points);
        StiGisRectLatLng rect = this.getRectOfAllGeoms();
        if (rect != null) {
            this.core.setZoomToFitRect(rect);
        }
        this.viewData.forceUpdate();
    }

    private StiGisRectLatLng getRectOfAllGeoms() {
        ArrayList<StiGisPointLatLng> points = this.viewData.getAllPoints();
        if (points.isEmpty()) {
            return null;
        }
        double left = Double.MAX_VALUE;
        double top = -1.7976931348623157E308;
        double right = -1.7976931348623157E308;
        double bottom = Double.MAX_VALUE;
        for (StiGisPointLatLng point : points) {
            if (point.getLng() < left) {
                left = point.getLng();
            }
            if (point.getLat() > top) {
                top = point.getLat();
            }
            if (point.getLng() > right) {
                right = point.getLng();
            }
            if (!(point.getLat() < bottom)) continue;
            bottom = point.getLat();
        }
        if (left != Double.MAX_VALUE && right != -1.7976931348623157E308 && top != -1.7976931348623157E308 && bottom != Double.MAX_VALUE) {
            return StiGisRectLatLng.fromLTRB(left, top, right, bottom);
        }
        return null;
    }

    private void updateBounds() {
        this.core.tileDrawingList.clear();
        StiRectangle screenRect = new StiRectangle(new StiPoint(0.0, 0.0), this.size);
        int countI = this.core.sizeOfMapArea.getWidth();
        for (int indexX = -this.core.sizeOfMapArea.getWidth(); indexX < countI; ++indexX) {
            int countJ = this.core.sizeOfMapArea.getHeight();
            for (int indexY = -this.core.sizeOfMapArea.getHeight(); indexY < countJ; ++indexY) {
                StiRectangle tileRect;
                StiGisPoint p = this.core.centerTileXYLocation.clone();
                p.setX(p.getX() + indexX);
                p.setY(p.getY() + indexY);
                if (p.getX() < this.core.minOfTiles.getWidth() || p.getY() < this.core.minOfTiles.getHeight() || p.getX() > this.core.maxOfTiles.getWidth() || p.getY() > this.core.maxOfTiles.getHeight() || !screenRect.IntersectsWith(tileRect = new StiRectangle((long)(p.getX() * this.core.tileRect.getWidth() - this.core.compensationOffset.getX() + this.core.renderOffset.getX()), (long)(p.getY() * this.core.tileRect.getHeight() - this.core.compensationOffset.getY() + this.core.renderOffset.getY()), (long)this.core.tileRect.getWidth(), (long)this.core.tileRect.getHeight()))) continue;
                StiGisDrawTile dt = new StiGisDrawTile();
                dt.posXY = p.clone();
                dt.posPixel = new StiGisPoint(p.getX() * this.core.tileRect.getWidth(), p.getY() * this.core.tileRect.getHeight());
                dt.distanceSqr = (this.core.centerTileXYLocation.getX() - p.getX()) * (this.core.centerTileXYLocation.getX() - p.getX()) + (this.core.centerTileXYLocation.getY() - p.getY()) * (this.core.centerTileXYLocation.getY() - p.getY());
                if (this.core.tileDrawingList.contains(dt)) continue;
                this.core.tileDrawingList.add(dt.clone());
            }
        }
        this.goToCurrentPosition();
    }

    private void goToCurrentPosition() {
        this.core.compensationOffset = this.core.positionPixel;
        this.core.renderOffset = StiGisPoint.empty();
        StiGisPoint d = new StiGisPoint(this.core.width / 2, this.core.height / 2);
        this.core.renderOffset.setX(d.getX());
        this.core.renderOffset.setY(d.getY());
        StiGisPointLatLng center = this.core.fromLocalToLatLng(this.core.width / 2, this.core.height / 2);
        StiGisPoint centerPixel = this.core.getProvider().getProjection().fromLatLngToPixel(center, this.core.getZoom());
        this.core.centerTileXYLocation = this.core.getProvider().getProjection().fromPixelToTileXY(centerPixel);
        if (!StiValidationUtil.equals((Object)this.core.centerTileXYLocation, (Object)this.core.centerTileXYLocationLast)) {
            this.core.centerTileXYLocationLast = this.core.centerTileXYLocation;
            this.updateBounds();
        }
    }

    private void loadImages() {
        StiGisDrawTile[] list;
        int zoom = this.core.getZoom();
        for (StiGisDrawTile p : list = this.core.tileDrawingList.toArray(new StiGisDrawTile[0])) {
            if (this.core.matrix.contains(zoom, p.posXY)) continue;
            this.loadImage(p.posXY, zoom);
        }
    }

    private void loadImage(StiGisPoint pos, int zoom) {
        try {
            StiGisTile m = this.core.matrix.get(zoom, pos);
            if (!m.notEmpty) {
                StiGisTile tile = new StiGisTile(zoom, pos);
                StiGisMapImage img = null;
                StiOpenStreetMapProvider provider = this.core.getProvider();
                if (zoom >= provider.getMinZoom() && zoom <= provider.getMaxZoom()) {
                    img = this.core.getImageFrom(provider, pos, zoom);
                }
                if (img != null) {
                    tile.image = img;
                    this.core.matrix.set(tile);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawMap(Graphics2D g, BufferedImage image) {
        if (!this.isComplete()) {
            return;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setColor(Color.white);
        g.fillRect(0, 0, (int)this.size.width, (int)this.size.height);
        g.translate(this.core.renderOffset.getX(), this.core.renderOffset.getY());
        for (StiGisDrawTile tilePoint : this.core.tileDrawingList) {
            this.core.tileRect.setLocation(tilePoint.posPixel.clone());
            this.core.tileRect.offsetNegative(this.core.compensationOffset.clone());
            StiGisTile t = this.core.matrix.get(this.core.getZoom(), tilePoint.posXY);
            if (!t.notEmpty || t.image == null || t.image.bitmapGdi == null) continue;
            g.drawImage((Image)t.image.bitmapGdi, this.core.tileRect.getX(), this.core.tileRect.getY(), null);
        }
        this.drawOverlays(g);
    }

    private void drawOverlays(Graphics2D g) {
        this.viewData.draw(g);
    }
}

