/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.maps.gis;

import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.report.helpers.StiFontIcons;
import com.stimulsoft.report.maps.gis.StiGisDrawTile;
import com.stimulsoft.report.maps.gis.StiGisMapImage;
import com.stimulsoft.report.maps.gis.StiGisPoint;
import com.stimulsoft.report.maps.gis.StiGisPointLatLng;
import com.stimulsoft.report.maps.gis.StiGisRect;
import com.stimulsoft.report.maps.gis.StiGisRectLatLng;
import com.stimulsoft.report.maps.gis.StiGisSize;
import com.stimulsoft.report.maps.gis.StiGisTileMatrix;
import com.stimulsoft.report.maps.gis.StiOpenStreetMapProvider;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;

public final class StiGisCore
implements Closeable {
    public static final int LevelsKeepInMemmory = 5;
    public boolean allowLocalCache;
    public StiGisPointLatLng position = new StiGisPointLatLng(38.90813299596704, -77.01416015624999);
    public StiGisPoint positionPixel = new StiGisPoint();
    public StiGisPoint renderOffset = new StiGisPoint();
    public StiGisPoint centerTileXYLocation = new StiGisPoint();
    public StiGisPoint centerTileXYLocationLast = new StiGisPoint();
    public StiGisPoint compensationOffset = new StiGisPoint();
    public StiGisSize sizeOfMapArea = new StiGisSize();
    public StiGisSize minOfTiles = new StiGisSize();
    public StiGisSize maxOfTiles = new StiGisSize();
    public StiGisRect tileRect = new StiGisRect();
    public StiGisTileMatrix matrix = new StiGisTileMatrix();
    public ArrayList<StiGisDrawTile> tileDrawingList = new ArrayList();
    public int width;
    public int height;
    public boolean isDragging;
    public boolean zoomToArea = true;
    public boolean mouseWheelZooming;
    public volatile int okZoom = 0;
    public volatile int skipOverZoom = 0;
    public volatile boolean isStarted;
    public boolean updatingBounds;
    public StiColor geometryColor;
    public double geometryLineSize;
    private String languageStr = "en";
    private StiFontIcons icon = StiFontIcons.values()[0];
    private StiColor iconColor;
    private int zoom = 8;
    private StiOpenStreetMapProvider provider;

    protected void finalize() throws Throwable {
        this.Dispose(false);
    }

    public String getLanguageStr() {
        return this.languageStr;
    }

    public StiFontIcons getIcon() {
        return this.icon;
    }

    public void setIcon(StiFontIcons value) {
        this.icon = value;
    }

    public StiColor getIconColor() {
        return this.iconColor;
    }

    public void setIconColor(StiColor value) {
        this.iconColor = value;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int value) {
        if (this.zoom != value && !this.isDragging) {
            this.zoom = value;
            this.minOfTiles = this.provider.getProjection().getTileMatrixMinXY(value);
            this.maxOfTiles = this.provider.getProjection().getTileMatrixMaxXY(value);
            this.positionPixel = this.provider.getProjection().fromLatLngToPixel(this.getPosition(), value);
            this.cancelAsyncTasks();
            this.matrix.clearLevelsBelove(this.zoom - 5);
            this.matrix.clearLevelsAbove(this.zoom + 5);
            this.goToCurrentPositionOnZoom();
        }
    }

    public StiGisPointLatLng getPosition() {
        return this.position.clone();
    }

    public void setPosition(StiGisPointLatLng value) {
        this.position = value.clone();
        this.positionPixel = this.provider.getProjection().fromLatLngToPixel(value, this.getZoom());
    }

    public StiOpenStreetMapProvider getProvider() {
        return this.provider;
    }

    public void setProvider(StiOpenStreetMapProvider value) {
        if (this.provider == null) {
            boolean diffProjection = this.provider == null || this.provider.getProjection() != value.getProjection();
            this.provider = value;
            if (!this.provider.isInitialized()) {
                this.provider.setInitialized(true);
            }
            if (this.provider.getProjection() != null && diffProjection) {
                this.tileRect = new StiGisRect(StiGisPoint.empty(), new StiGisSize(this.provider.getProjection().getTileSize(), this.provider.getProjection().getTileSize()));
                this.minOfTiles = this.provider.getProjection().getTileMatrixMinXY(this.getZoom());
                this.maxOfTiles = this.provider.getProjection().getTileMatrixMaxXY(this.getZoom());
                this.positionPixel = this.provider.getProjection().fromLatLngToPixel(this.getPosition(), this.getZoom());
            }
            this.cancelAsyncTasks();
            if (diffProjection) {
                this.onMapSizeChanged(this.width, this.height);
            }
            this.reloadMap();
            this.zoomToArea = true;
            if (this.provider.area != null && !this.provider.area.contains(this.getPosition())) {
                this.setZoomToFitRect(this.provider.area);
                this.zoomToArea = false;
            }
        }
    }

    public StiGisRectLatLng getViewArea() {
        if (this.provider != null && this.provider.getProjection() != null) {
            StiGisPointLatLng p = this.fromLocalToLatLng(0, 0);
            StiGisPointLatLng p2 = this.fromLocalToLatLng(this.width, this.height);
            return StiGisRectLatLng.fromLTRB(p.getLng(), p.getLat(), p2.getLng(), p2.getLat());
        }
        return StiGisRectLatLng.empty;
    }

    public StiColor getIconColorGdi() {
        return this.getIconColor();
    }

    public void initGeometryColor(StiColor color, double lineSize) {
        this.geometryColor = StiColor.FromArgb((int)255, (StiColor)color);
        this.geometryLineSize = lineSize;
    }

    public void setZoomToFitRect(StiGisRectLatLng rect) {
        int maxZoom = this.getMaxZoomToFitRect(rect);
        if (maxZoom > 0) {
            this.setPosition(new StiGisPointLatLng(rect.getLat() - rect.getHeightLat() / 2.0, rect.getLng() + rect.getWidthLng() / 2.0));
            if (maxZoom > this.provider.getMaxZoom()) {
                maxZoom = this.provider.getMaxZoom();
            }
            if (this.getZoom() != maxZoom) {
                this.setZoom(maxZoom);
            }
        }
    }

    public void goToCurrentPositionOnZoom() {
        this.compensationOffset = this.positionPixel.clone();
        this.renderOffset = StiGisPoint.empty();
        StiGisPoint pt = new StiGisPoint(-(this.positionPixel.getX() - this.width / 2), -(this.positionPixel.getY() - this.height / 2));
        pt.offset(this.compensationOffset);
        this.renderOffset.setX(pt.getX());
        this.renderOffset.setY(pt.getY());
        this.updateCenterTileXYLocation();
    }

    private void updateCenterTileXYLocation() {
        StiGisPointLatLng center = this.fromLocalToLatLng(this.width / 2, this.height / 2);
        StiGisPoint centerPixel = this.provider.getProjection().fromLatLngToPixel(center, this.getZoom());
        this.centerTileXYLocation = this.provider.getProjection().fromPixelToTileXY(centerPixel);
    }

    public void onMapSizeChanged(int width, int height) {
        this.width = width;
        this.height = height;
        this.sizeOfMapArea.setWidth(this.width / this.provider.getProjection().getTileSize());
        this.sizeOfMapArea.setHeight(this.height / this.provider.getProjection().getTileSize());
        if (this.sizeOfMapArea.getWidth() == 0) {
            this.sizeOfMapArea.setWidth(1);
        }
        if (this.sizeOfMapArea.getHeight() == 0) {
            this.sizeOfMapArea.setHeight(1);
        }
        this.sizeOfMapArea.setWidth(this.sizeOfMapArea.getWidth() + 1);
        this.sizeOfMapArea.setHeight(this.sizeOfMapArea.getHeight() + 1);
    }

    public StiGisPointLatLng fromLocalToLatLng(int x, int y) {
        StiGisPoint p = new StiGisPoint(x, y);
        p.offsetNegative(this.renderOffset);
        p.offset(this.compensationOffset);
        return this.provider.getProjection().fromPixelToLatLng(p, this.getZoom());
    }

    public StiGisPoint fromLatLngToLocal(StiGisPointLatLng latlng) {
        StiGisPoint pLocal = this.provider.getProjection().fromLatLngToPixel(latlng, this.getZoom());
        pLocal.offset(this.renderOffset);
        pLocal.offsetNegative(this.compensationOffset);
        return pLocal;
    }

    public int getMaxZoomToFitRect(StiGisRectLatLng rect) {
        int zoom = this.provider.getMinZoom();
        if (rect.getHeightLat() == 0.0 || rect.getWidthLng() == 0.0) {
            zoom = this.provider.getMaxZoom() / 2;
        } else {
            int i = zoom;
            while (i <= this.provider.getMaxZoom()) {
                StiGisPoint p1 = this.provider.getProjection().fromLatLngToPixel(rect.getLocationTopLeft(), i);
                StiGisPoint p2 = this.provider.getProjection().fromLatLngToPixel(rect.getLocationRightBottom(), i);
                if (p2.getX() - p1.getX() > this.width + 10 || p2.getY() - p1.getY() > this.height + 10) break;
                zoom = i++;
            }
        }
        return zoom;
    }

    public void reloadMap() {
        this.okZoom = 0;
        this.skipOverZoom = 0;
        this.cancelAsyncTasks();
        this.matrix.clearAllLevels();
    }

    public void cancelAsyncTasks() {
        if (!this.isStarted) {
            return;
        }
    }

    public StiGisMapImage getImageFrom(StiOpenStreetMapProvider provider, StiGisPoint pos, int zoom) {
        try {
            StiGisMapImage result = provider.getTileImage(pos, zoom);
            if (result != null && result.data != null) {
                return result;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    public void Dispose(boolean disposing) {
        if (this.isStarted) {
            this.cancelAsyncTasks();
            this.isStarted = false;
            if (this.matrix != null) {
                this.matrix.close();
                this.matrix = null;
            }
            this.tileDrawingList.clear();
        }
    }

    @Override
    public void close() throws IOException {
        this.Dispose(true);
        System.gc();
    }
}

