/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.maps;

import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.report.helpers.StiFontIcons;
import com.stimulsoft.report.maps.gis.StiGisMapData;
import com.stimulsoft.report.maps.gis.StiGisMapSimpleView;
import com.stimulsoft.report.maps.gis.StiGisPointMapGeometry;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class StiOnlineMapProvider {
    public static BufferedImage getImage(StiSize size, ArrayList<StiGisPointMapGeometry> pushPins, int onePointZoom) {
        if (size.width < 50.0) {
            size = new StiSize(50.0, size.height);
        }
        if (size.height < 50.0) {
            size = new StiSize(size.width, 50.0);
        }
        BufferedImage image = new BufferedImage((int)size.width, (int)size.height, 1);
        StiGisMapData data = new StiGisMapData(StiFontIcons.MapMarker, StiColorEnum.Maroon.color(), pushPins.size() <= 1 ? onePointZoom : 0);
        data.setSize(size);
        data.setGeometryColor(StiColorEnum.Black.color());
        data.setPoints(pushPins);
        StiGisMapSimpleView view = new StiGisMapSimpleView(data);
        view.runAndWait();
        Graphics2D g = image.createGraphics();
        view.drawMap(g, image);
        g.dispose();
        return image;
    }
}

