/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.maps;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONArray;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.interfaces.IStiBorder;
import com.stimulsoft.report.components.interfaces.IStiExportImageExtended;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.maps.StiMapData;
import com.stimulsoft.report.maps.StiMapLoader;
import com.stimulsoft.report.maps.StiMapSvg;
import com.stimulsoft.report.maps.StiMapSvgContainer;
import com.stimulsoft.report.maps.enums.StiDisplayNameType;
import com.stimulsoft.report.maps.enums.StiMapID;
import com.stimulsoft.report.maps.enums.StiMapMode;
import com.stimulsoft.report.maps.enums.StiMapSource;
import com.stimulsoft.report.maps.enums.StiMapStyleIdent;
import com.stimulsoft.report.maps.enums.StiMapType;
import com.stimulsoft.report.maps.helpers.StiMapDrawingCache;
import com.stimulsoft.report.maps.helpers.StiMapHelper;
import com.stimulsoft.report.maps.style.StiMap21StyleFX;
import com.stimulsoft.report.maps.style.StiMap24StyleFX;
import com.stimulsoft.report.maps.style.StiMap25StyleFX;
import com.stimulsoft.report.maps.style.StiMap26StyleFX;
import com.stimulsoft.report.maps.style.StiMap27StyleFX;
import com.stimulsoft.report.styles.StiMapStyle;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class StiMap
extends StiComponent
implements IStiExportImageExtended,
IStiBorder {
    public StiBorder border = new StiBorder();
    private boolean isMapDataChanged;
    private List<StiMapData> hashData;
    private boolean shortValue = true;
    private StiBrush brush = new StiSolidBrush(StiColorEnum.Transparent.color());
    private List<StiPoint> points = new ArrayList<StiPoint>();
    private StiMapStyleIdent mapStyle = StiMapStyleIdent.Style25;
    private StiMapSource dataFrom = StiMapSource.Manual;
    private boolean stretch = true;
    private boolean colorEach;
    private int onePointZoom = 8;
    private boolean showValue = true;
    private StiMapID mapID = StiMapID.USA;
    private boolean showLegend;
    private StiDisplayNameType displayNameType = StiDisplayNameType.Full;
    private StiMapType mapType = StiMapType.Individual;
    private String mapData;
    public String keyDataColumn = "";
    private String nameDataColumn = "";
    private String valueDataColumn = "";
    private String groupDataColumn = "";
    private String colorDataColumn = "";
    private String latitude = "";
    private String longitude = "";
    public boolean isHashDataEmpty = true;
    private StiMapMode mapMode = StiMapMode.Choropleth;

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("UseParentStyles");
        jObject.RemoveProperty("CanGrow");
        jObject.RemoveProperty("CanShrink");
        jObject.RemoveProperty("GrowToHeight");
        jObject.RemoveProperty("Interaction");
        jObject.AddPropertyStringNullOfEmpty("Border", StiJsonReportObjectHelper.Serialize.JBorder((StiBorder)this.border));
        jObject.AddPropertyStringNullOfEmpty("Brush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.brush));
        jObject.AddPropertyEnum("MapStyle", (Enum)this.mapStyle, (Enum)StiMapStyleIdent.Style25);
        jObject.AddPropertyEnum("DataFrom", (Enum)this.dataFrom, (Enum)StiMapSource.Manual);
        jObject.AddPropertyBool("ColorEach", this.colorEach);
        jObject.AddPropertyBool("Stretch", this.stretch, true);
        jObject.AddPropertyBool("ShowValue", this.showValue, true);
        jObject.AddPropertyInt("OnePointZoom", this.onePointZoom, 8);
        jObject.AddPropertyBool("ShortValue", this.shortValue, true);
        jObject.AddPropertyEnum("ShowName", (Enum)this.displayNameType, (Enum)StiDisplayNameType.Full);
        jObject.AddPropertyEnum("MapID", (Enum)this.mapID, (Enum)StiMapID.USA);
        jObject.AddPropertyEnum("MapMode", (Enum)this.mapMode, (Enum)StiMapMode.Choropleth);
        jObject.AddPropertyEnum("MapType", (Enum)this.mapType, (Enum)StiMapType.Group);
        jObject.AddPropertyStringNullOrEmpty("MapData", this.mapData);
        jObject.AddPropertyStringNullOrEmpty("KeyDataColumn", this.keyDataColumn);
        jObject.AddPropertyStringNullOrEmpty("NameDataColumn", this.nameDataColumn);
        jObject.AddPropertyStringNullOrEmpty("ValueDataColumn", this.valueDataColumn);
        jObject.AddPropertyStringNullOrEmpty("GroupDataColumn", this.groupDataColumn);
        jObject.AddPropertyStringNullOrEmpty("ColorDataColumn", this.colorDataColumn);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Border")) {
                this.border = StiJsonReportObjectHelper.Deserialize.Border((JProperty)property);
                continue;
            }
            if (property.Name.equals("Brush")) {
                this.brush = StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property);
                continue;
            }
            if (property.Name.equals("MapStyle")) {
                this.mapStyle = StiMapStyleIdent.valueOf(property.Value.toString());
                continue;
            }
            if (property.Name.equals("DataFrom")) {
                this.dataFrom = StiMapSource.valueOf(property.Value.toString());
                continue;
            }
            if (property.Name.equals("Stretch")) {
                this.stretch = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("ShowValue")) {
                this.showValue = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("OnePointZoom")) {
                this.onePointZoom = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("ColorEach")) {
                this.colorEach = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("ShortValue")) {
                this.shortValue = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("ShowName")) {
                this.displayNameType = StiDisplayNameType.valueOf(property.Value.toString());
                continue;
            }
            if (property.Name.equals("MapID")) {
                this.mapID = StiMapID.valueOf(property.Value.toString());
                continue;
            }
            if (property.Name.equals("MapMode")) {
                this.mapMode = StiMapMode.valueOf(property.Value.toString());
                continue;
            }
            if (property.Name.equals("MapType")) {
                this.mapType = StiMapType.valueOf(property.Value.toString());
                continue;
            }
            if (property.Name.equals("MapData")) {
                this.mapData = property.Value.toString();
                continue;
            }
            if (property.Name.equals("KeyDataColumn") || property.Name.equals("DataColumnKey")) {
                this.keyDataColumn = property.Value.toString();
                break;
            }
            if (property.Name.equals("NameDataColumn") || property.Name.equals("DataColumnName")) {
                this.nameDataColumn = property.Value.toString();
                continue;
            }
            if (property.Name.equals("ValueDataColumn") || property.Name.equals("DataColumnValue")) {
                this.valueDataColumn = property.Value.toString();
                continue;
            }
            if (property.Name.equals("GroupDataColumn") || property.Name.equals("DataColumnGroup")) {
                this.groupDataColumn = property.Value.toString();
                continue;
            }
            if (!property.Name.equals("ColorDataColumn") && !property.Name.equals("DataColumnColor")) continue;
            this.colorDataColumn = property.Value.toString();
        }
    }

    @Override
    public Object clone(boolean cloneProperties) {
        StiMap map = (StiMap)super.clone(cloneProperties);
        map.border = this.border != null ? (StiBorder)this.border.clone() : null;
        map.brush = this.brush != null ? (StiBrush)this.brush.clone() : null;
        map.colorDataColumn = this.colorDataColumn;
        map.colorEach = this.colorEach;
        map.dataFrom = this.dataFrom;
        map.displayNameType = this.displayNameType;
        map.groupDataColumn = this.groupDataColumn;
        map.hashData = this.hashData;
        map.isMapDataChanged = this.isMapDataChanged;
        map.latitude = this.latitude;
        map.longitude = this.longitude;
        map.mapMode = this.mapMode;
        map.nameDataColumn = this.nameDataColumn;
        map.valueDataColumn = this.valueDataColumn;
        map.canGrow = this.canGrow;
        map.canShrink = this.canShrink;
        map.componentPlacement = this.componentPlacement;
        map.conditions = this.conditions;
        map.hashData = this.hashData;
        map.interaction = this.interaction;
        map.isHashDataEmpty = this.isHashDataEmpty;
        map.isMapDataChanged = this.isMapDataChanged;
        map.isRendered = this.isRendered;
        map.mapData = this.mapData;
        map.mapID = this.mapID;
        map.mapStyle = this.mapStyle;
        map.mapType = this.mapType;
        map.page = this.page;
        map.parent = this.parent;
        map.parentBookmark = this.parentBookmark;
        map.properties = this.properties;
        map.showLegend = this.showLegend;
        map.showValue = this.showValue;
        map.stretch = this.stretch;
        map.top = this.top;
        map.width = this.width;
        map.onePointZoom = this.onePointZoom;
        return map;
    }

    public StiImage getImage(double zoom) {
        return this.getImage(zoom, StiExportFormat.None);
    }

    public StiImage getImage(double zoom, StiExportFormat format) {
        return null;
    }

    @Override
    public boolean isExportAsImage(StiExportFormat format) {
        return this.mapMode == StiMapMode.Online;
    }

    @Override
    @StiSerializable
    public StiBorder getBorder() {
        return this.border;
    }

    @Override
    public void setBorder(StiBorder border) {
        this.border = border;
    }

    @Override
    public String getLocalizedCategory() {
        return StiLocalization.Get((String)"Report", (String)"Infographics");
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Components", (String)"StiMap");
    }

    @Override
    public StiRectangle getDefaultClientRectangle() {
        return new StiRectangle(0L, 0L, 240L, 240L);
    }

    @Override
    @StiSerializable
    public StiRectangle getClientRectangle() {
        return super.getClientRectangle();
    }

    @Override
    public void setClientRectangle(StiRectangle value) {
        super.setClientRectangle(value);
        StiMapDrawingCache.removeImage(this);
    }

    @Deprecated
    public String getDataColumnKey() {
        return null;
    }

    @Deprecated
    public void setDataColumnKey(String value) {
        this.keyDataColumn = value;
    }

    @Deprecated
    public String getDataColumnName() {
        return null;
    }

    @Deprecated
    public void setDataColumnName(String value) {
        this.nameDataColumn = value;
    }

    @Deprecated
    public String getDataColumnValue() {
        return null;
    }

    @Deprecated
    public void setDataColumnValue(String value) {
        this.valueDataColumn = value;
    }

    @Deprecated
    public String getDataColumnGroup() {
        return null;
    }

    @Deprecated
    public void setDataColumnGroup(String value) {
        this.groupDataColumn = value;
    }

    @Deprecated
    public String getDataColumnColor() {
        return null;
    }

    @Deprecated
    public void setDataColumnColor(String value) {
        this.colorDataColumn = value;
    }

    @StiSerializable
    public boolean isShortValue() {
        return this.shortValue;
    }

    public void setShortValue(boolean shortValue) {
        this.shortValue = shortValue;
    }

    public List<StiPoint> getPoints() {
        return this.points;
    }

    public void setPoints(List<StiPoint> points) {
        this.points = points;
    }

    @StiSerializable
    public StiBrush getBrush() {
        return this.brush;
    }

    public void setBrush(StiBrush brush) {
        this.brush = brush;
    }

    @StiSerializable
    public StiMapStyleIdent getMapStyle() {
        return this.mapStyle;
    }

    public void setMapStyle(StiMapStyleIdent mapStyle) {
        this.mapStyle = mapStyle;
    }

    @StiSerializable
    public StiMapSource getDataFrom() {
        return this.dataFrom;
    }

    public void setDataFrom(StiMapSource dataFrom) {
        this.dataFrom = dataFrom;
    }

    @StiSerializable
    public boolean isStretch() {
        return this.stretch;
    }

    public void setStretch(boolean stretch) {
        this.stretch = stretch;
    }

    @StiSerializable
    public int getOnePointZoom() {
        return this.onePointZoom;
    }

    public void setOnePointZoom(int onePointZoom) {
        this.onePointZoom = onePointZoom;
    }

    @StiSerializable
    public boolean isColorEach() {
        return this.colorEach;
    }

    public void setColorEach(boolean colorEach) {
        this.colorEach = colorEach;
    }

    @StiSerializable
    public boolean isShowValue() {
        return this.showValue;
    }

    public void setShowValue(boolean showValue) {
        this.showValue = showValue;
    }

    @StiSerializable
    public StiMapID getMapID() {
        return this.mapID;
    }

    public void setMapID(StiMapID mapID) {
        this.mapID = mapID;
    }

    public boolean isShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(boolean showLegend) {
        this.showLegend = showLegend;
    }

    @StiSerializable
    public StiDisplayNameType getDisplayNameType() {
        return this.displayNameType;
    }

    public void setDisplayNameType(StiDisplayNameType displayNameType) {
        this.displayNameType = displayNameType;
    }

    @StiSerializable
    public StiMapType getMapType() {
        return this.mapType;
    }

    public void setMapType(StiMapType mapType) {
        this.mapType = mapType;
    }

    @StiSerializable
    public String getMapData() {
        return this.mapData;
    }

    public void setMapData(String value) {
        this.mapData = value;
        this.isHashDataEmpty = true;
        this.isMapDataChanged = true;
        this.hashData = null;
    }

    @StiSerializable
    public String getKeyDataColumn() {
        return this.keyDataColumn;
    }

    public void setKeyDataColumn(String keyDataColumn) {
        this.keyDataColumn = keyDataColumn;
    }

    @StiSerializable
    public String getNameDataColumn() {
        return this.nameDataColumn;
    }

    public void setNameDataColumn(String nameDataColumn) {
        this.nameDataColumn = nameDataColumn;
    }

    @StiSerializable
    public String getValueDataColumn() {
        return this.valueDataColumn;
    }

    public void setValueDataColumn(String valueDataColumn) {
        this.valueDataColumn = valueDataColumn;
    }

    @StiSerializable
    public String getGroupDataColumn() {
        return this.groupDataColumn;
    }

    public void setGroupDataColumn(String groupDataColumn) {
        this.groupDataColumn = groupDataColumn;
    }

    @StiSerializable
    public String getColorDataColumn() {
        return this.colorDataColumn;
    }

    public void setColorDataColumn(String colorDataColumn) {
        this.colorDataColumn = colorDataColumn;
    }

    @StiSerializable
    public String getLatitude() {
        return this.latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    @StiSerializable
    public String getLongitude() {
        return this.longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public boolean isHashDataEmpty() {
        return this.isHashDataEmpty;
    }

    private void setHashDataEmpty(boolean isHashDataEmpty) {
        this.isHashDataEmpty = isHashDataEmpty;
    }

    @StiSerializable
    public StiMapMode getMapMode() {
        return this.mapMode;
    }

    public void setMapMode(StiMapMode mapMode) {
        this.mapMode = mapMode;
    }

    @Override
    public boolean getUseParentStyles() {
        return super.getUseParentStyles();
    }

    @Override
    public boolean getCanGrow() {
        return super.getCanGrow();
    }

    @Override
    public boolean getCanShrink() {
        return super.getCanShrink();
    }

    @Override
    public boolean getGrowToHeight() {
        return super.getGrowToHeight();
    }

    public StiComponent createNew() {
        return new StiMap();
    }

    public static List<StiMapData> getMapDataInternal(String mapData, StiMapID mapID) throws UnsupportedEncodingException, JSONException, IOException {
        return StiMap.getMapDataInternal(mapData, mapID, (StiRefObject<Boolean>)new StiRefObject((Object)false));
    }

    public static List<StiMapData> getDefaultMapData(StiMapID mapID) throws UnsupportedEncodingException, IOException, JSONException {
        ArrayList<StiMapData> result = new ArrayList<StiMapData>();
        int offset = 10;
        boolean isUp = true;
        int index = 0;
        List<StiColor> baseColors = StiMapHelper.getColors();
        ArrayList<StiColor> colors = new ArrayList<StiColor>();
        for (StiColor color : baseColors) {
            colors.add(color);
        }
        StiMapSvgContainer svgContainer = StiMapLoader.loadResource(mapID.toString());
        for (String key : svgContainer.hashPaths.keySet()) {
            StiMapData data = new StiMapData(key);
            data.setColor(((StiColor)colors.get(index)).toHTML());
            StiMapSvg pt = svgContainer.hashPaths.get(key);
            if (pt != null) {
                data.setName(pt.englishName);
            }
            result.add(data);
            if (++index < colors.size()) continue;
            index = 0;
            if (isUp) {
                for (StiColor color : baseColors) {
                    colors.add(StiColorUtils.dark((StiColor)color, (int)offset));
                }
            } else {
                for (StiColor color : baseColors) {
                    colors.add(StiColorUtils.light((StiColor)color, (int)offset));
                }
                offset = (byte)(offset + 10);
            }
            isUp = !isUp;
        }
        return result;
    }

    public static List<StiMapData> getMapDataInternal(String mapData, StiMapID mapID, StiRefObject<Boolean> isHashDataEmpty) throws JSONException, UnsupportedEncodingException, IOException {
        ArrayList<StiMapData> result;
        block22: {
            StiMapSvgContainer svgContainer;
            isHashDataEmpty.argvalue = true;
            result = new ArrayList<StiMapData>();
            if (!StiValidationUtil.isNullOrEmpty((String)mapData)) {
                JSONArray datas = new JSONArray(mapData);
                for (int i = 0; i < datas.length(); ++i) {
                    JSONObject jData = datas.getJSONObject(i);
                    StiMapData data = new StiMapData(jData.getString("Key"));
                    if (jData.has("Color")) {
                        data.setColor(jData.getString("Color"));
                    }
                    if (jData.has("Group")) {
                        data.setGroup(jData.getString("Group"));
                    }
                    if (jData.has("Name")) {
                        data.setName(jData.getString("Name"));
                    }
                    if (jData.has("Value")) {
                        data.setValue(jData.getString("Value"));
                    }
                    if (jData.has("Key")) {
                        data.setKey(jData.getString("Key"));
                    }
                    result.add(data);
                }
            }
            if ((svgContainer = StiMapLoader.loadResource(mapID.toString())) == null) break block22;
            if (result.size() > 0) {
                int index = 0;
                while (index < result.size()) {
                    StiMapData data = (StiMapData)result.get(index);
                    if (StiValidationUtil.isNullOrEmpty((String)data.getKey()) || !svgContainer.hashPaths.containsKey(data.getKey())) {
                        result.remove(index);
                        continue;
                    }
                    ++index;
                }
                if (svgContainer.hashPaths.size() != result.size()) {
                    for (String key : svgContainer.hashPaths.keySet()) {
                        StiMapData x = null;
                        for (StiMapData dt : result) {
                            if (!StiValidationUtil.equals((Object)dt.getKey(), (Object)key)) continue;
                            x = dt;
                        }
                        if (x != null) continue;
                        StiMapData data = new StiMapData(key);
                        result.add(data);
                    }
                }
                for (StiMapData data : result) {
                    if (StiValidationUtil.isNullOrEmpty((String)data.getColor()) && StiValidationUtil.isNullOrEmpty((String)data.getGroup()) && StiValidationUtil.isNullOrEmpty((String)data.getValue())) continue;
                    isHashDataEmpty.argvalue = false;
                    break;
                }
            } else {
                int offset = 10;
                boolean isUp = true;
                int index = 0;
                List<StiColor> baseColors = StiMapHelper.getColors();
                ArrayList<StiColor> colors = new ArrayList<StiColor>();
                for (StiColor color : baseColors) {
                    colors.add(color);
                }
                for (String key : svgContainer.hashPaths.keySet()) {
                    StiMapData data = new StiMapData(key);
                    data.setColor(((StiColor)colors.get(index)).toHTML());
                    StiMapSvg pt = svgContainer.hashPaths.get(key);
                    if (pt != null) {
                        data.setName(pt.englishName);
                    }
                    result.add(data);
                    if (++index < colors.size()) continue;
                    index = 0;
                    if (isUp) {
                        for (StiColor color : baseColors) {
                            colors.add(StiColorUtils.dark((StiColor)color, (int)offset));
                        }
                    } else {
                        for (StiColor color : baseColors) {
                            colors.add(StiColorUtils.light((StiColor)color, (int)offset));
                        }
                        offset = (byte)(offset + 10);
                    }
                    isUp = !isUp;
                }
            }
        }
        return result;
    }

    public List<StiMapData> GetMapData() throws UnsupportedEncodingException, JSONException, IOException {
        if (this.hashData != null && this.hashData.size() > 0 && this.isMapDataChanged) {
            return this.hashData;
        }
        this.isHashDataEmpty = true;
        StiRefObject isHashDataEmpty = new StiRefObject((Object)true);
        List<StiMapData> result = StiMap.getMapDataInternal(this.mapData, this.getMapID(), (StiRefObject<Boolean>)isHashDataEmpty);
        if (!((Boolean)isHashDataEmpty.argvalue).booleanValue()) {
            this.isHashDataEmpty = false;
        }
        this.isMapDataChanged = true;
        this.hashData = result;
        return result;
    }

    public List<StiColor> getCurrentStyleColors() {
        StiMapStyle style;
        if (!StiValidationUtil.isNullOrEmpty((String)this.getComponentStyle()) && (style = (StiMapStyle)this.getReport().getStyles().get(this.getComponentStyle())) != null) {
            return style.getColors();
        }
        return StiMap.getStyleColors(this.getMapStyle());
    }

    public static List<StiColor> getStyleColors(StiMapStyleIdent style) {
        return StiMap.getMapStyle(style).getColors();
    }

    public StiBrush getStyleBackground() {
        StiMapStyle style;
        if (!StiValidationUtil.isNullOrEmpty((String)this.getComponentStyle()) && (style = (StiMapStyle)this.getReport().getStyles().get(this.getComponentStyle())) != null) {
            return new StiSolidBrush(style.getBackColor());
        }
        return new StiSolidBrush(StiMap.getMapStyle(this.getMapStyle()).getBackColor());
    }

    public static StiMapStyle getMapStyle(StiMap map) {
        StiMapStyle mapStyle = null;
        if (!StiValidationUtil.isNullOrEmpty((String)map.getComponentStyle())) {
            mapStyle = (StiMapStyle)map.getReport().getStyles().get(map.getComponentStyle());
        }
        if (mapStyle == null) {
            mapStyle = StiMap.getMapStyle(map.getMapStyle());
        }
        return mapStyle;
    }

    public static StiMapStyle getMapStyle(StiMapStyleIdent style) {
        switch (style) {
            case Style21: {
                return new StiMap21StyleFX();
            }
            case Style24: {
                return new StiMap24StyleFX();
            }
            case Style25: {
                return new StiMap25StyleFX();
            }
            case Style26: {
                return new StiMap26StyleFX();
            }
            case Style27: {
                return new StiMap27StyleFX();
            }
        }
        throw new RuntimeException("Style is not supported!");
    }

    public StiMap() {
        this(StiRectangle.empty());
    }

    public StiMap(StiRectangle rect) {
        super(rect);
        this.setPlaceOnToolbox(false);
    }
}

