/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.tick.radial.mark;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.enums.StiComponentId;
import com.stimulsoft.report.events.StiGetValueEvent;
import com.stimulsoft.report.events.StiGetValueEventArgs;
import com.stimulsoft.report.infographics.gauge.StiGaugeElemenType;
import com.stimulsoft.report.infographics.gauge.StiPlacement;
import com.stimulsoft.report.infographics.gauge.collections.StiCustomValuesCollection;
import com.stimulsoft.report.infographics.gauge.expressions.StiValueExpression;
import com.stimulsoft.report.infographics.gauge.helpers.StiGaugeHelper;
import com.stimulsoft.report.infographics.gauge.interfaces.IStiTickCustom;
import com.stimulsoft.report.infographics.gauge.primitives.base.StiGaugeElement;
import com.stimulsoft.report.infographics.gauge.primitives.tick.StiRadialTickMarkBase;
import com.stimulsoft.report.infographics.gauge.scales.StiRadialScale;
import com.stimulsoft.report.infographics.gauge.skins.StiGaugeElementSkin;
import com.stimulsoft.report.infographics.gauge.tick.StiCustomValueBase;
import com.stimulsoft.report.infographics.gauge.tick.radial.mark.StiRadialTickMarkCustomValue;
import com.stimulsoft.report.painters.StiGaugeContextPainter;

public class StiRadialTickMarkCustom
extends StiRadialTickMarkBase
implements IStiTickCustom {
    private double valueObj = 0.0;
    private StiCustomValuesCollection values = new StiCustomValuesCollection();
    private StiGetValueEvent getValueEvent = new StiGetValueEvent();
    private StiValueExpression value = new StiValueExpression();

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        jObject.AddPropertyJObject("GetValueEvent", this.getValueEvent.SaveToJsonObject(mode));
        jObject.AddPropertyJObject("Value", this.value.SaveToJsonObject(mode));
        jObject.AddPropertyJObject("Values", this.values.SaveToJsonObject(mode));
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if ("GetSkipValuesEvent".equals(property.Name)) {
                StiGetValueEvent _getSkipValuesEvent = new StiGetValueEvent();
                _getSkipValuesEvent.LoadFromJsonObject((JSONObject)property.Value);
                this.getValueEvent = _getSkipValuesEvent;
                continue;
            }
            if ("GetSkipIndicesEvent".equals(property.Name)) {
                StiValueExpression _valueExpression = new StiValueExpression();
                _valueExpression.LoadFromJsonObject((JSONObject)property.Value);
                this.value = _valueExpression;
                continue;
            }
            if (!"Values".equals(property.Name)) continue;
            this.values.LoadFromJsonObject((JSONObject)property.Value);
        }
    }

    public StiComponentId getComponentId() {
        return StiComponentId.StiRadialTickMarkCustom;
    }

    @Override
    public Object clone() {
        StiRadialTickMarkCustom radialTickMark = (StiRadialTickMarkCustom)super.clone();
        radialTickMark.value = this.value != null ? (StiValueExpression)this.value.clone() : null;
        radialTickMark.values = new StiCustomValuesCollection();
        for (StiCustomValueBase customValue : this.values) {
            radialTickMark.values.add((StiCustomValueBase)customValue.clone());
        }
        return radialTickMark;
    }

    @Override
    @StiSerializable
    public double getValueObj() {
        return this.valueObj;
    }

    @Override
    public void setValueObj(double valueObj) {
        this.valueObj = valueObj;
    }

    @Override
    @StiSerializable
    public StiCustomValuesCollection getValues() {
        return this.values;
    }

    @Override
    public void setValues(StiCustomValuesCollection values) {
        this.values = values;
    }

    @StiSerializable
    public StiGetValueEvent getGetValueEvent() {
        return this.getValueEvent;
    }

    public void setGetValueEvent(StiGetValueEvent getValueEvent) {
        this.getValueEvent = getValueEvent;
    }

    public StiValueExpression getValue() {
        return this.value;
    }

    public void setValue(StiValueExpression value) {
        this.value = value;
    }

    @Override
    public StiGaugeElemenType getElementType() {
        return StiGaugeElemenType.RadialElement;
    }

    @Override
    public String getLocalizeName() {
        return "RadialTickMarkCustom";
    }

    @Override
    public StiGaugeElement createNew() {
        return new StiRadialTickMarkCustom();
    }

    @Override
    public void prepareGaugeElement() {
        super.prepareGaugeElement();
        StiGetValueEventArgs e = new StiGetValueEventArgs();
        this.valueObj = StiGaugeHelper.getFloatValueFromObject((Object)e.getValue(), 0.0);
    }

    @Override
    public void drawElement(StiGaugeContextPainter context) {
        StiRadialScale radialScale;
        StiRadialScale stiRadialScale = radialScale = this.scale instanceof StiRadialScale ? (StiRadialScale)this.scale : null;
        if (radialScale == null) {
            return;
        }
        StiRectangle rect = this.scale.barGeometry.getRectGeometry();
        if (rect.width <= 0.0 || rect.height <= 0.0) {
            return;
        }
        StiPoint centerPoint = radialScale.barGeometry.getCenter();
        double sweepAngle = radialScale.GetSweepAngle();
        double startAngle = radialScale.getStartAngle();
        double diameter = this.scale.barGeometry.getDiameter();
        double barRadius = this.scale.barGeometry.getRadius();
        double startValue = this.scale.scaleHelper.ActualMinimum;
        double endValue = this.scale.scaleHelper.ActualMaximum;
        double minWidth = this.scale.scaleHelper.MinWidth;
        double maxWidth = this.scale.scaleHelper.MaxWidth;
        double restWidth = (maxWidth *= this.scale.barGeometry.getRectGeometry().width) - (minWidth *= this.scale.barGeometry.getRectGeometry().width);
        StiGaugeElementSkin actualSkin = this.getActualSkin();
        double[] skipValues = super.getSkipValuesObj();
        double[] skipIndices = super.getSkipIndicesObj();
        StiCustomValuesCollection coll = this.values;
        if (coll == null || coll.size() == 0) {
            coll = new StiCustomValuesCollection();
            coll.add(new StiRadialTickMarkCustomValue(this.valueObj, this.getOffset(), this.getRelativeWidth(), this.getRelativeHeight(), this.getOffsetAngle(), this.getPlacement(), actualSkin));
        }
        int index = -1;
        for (StiCustomValueBase kk : coll) {
            double angle;
            StiRadialTickMarkCustomValue key = (StiRadialTickMarkCustomValue)kk;
            if (key.getValue() < startValue || key.getValue() > endValue || this.checkTickValue(skipValues, skipIndices, key.getValue(), ++index) || this.getMinimumValue() != null && key.getValue() < this.getMinimumValue() || this.getMaximumValue() != null && key.getValue() > this.getMaximumValue()) continue;
            double value1 = this.scale.getPosition(key.getValue());
            double tickWidth = diameter * this.getRelativeWidth(key.getRelativeWidth());
            double tickHeight = diameter * this.getRelativeHeight(key.getRelativeHeight());
            double radius = this.getPlacement(key.getPlacement()) == StiPlacement.Outside ? barRadius * (1.0 + this.getOffset(key.getOffset())) : barRadius * (1.0 - this.getOffset(key.getOffset()));
            double d = angle = this.scale.getIsReversed() ? startAngle + sweepAngle - value1 * sweepAngle - this.getOffsetAngle(key.getOffsetAngle()) : startAngle + value1 * sweepAngle + this.getOffsetAngle(key.getOffsetAngle());
            double currentRadius = this.getPlacement(key.getPlacement()) == StiPlacement.Outside ? radius : (this.getPlacement(key.getPlacement()) == StiPlacement.Overlay ? (this.scale.isUp() ? radius - (minWidth + restWidth * value1 + tickWidth) / 2.0 : radius - (maxWidth - restWidth * value1 + tickWidth) / 2.0) : (this.scale.isUp() ? radius - minWidth - restWidth * value1 - tickWidth : radius - maxWidth + restWidth * value1 - tickWidth));
            StiBrush currentBackground = null;
            StiBrush currentBorderBrush = null;
            double currentBorderWidth = 0.0;
            if (key.useBrush) {
                currentBackground = this.getBrush();
                this.setBrush(key.getBorderBrush());
            }
            if (key.useBorderBrush) {
                currentBorderBrush = this.getBorderBrush();
                this.setBorderBrush(key.getBorderBrush());
            }
            if (key.useBorderWidth) {
                currentBorderWidth = this.getBorderWidth();
                this.setBorderWidth(key.getBorderWidth() == null ? 0.0 : key.getBorderWidth());
            }
            StiRectangle tickRect = new StiRectangle(centerPoint.x + currentRadius, centerPoint.y, tickWidth, tickHeight);
            context.addPushMatrixGaugeGeom(angle, centerPoint);
            StiGaugeElementSkin skin = key.getSkin() == null ? actualSkin : key.getSkin();
            skin.draw(context, this, tickRect);
            context.addPopTranformGaugeGeom();
            if (key.useBrush) {
                this.setBrush(currentBackground);
            }
            if (key.useBorderBrush) {
                this.setBorderBrush(currentBackground);
            }
            if (!key.useBorderWidth) continue;
            this.setBorderWidth(currentBorderWidth);
        }
    }

    private double getOffsetAngle(Double value) {
        if (value == null) {
            return this.scale.getIsReversed() ? -this.getOffsetAngle() : this.getOffsetAngle();
        }
        return value;
    }
}

