/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.range;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.enums.StiComponentId;
import com.stimulsoft.report.infographics.gauge.primitives.range.StiRangeBase;
import com.stimulsoft.report.infographics.gauge.primitives.scales.StiScaleBase;
import com.stimulsoft.report.painters.StiGaugeContextPainter;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGraphicsPathGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGraphicsPathLinesGaugeGeom;

public class StiLinearRange
extends StiRangeBase {
    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
    }

    public StiComponentId getComponentId() {
        return StiComponentId.StiLinearRange;
    }

    @Override
    protected void drawRange(StiGaugeContextPainter context, StiScaleBase scale) {
        if (scale == null) {
            return;
        }
        double startWidth = this.getStartWidth();
        double endWidth = this.getEndWidth();
        if (startWidth == 0.0 || endWidth == 0.0) {
            return;
        }
        StiRefObject rect = new StiRefObject((Object)new StiRectangle(0L, 0L, 0L, 0L));
        StiGraphicsPathLinesGaugeGeom linesGeom = scale.barGeometry.drawGeometry(context, this.getStartValue(), this.getEndValue(), startWidth, endWidth, this.getOffset(), this.getPlacement(), (StiRefObject<StiRectangle>)rect, false);
        if (linesGeom != null) {
            StiGraphicsPathGaugeGeom pathGeom = new StiGraphicsPathGaugeGeom((StiRectangle)rect.argvalue, linesGeom.points[0], this.getBrush(), this.getBorderBrush(), this.getBorderWidth());
            pathGeom.getGeoms().add(linesGeom);
            pathGeom.addGraphicsPathCloseFigureGaugeGeom();
            context.addGraphicsPathGaugeGeom(pathGeom);
        }
    }

    @Override
    public String getLocalizeName() {
        return "LinearRange";
    }

    @Override
    public StiRangeBase createNew() {
        return new StiLinearRange();
    }
}

