/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.primitives.tick;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.report.infographics.gauge.StiTickMarkSkin;
import com.stimulsoft.report.infographics.gauge.helpers.StiGaugeSkinHelper;
import com.stimulsoft.report.infographics.gauge.primitives.tick.StiTickBase;
import com.stimulsoft.report.infographics.gauge.skins.StiGaugeElementSkin;

public class StiTickMarkBase
extends StiTickBase {
    private double relativeHeight = 0.1;
    private double relativeWidth = 0.1f;
    private StiTickMarkSkin skin = StiTickMarkSkin.Rectangle;
    private StiGaugeElementSkin customSkin;
    private StiBrush brush = new StiSolidBrush(StiColorEnum.White.color());
    private StiBrush borderBrush = new StiSolidBrush(StiColor.fromArgb((int)89, (int)87, (int)87));
    private double borderWidth = 1.0;

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyFloat("RelativeHeight", this.getRelativeHeight(), 0.1);
        jObject.AddPropertyFloat("RelativeWidth", this.relativeWidth, 0.1);
        jObject.AddPropertyEnum("Skin", (Enum)this.skin);
        jObject.AddPropertyStringNullOfEmpty("Brush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.brush));
        jObject.AddPropertyStringNullOfEmpty("BorderBrush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.borderBrush));
        jObject.AddPropertyFloat("BorderWidth", this.borderWidth, 1.0);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if ("RelativeHeight".equals(property.Name)) {
                this.setRelativeHeight((Double)property.Value);
                continue;
            }
            if ("RelativeWidth".equals(property.Name)) {
                this.setRelativeWidth((Double)property.Value);
                continue;
            }
            if ("Skin".equals(property.Name)) {
                this.setSkin(StiTickMarkSkin.valueOf(property.Value.toString()));
                continue;
            }
            if ("Brush".equals(property.Name)) {
                this.setBrush(StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property));
                continue;
            }
            if ("BorderBrush".equals(property.Name)) {
                this.setBorderBrush(StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property));
                continue;
            }
            if (!"BorderWidth".equals(property.Name)) continue;
            this.setBorderWidth((Double)property.Value);
        }
    }

    @Override
    public Object clone() {
        StiTickMarkBase tickMarker = (StiTickMarkBase)super.clone();
        tickMarker.brush = (StiBrush)this.brush.clone();
        tickMarker.borderBrush = (StiBrush)this.borderBrush.clone();
        tickMarker.relativeHeight = this.relativeHeight;
        tickMarker.relativeWidth = this.relativeWidth;
        tickMarker.skin = this.skin;
        tickMarker.borderWidth = this.borderWidth;
        return tickMarker;
    }

    @StiSerializable
    public double getRelativeHeight() {
        return this.relativeHeight;
    }

    public void setRelativeHeight(double relativeHeight) {
        this.relativeHeight = relativeHeight;
    }

    @StiSerializable
    public double getRelativeWidth() {
        return this.relativeWidth;
    }

    public void setRelativeWidth(double relativeWidth) {
        this.relativeWidth = relativeWidth;
    }

    @StiSerializable
    public StiTickMarkSkin getSkin() {
        return this.skin;
    }

    public void setSkin(StiTickMarkSkin skin) {
        this.skin = skin;
    }

    @StiSerializable
    public StiGaugeElementSkin getCustomSkin() {
        return this.customSkin;
    }

    public void setCustomSkin(StiGaugeElementSkin customSkin) {
        this.customSkin = customSkin;
    }

    @StiSerializable
    public StiBrush getBrush() {
        return this.brush;
    }

    public void setBrush(StiBrush brush) {
        this.brush = brush;
    }

    @StiSerializable
    public StiBrush getBorderBrush() {
        return this.borderBrush;
    }

    public void setBorderBrush(StiBrush borderBrush) {
        this.borderBrush = borderBrush;
    }

    @StiSerializable
    public double getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(double borderWidth) {
        this.borderWidth = borderWidth;
    }

    protected StiGaugeElementSkin getActualSkin() {
        return this.customSkin != null ? this.customSkin : StiGaugeSkinHelper.getTickMarkSkin(this.skin);
    }

    protected double getRelativeWidth(Double value) {
        return value == null ? this.getRelativeWidth() : value.doubleValue();
    }

    protected double getRelativeHeight(Double value) {
        return value == null ? this.getRelativeHeight() : value.doubleValue();
    }
}

