/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.primitives.scales;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableRef;
import com.stimulsoft.report.enums.StiComponentId;
import com.stimulsoft.report.infographics.gauge.StiGauge;
import com.stimulsoft.report.infographics.gauge.StiGaugeElemenType;
import com.stimulsoft.report.infographics.gauge.collections.StiGaugeElementCollection;
import com.stimulsoft.report.infographics.gauge.helpers.StiMathHelper;
import com.stimulsoft.report.infographics.gauge.interfaces.IStiScaleBarGeometry;
import com.stimulsoft.report.infographics.gauge.primitives.base.StiElementBase;
import com.stimulsoft.report.infographics.gauge.primitives.base.StiGaugeElement;
import com.stimulsoft.report.infographics.gauge.primitives.scalebargeometry.StiLinearBarGeometry;
import com.stimulsoft.report.infographics.gauge.primitives.scalebargeometry.StiRadialBarGeometry;
import com.stimulsoft.report.infographics.gauge.scales.StiLinearScale;
import com.stimulsoft.report.infographics.gauge.scales.StiRadialScale;
import com.stimulsoft.report.painters.StiGaugeContextPainter;

public abstract class StiScaleBase
extends StiElementBase
implements IStiJsonReportObject,
IStiSerializableRef {
    private int reference = -1;
    public IStiScaleBarGeometry barGeometry;
    public StiScaleHelper scaleHelper = new StiScaleHelper();
    public StiGauge gauge;
    private double left = 0.0;
    private double top = 0.0;
    protected double startWidth = 0.1f;
    protected double endWidth = 0.1f;
    private double majorInterval = 10.0;
    private double minorInterval = 1.0;
    private double minimum = 0.0;
    private double maximum = 100.0;
    private boolean isReversed = false;
    private StiBrush brush = new StiSolidBrush(StiColor.fromArgb((int)50, (StiColor)StiColorEnum.White.color()));
    private StiBrush borderBrush = new StiSolidBrush(StiColor.FromArgb((int)150, (StiColor)StiColorEnum.White.color()));
    private StiGaugeElementCollection items = new StiGaugeElementCollection(this);

    public void setReference(int reference) {
        this.reference = reference;
    }

    public int getReference() {
        return this.reference;
    }

    public void cleanReference() {
        this.reference = -1;
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyFloat("Left", this.left, 0.0);
        jObject.AddPropertyFloat("Top", this.top, 0.0);
        jObject.AddPropertyFloat("StartWidth", this.startWidth, (double)0.1f);
        jObject.AddPropertyFloat("EndWidth", this.endWidth, (double)0.1f);
        jObject.AddPropertyFloat("MajorInterval", this.majorInterval, 10.0);
        jObject.AddPropertyFloat("MinorInterval", this.minorInterval, 1.0);
        jObject.AddPropertyBool("IsReversed", this.isReversed, false);
        jObject.AddPropertyFloat("Minimum", this.minimum, 0.0);
        jObject.AddPropertyFloat("Maximum", this.maximum, 10.0);
        jObject.AddPropertyStringNullOfEmpty("Brush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.brush));
        jObject.AddPropertyStringNullOfEmpty("BorderBrush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.borderBrush));
        jObject.AddPropertyJObject("Items", this.getItems().SaveToJsonObject(mode));
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if ("Left".equals(property.Name)) {
                this.setLeft((Double)property.Value);
                continue;
            }
            if ("Top".equals(property.Name)) {
                this.setTop((Double)property.Value);
                continue;
            }
            if ("StartWidth".equals(property.Name)) {
                this.setStartWidth((Double)property.Value);
                continue;
            }
            if ("EndWidth".equals(property.Name)) {
                this.setEndWidth((Double)property.Value);
                continue;
            }
            if ("MajorInterval".equals(property.Name)) {
                this.setMajorInterval((Double)property.Value);
                continue;
            }
            if ("MinorInterval".equals(property.Name)) {
                this.setMinorInterval((Double)property.Value);
                continue;
            }
            if ("IsReversed".equals(property)) {
                this.setIsReversed((Boolean)property.Value);
                continue;
            }
            if ("Minimum".equals(property.Name)) {
                this.setMinimum((Double)property.Value);
                continue;
            }
            if ("Maximum".equals(property.Name)) {
                this.setMaximum((Double)property.Value);
                continue;
            }
            if ("Brush".equals(property.Name)) {
                this.setBrush(StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property));
                continue;
            }
            if ("BorderBrush".equals(property.Name)) {
                this.setBorderBrush(StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property));
                continue;
            }
            if (!"Items".equals(property.Name)) continue;
            this.items.LoadFromJsonObject((JSONObject)property.Value);
        }
    }

    public abstract StiComponentId getComponentId();

    public String getPropName() {
        return null;
    }

    @Override
    public Object clone() {
        StiScaleBase scale = (StiScaleBase)super.clone();
        scale.left = this.left;
        scale.top = this.top;
        scale.startWidth = this.startWidth;
        scale.endWidth = this.endWidth;
        scale.majorInterval = this.majorInterval;
        scale.minorInterval = this.minorInterval;
        scale.isReversed = this.isReversed;
        scale.minimum = this.minimum;
        scale.maximum = this.maximum;
        scale.brush = (StiBrush)this.brush.clone();
        scale.borderBrush = (StiBrush)this.borderBrush.clone();
        scale.items = new StiGaugeElementCollection(scale);
        scale.scaleHelper = (StiScaleHelper)this.scaleHelper.clone();
        for (StiGaugeElement element : this.items) {
            scale.items.add((StiGaugeElement)element.clone());
        }
        if (this instanceof StiLinearScale) {
            scale.barGeometry = new StiLinearBarGeometry((StiLinearScale)scale);
        } else if (this instanceof StiRadialScale) {
            scale.barGeometry = new StiRadialBarGeometry((StiRadialScale)scale);
        }
        return scale;
    }

    public boolean isUp() {
        boolean isUp;
        boolean bl = isUp = this.startWidth < this.endWidth;
        if (this.isReversed) {
            isUp = !isUp;
        }
        return isUp;
    }

    @StiSerializable
    public StiGauge getGauge() {
        return this.gauge;
    }

    public void setGauge(StiGauge gauge) {
        this.gauge = gauge;
    }

    @StiSerializable
    public double getLeft() {
        return this.left;
    }

    public void setLeft(double left) {
        this.left = left;
    }

    @StiSerializable
    public double getTop() {
        return this.top;
    }

    public void setTop(double top) {
        this.top = top;
    }

    @StiSerializable
    public double getStartWidth() {
        return this.startWidth;
    }

    public void setStartWidth(double startWidth) {
        this.startWidth = startWidth;
        this.calculateWidthScaleHelper();
    }

    @StiSerializable
    public double getEndWidth() {
        return this.endWidth;
    }

    public void setEndWidth(double endWidth) {
        this.endWidth = endWidth;
        this.calculateWidthScaleHelper();
    }

    @StiSerializable
    public double getMajorInterval() {
        return this.majorInterval;
    }

    public void setMajorInterval(double majorInterval) {
        this.majorInterval = majorInterval;
    }

    @StiSerializable
    public double getMinorInterval() {
        return this.minorInterval;
    }

    public void setMinorInterval(double minorInterval) {
        this.minorInterval = minorInterval;
    }

    @StiSerializable
    public double getMinimum() {
        return this.minimum;
    }

    public void setMinimum(double minimum) {
        this.minimum = minimum;
        this.calculateMinMaxScaleHelper();
    }

    @StiSerializable
    public double getMaximum() {
        return this.maximum;
    }

    public void setMaximum(double maximum) {
        this.maximum = maximum;
        this.calculateMinMaxScaleHelper();
    }

    @StiSerializable
    public boolean getIsReversed() {
        return this.isReversed;
    }

    public void setIsReversed(boolean isReversed) {
        this.isReversed = isReversed;
    }

    @StiSerializable
    public StiBrush getBrush() {
        return this.brush;
    }

    public void setBrush(StiBrush brush) {
        this.brush = brush;
    }

    @StiSerializable
    public StiBrush getBorderBrush() {
        return this.borderBrush;
    }

    public void setBorderBrush(StiBrush borderBrush) {
        this.borderBrush = borderBrush;
    }

    @StiSerializable
    public StiGaugeElementCollection getItems() {
        return this.items;
    }

    public void setItems(StiGaugeElementCollection items) {
        this.items = items;
    }

    public abstract StiGaugeElemenType getScaleType();

    public void prepare(StiGauge gauge) {
        for (StiGaugeElement element : this.items) {
            element.prepareGaugeElement();
        }
    }

    public void calculateMinMaxScaleHelper() {
        if (this.minimum > this.maximum) {
            this.scaleHelper.ActualMaximum = this.maximum;
            this.scaleHelper.ActualMinimum = this.minimum;
        } else {
            this.scaleHelper.ActualMinimum = this.minimum;
            this.scaleHelper.ActualMaximum = this.maximum;
        }
        this.scaleHelper.setTotalLength(this.scaleHelper.ActualMaximum - this.scaleHelper.ActualMinimum);
    }

    public void calculateWidthScaleHelper() {
        if (this.startWidth > this.endWidth) {
            this.scaleHelper.MaxWidth = this.startWidth;
            this.scaleHelper.MinWidth = this.endWidth;
        } else {
            this.scaleHelper.MaxWidth = this.endWidth;
            this.scaleHelper.MinWidth = this.startWidth;
        }
    }

    public double getPosition(double value) {
        double value1 = value;
        if (value1 < this.scaleHelper.ActualMinimum) {
            value1 = this.scaleHelper.ActualMinimum;
        } else if (value1 > this.scaleHelper.ActualMaximum) {
            value1 = this.scaleHelper.ActualMaximum;
        }
        return StiMathHelper.length(this.scaleHelper.ActualMinimum, value1) / this.scaleHelper.totalLength;
    }

    public StiScaleBase createNew() {
        throw new RuntimeException("NotImplemented");
    }

    @Override
    public void drawElement(StiGaugeContextPainter context) {
        if (this.gauge != null) {
            this.barGeometry.drawScaleGeometry(context);
            for (int index = 0; index < this.items.size(); ++index) {
                ((StiGaugeElement)this.items.get(index)).drawElement(context);
            }
        }
    }

    public class StiScaleHelper {
        public double ActualMinimum = 0.0;
        public double ActualMaximum = 100.0;
        public double MinWidth = 0.1;
        public double MaxWidth = 0.1;
        private double totalLength = 10.0;

        public double getTotalLength() {
            return this.totalLength;
        }

        public void setTotalLength(double value) {
            this.totalLength = value == 0.0 ? 1.0 : value;
        }

        public Object clone() {
            StiScaleHelper cloned = new StiScaleHelper();
            cloned.ActualMaximum = this.ActualMaximum;
            cloned.ActualMinimum = this.ActualMinimum;
            cloned.MaxWidth = this.MaxWidth;
            cloned.MinWidth = this.MinWidth;
            cloned.totalLength = this.totalLength;
            return cloned;
        }
    }
}

