/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.indicators;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiFontStyle;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.enums.StiComponentId;
import com.stimulsoft.report.infographics.gauge.StiGaugeElemenType;
import com.stimulsoft.report.infographics.gauge.StiStateSkin;
import com.stimulsoft.report.infographics.gauge.collections.StiFilterCollection;
import com.stimulsoft.report.infographics.gauge.helpers.StiGaugeSkinHelper;
import com.stimulsoft.report.infographics.gauge.indicators.StiStateIndicatorFilter;
import com.stimulsoft.report.infographics.gauge.primitives.base.StiGaugeElement;
import com.stimulsoft.report.infographics.gauge.primitives.indicators.StiIndicatorBase;
import com.stimulsoft.report.infographics.gauge.skins.StiGaugeElementSkin;
import com.stimulsoft.report.painters.StiGaugeContextPainter;
import com.stimulsoft.report.painters.context.gauge.IStiGaugeMarker;

public class StiStateIndicator
extends StiIndicatorBase
implements IStiGaugeMarker {
    private StiStateIndicatorFilter lastFilter;
    private String format = "{0:F0}";
    private boolean showValue = false;
    private StiBrush textBrush = new StiSolidBrush(StiColorEnum.DimGray.color());
    private StiFont font = new StiFont("Atial", 7.0);
    private StiFilterCollection filters = new StiFilterCollection();
    private double left = 0.0;
    private double top = 0.0;
    private double relativeWidth = 0.05f;
    private double relativeHeight = 0.05f;
    private StiStateSkin skin = StiStateSkin.Ellipse;
    private StiGaugeElementSkin customSkin;

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        jObject.AddPropertyStringNullOfEmpty("Format", this.format);
        jObject.AddPropertyBool("ShowValue", this.showValue, false);
        jObject.AddPropertyStringNullOfEmpty("TextBrush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.textBrush));
        jObject.AddPropertyStringNullOfEmpty("Font", StiJsonReportObjectHelper.Serialize.font((StiFont)this.font, (String)"Arial", (float)8.0f, (int)StiFontStyle.Bold.intValue));
        jObject.AddPropertyFloat("Left", this.left, 0.0);
        jObject.AddPropertyFloat("Top", this.top, 0.0);
        jObject.AddPropertyFloat("RelativeHeight", this.relativeHeight, (double)0.05f);
        jObject.AddPropertyFloat("RelativeWidth", this.relativeWidth, (double)0.05f);
        jObject.AddPropertyEnum("Skin", (Enum)this.skin);
        if (mode == StiJsonSaveMode.Report) {
            jObject.AddPropertyJObject("Filters", this.filters.SaveToJsonObject(mode));
        }
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if ("Format".equals(property.Name)) {
                this.setFormat((String)property.Value);
                continue;
            }
            if ("ShowValue".equals(property.Name)) {
                this.setShowValue((Boolean)property.Value);
                continue;
            }
            if ("TextBrush".equals(property.Name)) {
                this.setTextBrush(StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property));
                continue;
            }
            if ("Font".equals(property.Name)) {
                this.setFont(StiJsonReportObjectHelper.Deserialize.Font((JProperty)property, (StiFont)this.font));
                continue;
            }
            if ("Left".equals(property.Name)) {
                this.setLeft((Double)property.Value);
                continue;
            }
            if ("Top".equals(property.Name)) {
                this.setTop((Double)property.Value);
                continue;
            }
            if ("RelativeHeight".equals(property.Name)) {
                this.setRelativeHeight((Double)property.Value);
                continue;
            }
            if ("RelativeWidth".equals(property.Name)) {
                this.setRelativeWidth((Double)property.Value);
                continue;
            }
            if ("Skin".equals(property.Name)) {
                this.setSkin(StiStateSkin.valueOf(property.Value.toString()));
                continue;
            }
            if (!"Filters".equals(property.Name)) continue;
            this.filters.LoadFromJsonObject((JSONObject)property.Value);
        }
    }

    @Override
    public Object clone() {
        StiStateIndicator indicator = (StiStateIndicator)super.clone();
        indicator.left = this.left;
        indicator.customSkin = this.customSkin;
        indicator.filters = this.filters != null ? (StiFilterCollection)this.filters.clone() : null;
        indicator.font = this.font != null ? (StiFont)this.font.clone() : null;
        indicator.format = this.format;
        indicator.lastFilter = this.lastFilter != null ? (StiStateIndicatorFilter)this.lastFilter.clone() : null;
        indicator.left = this.left;
        indicator.relativeHeight = this.relativeHeight;
        indicator.relativeWidth = this.relativeWidth;
        indicator.showValue = this.showValue;
        indicator.skin = this.skin;
        indicator.textBrush = this.textBrush != null ? (StiBrush)this.textBrush.clone() : null;
        indicator.top = this.top;
        return indicator;
    }

    public StiComponentId getComponentId() {
        return StiComponentId.StiStateIndicator;
    }

    @Override
    @StiSerializable
    public String getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    @StiSerializable
    public boolean isShowValue() {
        return this.showValue;
    }

    @Override
    public void setShowValue(boolean showValue) {
        this.showValue = showValue;
    }

    @Override
    @StiSerializable
    public StiBrush getTextBrush() {
        return this.textBrush;
    }

    @Override
    public void setTextBrush(StiBrush textBrush) {
        this.textBrush = textBrush;
    }

    @Override
    @StiSerializable
    public StiFont getFont() {
        return this.font;
    }

    @Override
    public void setFont(StiFont font) {
        this.font = font;
    }

    @Override
    public StiGaugeElemenType getElementType() {
        return StiGaugeElemenType.All;
    }

    @Override
    public String getLocalizeName() {
        return "StateIndicator";
    }

    @StiSerializable
    public StiFilterCollection getFilters() {
        return this.filters;
    }

    public void setFilters(StiFilterCollection filters) {
        this.filters = filters;
    }

    @StiSerializable
    public double getLeft() {
        return this.left;
    }

    public void setLeft(double left) {
        this.left = left;
    }

    @StiSerializable
    public double getTop() {
        return this.top;
    }

    public void setTop(double top) {
        this.top = top;
    }

    @StiSerializable
    public double getRelativeWidth() {
        return this.relativeWidth;
    }

    public void setRelativeWidth(double relativeWidth) {
        this.relativeWidth = relativeWidth;
    }

    @StiSerializable
    public double getRelativeHeight() {
        return this.relativeHeight;
    }

    public void setRelativeHeight(double relativeHeight) {
        this.relativeHeight = relativeHeight;
    }

    @StiSerializable
    public StiStateSkin getSkin() {
        return this.skin;
    }

    public void setSkin(StiStateSkin skin) {
        this.skin = skin;
    }

    @StiSerializable
    public StiGaugeElementSkin getCustomSkin() {
        return this.customSkin;
    }

    public void setCustomSkin(StiGaugeElementSkin customSkin) {
        this.customSkin = customSkin;
    }

    @Override
    public StiGaugeElement createNew() {
        return new StiStateIndicator();
    }

    @Override
    protected void onValueChanged() {
        if (this.filters != null && this.scale != null && this.scale.gauge != null && this.scale.gauge.getReport() != null) {
            StiStateIndicatorFilter currentFilter = null;
            Double value = this.getActualValue();
            for (int index = 0; index < this.filters.size(); ++index) {
                if (!(value >= ((StiStateIndicatorFilter)this.filters.get(index)).getStartValue()) || !(value <= ((StiStateIndicatorFilter)this.filters.get(index)).getEndValue())) continue;
                currentFilter = (StiStateIndicatorFilter)this.filters.get(index);
                break;
            }
            if (this.lastFilter != currentFilter) {
                this.lastFilter = currentFilter;
                if (currentFilter != null) {
                    this.setBrush(currentFilter.getBrush());
                    this.setBorderBrush(currentFilter.getBorderBrush());
                }
            }
        }
    }

    @Override
    protected void interactiveClick(StiRectangle rect, StiPoint p) {
    }

    @Override
    public void drawElement(StiGaugeContextPainter context) {
        StiSize size = this.scale.barGeometry.getSize();
        StiRectangle rectF = context.rect;
        StiRectangle rect = new StiRectangle(rectF.x + size.width * this.left, rectF.y + size.height * this.top, size.width * this.relativeWidth, size.height * this.relativeHeight);
        StiGaugeElementSkin skin = this.GetActualSkin();
        skin.draw(context, this, rect, null, null);
    }

    protected StiGaugeElementSkin GetActualSkin() {
        if (this.customSkin != null) {
            return this.customSkin;
        }
        return StiGaugeSkinHelper.getStateIndicatorSkin(this.skin);
    }
}

