/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.helpers;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiEmptyBrush;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiFontStyle;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.Func;
import com.stimulsoft.report.StiNameCreation;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.enums.StiOrientation;
import com.stimulsoft.report.infographics.gauge.StiGauge;
import com.stimulsoft.report.infographics.gauge.StiLabelRotationMode;
import com.stimulsoft.report.infographics.gauge.StiLinearBarSkin;
import com.stimulsoft.report.infographics.gauge.StiMarkerSkin;
import com.stimulsoft.report.infographics.gauge.StiNeedleSkin;
import com.stimulsoft.report.infographics.gauge.StiPlacement;
import com.stimulsoft.report.infographics.gauge.StiRadialScaleSkin;
import com.stimulsoft.report.infographics.gauge.StiRadiusMode;
import com.stimulsoft.report.infographics.gauge.StiTickMarkSkin;
import com.stimulsoft.report.infographics.gauge.expressions.StiSkipIndicesExpression;
import com.stimulsoft.report.infographics.gauge.expressions.StiSkipValuesExpression;
import com.stimulsoft.report.infographics.gauge.expressions.StiValueExpression;
import com.stimulsoft.report.infographics.gauge.indicators.StiLinearBar;
import com.stimulsoft.report.infographics.gauge.indicators.StiLinearIndicatorRangeInfo;
import com.stimulsoft.report.infographics.gauge.indicators.StiLinearMarker;
import com.stimulsoft.report.infographics.gauge.indicators.StiNeedle;
import com.stimulsoft.report.infographics.gauge.indicators.StiRadialBar;
import com.stimulsoft.report.infographics.gauge.indicators.StiRadialIndicatorRangeInfo;
import com.stimulsoft.report.infographics.gauge.indicators.StiRadialMarker;
import com.stimulsoft.report.infographics.gauge.indicators.StiStateIndicator;
import com.stimulsoft.report.infographics.gauge.indicators.StiStateIndicatorFilter;
import com.stimulsoft.report.infographics.gauge.primitives.base.StiGaugeElement;
import com.stimulsoft.report.infographics.gauge.primitives.scales.StiScaleBase;
import com.stimulsoft.report.infographics.gauge.range.StiLinearRange;
import com.stimulsoft.report.infographics.gauge.range.StiLinearRangeList;
import com.stimulsoft.report.infographics.gauge.range.StiRadialRange;
import com.stimulsoft.report.infographics.gauge.range.StiRadialRangeList;
import com.stimulsoft.report.infographics.gauge.scales.StiLinearScale;
import com.stimulsoft.report.infographics.gauge.scales.StiRadialScale;
import com.stimulsoft.report.infographics.gauge.tick.linear.label.StiLinearTickLabelMajor;
import com.stimulsoft.report.infographics.gauge.tick.linear.mark.StiLinearTickMarkCustom;
import com.stimulsoft.report.infographics.gauge.tick.linear.mark.StiLinearTickMarkMajor;
import com.stimulsoft.report.infographics.gauge.tick.linear.mark.StiLinearTickMarkMinor;
import com.stimulsoft.report.infographics.gauge.tick.radial.label.StiRadialTickLabelCustom;
import com.stimulsoft.report.infographics.gauge.tick.radial.label.StiRadialTickLabelCustomValue;
import com.stimulsoft.report.infographics.gauge.tick.radial.label.StiRadialTickLabelMajor;
import com.stimulsoft.report.infographics.gauge.tick.radial.mark.StiRadialTickMarkCustom;
import com.stimulsoft.report.infographics.gauge.tick.radial.mark.StiRadialTickMarkCustomValue;
import com.stimulsoft.report.infographics.gauge.tick.radial.mark.StiRadialTickMarkMajor;
import com.stimulsoft.report.infographics.gauge.tick.radial.mark.StiRadialTickMarkMinor;
import com.stimulsoft.report.units.StiUnit;
import java.util.Hashtable;

public class StiGaugeHelper {
    public static int GlobalDurationElement = 1800;
    public static int GlobalBeginTimeElement = 300;

    public static double getFloatValueFromObject(Object valueObj, StiScaleBase scale) {
        double result = scale.getMinimum();
        if (valueObj != null) {
            if (valueObj instanceof String) {
                try {
                    result = Double.parseDouble(valueObj.toString());
                    if (result < scale.getMinimum()) {
                        result = scale.getMinimum();
                    } else if (result > scale.getMaximum()) {
                        result = scale.getMaximum();
                    }
                }
                catch (Exception e) {
                    result = scale.getMinimum();
                }
            } else {
                result = Func.Convert.toSingle(valueObj);
            }
        }
        return result;
    }

    public static double getFloatValueFromObject(Object valueObj, double defaultValue) {
        double result = defaultValue;
        if (valueObj != null) {
            if (valueObj instanceof String) {
                try {
                    result = Double.parseDouble(valueObj.toString());
                    result = defaultValue;
                }
                catch (Exception exception) {}
            } else {
                result = Func.Convert.toSingle(valueObj);
            }
        }
        return result;
    }

    public static double[] getFloatArrayValueFromString(Object value) {
        String valueStr = (String)value;
        if (StiValidationUtil.isNullOrEmpty((String)valueStr)) {
            return null;
        }
        String[] strs = valueStr.split(";");
        double[] values = new double[strs.length];
        int index = -1;
        while (++index < strs.length) {
            try {
                double result;
                values[index] = result = Double.parseDouble(strs[index]);
            }
            catch (Exception e) {
                values = null;
                break;
            }
        }
        return values;
    }

    private static void initializeGauge(StiGauge gauge, double width, double height) {
        gauge.getScales().clear();
        if (gauge.getPage() != null) {
            StiUnit unit = gauge.getPage().getUnit();
            gauge.setClientRectangle(new StiRectangle(gauge.getLeft(), gauge.top, unit.ConvertFromHInches(width), unit.ConvertFromHInches(height)));
        }
    }

    private static void initializeName(StiGauge gauge, StiReport report) {
        if (StiValidationUtil.isNullOrEmpty((String)gauge.getName())) {
            String name = StiNameCreation.createSimpleName(report, StiNameCreation.generateName(gauge));
            gauge.setName(name);
            int index = -1;
            while (++index < gauge.getScales().size()) {
                Hashtable tableNames = new Hashtable();
                StiScaleBase scale = (StiScaleBase)gauge.getScales().get(index);
                int index1 = -1;
                while (++index1 < scale.getItems().size()) {
                    StiGaugeElement element = (StiGaugeElement)scale.getItems().get(index1);
                    Class<?> type = element.getClass();
                    int count = 0;
                    if (tableNames.containsKey(type)) {
                        count = (Integer)tableNames.get(type);
                    }
                    tableNames.put(type, ++count);
                }
            }
        }
    }

    public static void checkGaugeName(StiGauge gauge) {
        String name = gauge.getName();
        int index = -1;
        while (++index < gauge.getScales().size()) {
            Hashtable tableNames = new Hashtable();
            StiScaleBase scale = (StiScaleBase)gauge.getScales().get(index);
            int index1 = -1;
            while (++index1 < scale.getItems().size()) {
                StiGaugeElement element = (StiGaugeElement)scale.getItems().get(index1);
                Class<?> type = element.getClass();
                int count = 0;
                if (tableNames.containsKey(type)) {
                    count = (Integer)tableNames.get(type);
                }
                tableNames.put(type, ++count);
            }
        }
    }

    public static void simpleRadialGauge(StiGauge gauge, StiReport report) {
        StiGaugeHelper.initializeGauge(gauge, 250.0, 250.0);
        StiRadialScale radialScale1 = new StiRadialScale();
        radialScale1.setStartAngle(0.0);
        radialScale1.setSweepAngle(340.0);
        radialScale1.setStartWidth(0.05f);
        radialScale1.setEndWidth(0.05f);
        radialScale1.setMinimum(0.0);
        radialScale1.setMaximum(100.0);
        radialScale1.setMajorInterval(10.0);
        radialScale1.setMinorInterval(5.0);
        radialScale1.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)238, (int)238, (int)238)));
        StiRadialTickMarkMajor tickMarkMajor1 = new StiRadialTickMarkMajor();
        tickMarkMajor1.setPlacement(StiPlacement.Overlay);
        tickMarkMajor1.setOffsetAngle(-2.0);
        tickMarkMajor1.setRelativeWidth(0.05f);
        tickMarkMajor1.setRelativeHeight(0.02f);
        tickMarkMajor1.setSkin(StiTickMarkSkin.Rectangle);
        tickMarkMajor1.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.Black.color()));
        StiRadialTickMarkMinor tickMarkMinor1 = new StiRadialTickMarkMinor();
        tickMarkMinor1.setPlacement(StiPlacement.Overlay);
        tickMarkMinor1.setRelativeWidth(0.01f);
        tickMarkMinor1.setRelativeHeight(0.01f);
        tickMarkMinor1.setSkin(StiTickMarkSkin.Rectangle);
        StiRadialTickLabelMajor tickLabelMajor1 = new StiRadialTickLabelMajor();
        StiNeedle needle1 = new StiNeedle();
        needle1.setRelativeHeight(0.06f);
        needle1.setRelativeWidth(0.45f);
        needle1.setStartWidth(0.1f);
        needle1.setEndWidth(1.0);
        needle1.setCapBrush((StiBrush)new StiSolidBrush(StiColorEnum.White.color()));
        needle1.setCapBorderBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)244, (int)67, (int)54)));
        needle1.setCapBorderWidth(2.0);
        needle1.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)244, (int)67, (int)54)));
        needle1.setValue(new StiValueExpression("60"));
        radialScale1.getItems().add(tickMarkMajor1);
        radialScale1.getItems().add(tickMarkMinor1);
        radialScale1.getItems().add(tickLabelMajor1);
        radialScale1.getItems().add(needle1);
        gauge.getScales().add(radialScale1);
        StiGaugeHelper.initializeName(gauge, report);
    }

    public static void radialTwoScalesGauge(StiGauge gauge, StiReport report) {
        StiGaugeHelper.initializeGauge(gauge, 250.0, 250.0);
        StiRadialScale radialScale1 = new StiRadialScale();
        radialScale1.setStartAngle(270.0);
        radialScale1.setSweepAngle(360.0);
        radialScale1.setStartWidth(0.05f);
        radialScale1.setEndWidth(0.05f);
        radialScale1.setMinimum(0.0);
        radialScale1.setMaximum(60.0);
        radialScale1.setRadius(0.5);
        radialScale1.setMajorInterval(10.0);
        radialScale1.setMinorInterval(1.0);
        radialScale1.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)238, (int)238, (int)238)));
        StiRadialTickMarkMajor tickMarkMajor1 = new StiRadialTickMarkMajor();
        tickMarkMajor1.setPlacement(StiPlacement.Overlay);
        tickMarkMajor1.setRelativeWidth(0.05f);
        tickMarkMajor1.setOffsetAngle(-2.0);
        tickMarkMajor1.setRelativeHeight(0.03f);
        tickMarkMajor1.setSkin(StiTickMarkSkin.Rectangle);
        tickMarkMajor1.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.Black.color()));
        StiRadialTickLabelMajor tickLabelMajor1 = new StiRadialTickLabelMajor();
        tickLabelMajor1.setMinimumValue(1.0);
        tickLabelMajor1.setFont(new StiFont("Arial", 7.0));
        radialScale1.getItems().add(tickMarkMajor1);
        radialScale1.getItems().add(tickLabelMajor1);
        gauge.getScales().add(radialScale1);
        StiRadialScale radialScale2 = new StiRadialScale();
        radialScale2.setStartAngle(270.0);
        radialScale2.setSweepAngle(360.0);
        radialScale2.setStartWidth(0.05f);
        radialScale2.setEndWidth(0.05f);
        radialScale2.setMinimum(0.0);
        radialScale2.setMaximum(12.0);
        radialScale2.setRadius(0.75);
        radialScale2.setMajorInterval(1.0);
        radialScale2.setMinorInterval(0.0);
        radialScale2.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)238, (int)238, (int)238)));
        StiRadialTickMarkMajor tickMarkMajor2 = new StiRadialTickMarkMajor();
        tickMarkMajor2.setMinimumValue(1.0);
        tickMarkMajor2.setPlacement(StiPlacement.Overlay);
        tickMarkMajor2.setOffsetAngle(-2.0);
        tickMarkMajor2.setRelativeHeight(0.03f);
        tickMarkMajor2.setRelativeWidth(0.05f);
        tickMarkMajor2.setSkin(StiTickMarkSkin.Rectangle);
        tickMarkMajor2.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.Black.color()));
        tickMarkMajor2.setBorderBrush((StiBrush)new StiSolidBrush(StiColorEnum.White.color()));
        tickMarkMajor2.setBorderWidth(3.0);
        StiRadialTickLabelMajor tickLabelMajor2 = new StiRadialTickLabelMajor();
        tickLabelMajor2.setMinimumValue(1.0);
        StiNeedle needle1 = new StiNeedle();
        needle1.setValue(new StiValueExpression("2"));
        needle1.setOffsetNeedle(0.15f);
        needle1.setStartWidth(0.05f);
        needle1.setEndWidth(0.5);
        needle1.setRelativeHeight(0.12f);
        needle1.setRelativeWidth(0.6f);
        needle1.setCapBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)244, (int)67, (int)54)));
        needle1.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)244, (int)67, (int)54)));
        StiNeedle needle2 = new StiNeedle();
        needle2.setValue(new StiValueExpression("10"));
        needle2.setOffsetNeedle(0.15f);
        needle2.setStartWidth(0.05f);
        needle2.setEndWidth(0.5);
        needle2.setRelativeHeight(0.08f);
        needle2.setRelativeWidth(0.4f);
        needle2.setCapBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)3, (int)169, (int)244)));
        needle2.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)3, (int)169, (int)244)));
        radialScale2.getItems().add(tickMarkMajor2);
        radialScale2.getItems().add(tickLabelMajor2);
        radialScale2.getItems().add(needle1);
        radialScale2.getItems().add(needle2);
        gauge.getScales().add(radialScale2);
        StiGaugeHelper.initializeName(gauge, report);
    }

    public static void radialBarGauge(StiGauge gauge, StiReport report) {
        StiGaugeHelper.initializeGauge(gauge, 250.0, 250.0);
        StiRadialScale radialScale1 = new StiRadialScale();
        radialScale1.setStartAngle(120.0);
        radialScale1.setSweepAngle(300.0);
        radialScale1.setStartWidth(0.05f);
        radialScale1.setEndWidth(0.05f);
        radialScale1.setMinimum(0.0);
        radialScale1.setMaximum(180.0);
        radialScale1.setMajorInterval(90.0);
        radialScale1.setMinorInterval(10.0);
        radialScale1.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)238, (int)238, (int)238)));
        StiRadialTickMarkMajor tickMarkMajor1 = new StiRadialTickMarkMajor();
        tickMarkMajor1.setPlacement(StiPlacement.Inside);
        tickMarkMajor1.setOffsetAngle(-1.0);
        tickMarkMajor1.setRelativeWidth(0.05f);
        tickMarkMajor1.setRelativeHeight(0.015f);
        tickMarkMajor1.setSkin(StiTickMarkSkin.Rectangle);
        tickMarkMajor1.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.Black.color()));
        StiRadialTickMarkMinor tickMarkMinor1 = new StiRadialTickMarkMinor();
        tickMarkMinor1.setPlacement(StiPlacement.Inside);
        tickMarkMinor1.setRelativeWidth(0.03f);
        tickMarkMinor1.setRelativeHeight(0.005f);
        tickMarkMinor1.setSkin(StiTickMarkSkin.Rectangle);
        tickMarkMinor1.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.Black.color()));
        StiRadialTickLabelMajor tickLabelMajor1 = new StiRadialTickLabelMajor();
        tickLabelMajor1.setPlacement(StiPlacement.Inside);
        tickLabelMajor1.setMinimumValue(1.0);
        tickLabelMajor1.setOffset(0.15f);
        StiRadialBar radialBar = new StiRadialBar();
        radialBar.setStartWidth(0.1f);
        radialBar.setEndWidth(0.1f);
        radialBar.setOffset(0.1f);
        radialBar.setPlacement(StiPlacement.Outside);
        radialBar.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)0, (int)150, (int)136)));
        radialBar.setValue(new StiValueExpression("90"));
        StiNeedle needle1 = new StiNeedle();
        needle1.setRelativeHeight(0.3f);
        needle1.setRelativeWidth(0.4f);
        needle1.setStartWidth(0.1f);
        needle1.setEndWidth(1.0);
        needle1.setCapBrush((StiBrush)new StiEmptyBrush());
        needle1.setBrush((StiBrush)new StiEmptyBrush());
        needle1.setTextBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)0, (int)150, (int)136)));
        needle1.setFont(new StiFont("Arial", 36.0));
        needle1.setValue(new StiValueExpression("90"));
        radialScale1.getItems().add(tickMarkMajor1);
        radialScale1.getItems().add(tickMarkMinor1);
        radialScale1.getItems().add(tickLabelMajor1);
        radialScale1.getItems().add(radialBar);
        radialScale1.getItems().add(needle1);
        gauge.getScales().add(radialScale1);
        StiGaugeHelper.initializeName(gauge, report);
    }

    public static void simpleTwoBarGauge(StiGauge gauge, StiReport report) {
        StiGaugeHelper.initializeGauge(gauge, 250.0, 250.0);
        StiRadialScale radialScale1 = new StiRadialScale();
        radialScale1.setMinimum(0.0);
        radialScale1.setMaximum(180.0);
        radialScale1.setMajorInterval(20.0);
        radialScale1.setMinorInterval(10.0);
        radialScale1.setStartWidth(0.05f);
        radialScale1.setEndWidth(0.05f);
        radialScale1.setStartAngle(120.0);
        radialScale1.setSweepAngle(300.0);
        radialScale1.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)238, (int)238, (int)238)));
        StiRadialTickMarkMajor tickMarkMajor1 = new StiRadialTickMarkMajor();
        tickMarkMajor1.setPlacement(StiPlacement.Overlay);
        tickMarkMajor1.setOffsetAngle(-1.0);
        tickMarkMajor1.setRelativeWidth(0.05f);
        tickMarkMajor1.setRelativeHeight(0.02f);
        tickMarkMajor1.setSkin(StiTickMarkSkin.Rectangle);
        tickMarkMajor1.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.Black.color()));
        tickMarkMajor1.setBorderBrush((StiBrush)new StiSolidBrush(StiColorEnum.White.color()));
        tickMarkMajor1.setBorderWidth(1.0);
        StiRadialTickMarkMinor tickMarkMinor1 = new StiRadialTickMarkMinor();
        tickMarkMinor1.setPlacement(StiPlacement.Overlay);
        tickMarkMinor1.setRelativeWidth(0.01f);
        tickMarkMinor1.setRelativeHeight(0.01f);
        tickMarkMinor1.setSkin(StiTickMarkSkin.Diamond);
        tickMarkMinor1.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.Black.color()));
        tickMarkMinor1.setBorderBrush((StiBrush)new StiSolidBrush(StiColorEnum.Gray.color()));
        tickMarkMinor1.setBorderWidth(1.0);
        StiRadialTickLabelMajor tickLabelMajor1 = new StiRadialTickLabelMajor();
        tickLabelMajor1.setPlacement(StiPlacement.Inside);
        tickLabelMajor1.setOffset(0.15f);
        StiRadialBar radialBar1 = new StiRadialBar();
        radialBar1.setStartWidth(0.05f);
        radialBar1.setEndWidth(0.05f);
        radialBar1.setOffset(0.0);
        radialBar1.setPlacement(StiPlacement.Outside);
        radialBar1.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)3, (int)169, (int)244)));
        radialBar1.setValue(new StiValueExpression("80"));
        StiRadialBar radialBar2 = new StiRadialBar();
        radialBar2.setStartWidth(0.05f);
        radialBar2.setEndWidth(0.05f);
        radialBar2.setOffset(0.0);
        radialBar2.setPlacement(StiPlacement.Inside);
        radialBar2.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)255, (int)235, (int)59)));
        radialBar2.setValue(new StiValueExpression("120"));
        StiRadialMarker radialMarker1 = new StiRadialMarker();
        radialMarker1.setValue(new StiValueExpression("100"));
        radialMarker1.setOffset(0.25);
        radialMarker1.setRelativeHeight(0.05f);
        radialMarker1.setRelativeWidth(0.05f);
        radialMarker1.setSkin(StiMarkerSkin.TriangleRight);
        radialMarker1.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)76, (int)175, (int)80)));
        radialScale1.getItems().add(tickMarkMajor1);
        radialScale1.getItems().add(tickMarkMinor1);
        radialScale1.getItems().add(tickLabelMajor1);
        radialScale1.getItems().add(radialBar1);
        radialScale1.getItems().add(radialBar2);
        radialScale1.getItems().add(radialMarker1);
        gauge.getScales().add(radialScale1);
        StiGaugeHelper.initializeName(gauge, report);
    }

    public static void defaultRadialGauge(StiGauge gauge, StiReport report) {
        StiGaugeHelper.initializeGauge(gauge, 250.0, 250.0);
        StiRadialScale radialScale1 = new StiRadialScale();
        radialScale1.setStartAngle(0.0);
        radialScale1.setSweepAngle(340.0);
        radialScale1.setStartWidth(0.05f);
        radialScale1.setEndWidth(0.05f);
        radialScale1.setMinimum(0.0);
        radialScale1.setMaximum(100.0);
        radialScale1.setMajorInterval(10.0);
        radialScale1.setMinorInterval(5.0);
        StiRadialTickMarkMajor tickMarkMajor1 = new StiRadialTickMarkMajor();
        tickMarkMajor1.setPlacement(StiPlacement.Overlay);
        tickMarkMajor1.setOffsetAngle(-2.0);
        tickMarkMajor1.setRelativeWidth(0.06f);
        tickMarkMajor1.setRelativeHeight(0.03f);
        tickMarkMajor1.setSkin(StiTickMarkSkin.TriangleRight);
        StiRadialTickLabelMajor tickLabelMajor1 = new StiRadialTickLabelMajor();
        StiNeedle needle1 = new StiNeedle();
        needle1.setRelativeHeight(0.14f);
        needle1.setRelativeWidth(0.5);
        radialScale1.getItems().add(tickMarkMajor1);
        radialScale1.getItems().add(tickLabelMajor1);
        radialScale1.getItems().add(needle1);
        gauge.getScales().add(radialScale1);
        StiGaugeHelper.initializeName(gauge, report);
    }

    public static void defaultLinearGauge(StiGauge gauge, StiReport report) {
        StiGaugeHelper.initializeGauge(gauge, 120.0, 240.0);
        StiLinearScale scale = new StiLinearScale();
        scale.setStartWidth(0.1f);
        scale.setEndWidth(0.1f);
        scale.setMaximum(100.0);
        scale.setMinorInterval(5.0);
        scale.setBorderBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)158, (int)158, (int)158)));
        scale.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)238, (int)238, (int)238)));
        StiLinearTickMarkMajor tickMarkMajor = new StiLinearTickMarkMajor();
        tickMarkMajor.setBorderBrush((StiBrush)new StiEmptyBrush());
        tickMarkMajor.setBorderWidth(0.0);
        tickMarkMajor.setRelativeHeight(0.005f);
        tickMarkMajor.setRelativeWidth(0.05f);
        tickMarkMajor.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)158, (int)158, (int)158)));
        StiLinearTickLabelMajor tickLabelMajor = new StiLinearTickLabelMajor();
        tickLabelMajor.setPlacement(StiPlacement.Inside);
        tickLabelMajor.setTextBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)158, (int)158, (int)158)));
        StiLinearBar linearBar = new StiLinearBar();
        linearBar.setStartWidth(0.1f);
        linearBar.setEndWidth(0.1f);
        linearBar.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)0, (int)150, (int)136)));
        linearBar.setValue(new StiValueExpression("65"));
        scale.getItems().add(tickMarkMajor);
        scale.getItems().add(tickLabelMajor);
        scale.getItems().add(linearBar);
        gauge.getScales().add(scale);
        StiGaugeHelper.initializeName(gauge, report);
    }

    public static void linearGaugeRangeList(StiGauge gauge, StiReport report) {
        StiGaugeHelper.initializeGauge(gauge, 120.0, 240.0);
        StiLinearScale scale = new StiLinearScale();
        scale.setStartWidth(0.1f);
        scale.setEndWidth(0.1f);
        scale.setMaximum(100.0);
        scale.setMinorInterval(5.0);
        scale.setBorderBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)158, (int)158, (int)158)));
        scale.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)238, (int)238, (int)238)));
        StiLinearRangeList linearRangeList = new StiLinearRangeList();
        StiLinearRange linearRange1 = new StiLinearRange();
        linearRange1.setStartValue(0.0);
        linearRange1.setEndValue(50.0);
        linearRange1.setBrush((StiBrush)new StiGradientBrush(StiColor.fromArgb((int)205, (int)220, (int)57), StiColor.fromArgb((int)139, (int)195, (int)74), 90.0));
        linearRange1.setStartWidth(0.07f);
        linearRange1.setEndWidth(0.07f);
        StiLinearRange linearRange2 = new StiLinearRange();
        linearRange2.setStartValue(45.0);
        linearRange2.setEndValue(75.0);
        linearRange2.setBrush((StiBrush)new StiGradientBrush(StiColor.fromArgb((int)255, (int)193, (int)7), StiColor.fromArgb((int)255, (int)235, (int)59), 90.0));
        linearRange2.setStartWidth(0.07f);
        linearRange2.setEndWidth(0.07f);
        StiLinearRange linearRange3 = new StiLinearRange();
        linearRange3.setStartValue(75.0);
        linearRange3.setEndValue(100.0);
        linearRange3.setBrush((StiBrush)new StiGradientBrush(StiColor.fromArgb((int)255, (int)152, (int)0), StiColor.fromArgb((int)255, (int)152, (int)0), 90.0));
        linearRange3.setStartWidth(0.07f);
        linearRange3.setEndWidth(0.07f);
        linearRangeList.getRanges().add(linearRange1);
        linearRangeList.getRanges().add(linearRange2);
        linearRangeList.getRanges().add(linearRange3);
        StiLinearTickLabelMajor linearTickLabelMajor = new StiLinearTickLabelMajor();
        linearTickLabelMajor.setPlacement(StiPlacement.Inside);
        linearTickLabelMajor.setTextBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)158, (int)158, (int)158)));
        StiLinearTickMarkMajor linearTickMarkMajor = new StiLinearTickMarkMajor();
        linearTickMarkMajor.setBorderBrush((StiBrush)new StiEmptyBrush());
        linearTickMarkMajor.setBorderWidth(0.0);
        linearTickMarkMajor.setRelativeHeight(0.005f);
        linearTickMarkMajor.setRelativeWidth(0.05f);
        linearTickMarkMajor.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)158, (int)158, (int)158)));
        StiLinearTickMarkMinor linearTickMarkMinor = new StiLinearTickMarkMinor();
        linearTickMarkMinor.setPlacement(StiPlacement.Overlay);
        linearTickMarkMinor.setRelativeWidth(0.08f);
        linearTickMarkMinor.setRelativeHeight(0.006f);
        linearTickMarkMinor.setBorderBrush((StiBrush)new StiEmptyBrush());
        StiLinearMarker linearMarker1 = new StiLinearMarker();
        linearMarker1.setRelativeWidth(0.18f);
        linearMarker1.setRelativeHeight(0.04f);
        linearMarker1.setPlacement(StiPlacement.Overlay);
        linearMarker1.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)205, (int)220, (int)57)));
        scale.getItems().add(linearRangeList);
        scale.getItems().add(linearTickLabelMajor);
        scale.getItems().add(linearTickMarkMajor);
        scale.getItems().add(linearTickMarkMinor);
        scale.getItems().add(linearMarker1);
        gauge.getScales().add(scale);
        StiGaugeHelper.initializeName(gauge, report);
    }

    public static void bulletGraphsGreen(StiGauge gauge, StiReport report) {
        StiGaugeHelper.initializeGauge(gauge, 300.0, 100.0);
        StiLinearScale linearScale1 = new StiLinearScale();
        linearScale1.setRelativeHeight(0.94f);
        linearScale1.setStartWidth(0.01f);
        linearScale1.setEndWidth(0.01f);
        linearScale1.setMaximum(100.0);
        linearScale1.setMajorInterval(20.0);
        linearScale1.setOrientation(StiOrientation.Horizontal);
        linearScale1.setBrush((StiBrush)new StiEmptyBrush());
        linearScale1.setBorderBrush((StiBrush)new StiEmptyBrush());
        StiLinearRangeList linearRangeList1 = new StiLinearRangeList();
        double startValue = 0.0;
        int index = 0;
        while (++index < 11) {
            StiLinearRange linearRange = new StiLinearRange();
            linearRange.setStartValue(startValue);
            linearRange.setEndValue(startValue += 10.0);
            linearRange.setStartWidth(0.5);
            linearRange.setEndWidth(0.5);
            linearRange.setPlacement(StiPlacement.Overlay);
            linearRange.setBorderBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)150, (int)139, (int)138, (int)135)));
            if (index >= 1 && index <= 3) {
                linearRange.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)165, (int)214, (int)167)));
            } else if (index >= 4 && index <= 7) {
                linearRange.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)76, (int)175, (int)80)));
            } else {
                linearRange.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)46, (int)125, (int)50)));
            }
            linearRangeList1.getRanges().add(linearRange);
        }
        StiLinearTickLabelMajor linearTickLabelMajor1 = new StiLinearTickLabelMajor();
        linearTickLabelMajor1.setOffset(0.25);
        StiLinearTickMarkCustom linearTickMarkCustom1 = new StiLinearTickMarkCustom();
        linearTickMarkCustom1.setPlacement(StiPlacement.Overlay);
        linearTickMarkCustom1.setRelativeWidth(0.015f);
        linearTickMarkCustom1.setRelativeHeight(0.3f);
        linearTickMarkCustom1.setBrush((StiBrush)new StiGradientBrush(StiColor.fromArgb((int)100, (int)100, (int)100), StiColor.fromArgb((int)10, (int)10, (int)10), 90.0));
        linearTickMarkCustom1.setValueObj(80.0);
        StiLinearBar linearBar1 = new StiLinearBar();
        linearBar1.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.Black.color()));
        linearBar1.setStartWidth(0.1f);
        linearBar1.setEndWidth(0.1f);
        linearScale1.getItems().add(linearRangeList1);
        linearScale1.getItems().add(linearTickLabelMajor1);
        linearScale1.getItems().add(linearTickMarkCustom1);
        linearScale1.getItems().add(linearBar1);
        gauge.getScales().add(linearScale1);
        StiGaugeHelper.initializeName(gauge, report);
    }

    public static void halfDonutsGauge(StiGauge gauge, StiReport report) {
        StiGaugeHelper.initializeGauge(gauge, 280.0, 165.0);
        StiRadialScale radialScale1 = new StiRadialScale();
        radialScale1.setStartAngle(180.0);
        radialScale1.setSweepAngle(180.0);
        radialScale1.setMinimum(0.0);
        radialScale1.setMaximum(150.0);
        radialScale1.setRadius(0.75);
        radialScale1.setCenter(new StiPoint(0.5, (double)0.8f));
        radialScale1.setRadiusMode(StiRadiusMode.Width);
        radialScale1.setSkin(StiRadialScaleSkin.Empty);
        StiRadialBar radialBar1 = new StiRadialBar();
        radialBar1.setBorderBrush((StiBrush)new StiEmptyBrush());
        radialBar1.setBorderWidth(0.0);
        radialBar1.setStartWidth(0.3f);
        radialBar1.setEndWidth(0.3f);
        radialBar1.setEmptyBrush((StiBrush)new StiGradientBrush(StiColor.fromArgb((int)221, (int)221, (int)221), StiColor.fromArgb((int)240, (int)240, (int)240), 90.0));
        radialBar1.setUseRangeColor(true);
        radialBar1.setValue(new StiValueExpression("60"));
        StiRadialIndicatorRangeInfo range1 = new StiRadialIndicatorRangeInfo();
        range1.setValue(0.0);
        range1.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)139, (int)195, (int)74)));
        StiRadialIndicatorRangeInfo range2 = new StiRadialIndicatorRangeInfo();
        range2.setValue(50.0);
        range2.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)255, (int)235, (int)59)));
        StiRadialIndicatorRangeInfo range3 = new StiRadialIndicatorRangeInfo();
        range3.setValue(100.0);
        range3.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)244, (int)67, (int)54)));
        radialBar1.getRangeList().add(range1);
        radialBar1.getRangeList().add(range2);
        radialBar1.getRangeList().add(range3);
        StiNeedle needle1 = new StiNeedle();
        needle1.setRelativeHeight(0.05f);
        needle1.setRelativeWidth(0.4f);
        needle1.setStartWidth(0.1f);
        needle1.setEndWidth(0.2f);
        needle1.setCapBrush((StiBrush)new StiSolidBrush(StiColorEnum.White.color()));
        needle1.setCapBorderBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)0, (int)150, (int)136)));
        needle1.setCapBorderWidth(2.0);
        needle1.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)0, (int)150, (int)136)));
        needle1.setBorderWidth(0.0);
        needle1.setTextBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)0, (int)150, (int)136)));
        needle1.setValue(new StiValueExpression("60"));
        radialScale1.getItems().add(radialBar1);
        radialScale1.getItems().add(needle1);
        gauge.getScales().add(radialScale1);
        StiGaugeHelper.initializeName(gauge, report);
    }

    public static void halfDonutsGauge2(StiGauge gauge, StiReport report) {
        StiGaugeHelper.initializeGauge(gauge, 280.0, 165.0);
        StiRadialScale radialScale1 = new StiRadialScale();
        radialScale1.setStartAngle(180.0);
        radialScale1.setSweepAngle(180.0);
        radialScale1.setMinimum(0.0);
        radialScale1.setMaximum(100.0);
        radialScale1.setRadius(0.75);
        radialScale1.setCenter(new StiPoint(0.5, (double)0.8f));
        radialScale1.setRadiusMode(StiRadiusMode.Width);
        radialScale1.setSkin(StiRadialScaleSkin.Empty);
        StiRadialBar radialBar1 = new StiRadialBar();
        radialBar1.setBorderBrush((StiBrush)new StiEmptyBrush());
        radialBar1.setStartWidth(0.3f);
        radialBar1.setEndWidth(0.3f);
        radialBar1.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)79, (int)134, (int)194)));
        radialBar1.setEmptyBrush((StiBrush)new StiGradientBrush(StiColor.fromArgb((int)221, (int)221, (int)221), StiColor.fromArgb((int)240, (int)240, (int)240), 90.0));
        radialBar1.setEmptyBorderBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)79, (int)134, (int)194)));
        radialBar1.setEmptyBorderWidth(3.0);
        radialScale1.getItems().add(radialBar1);
        gauge.getScales().add(radialScale1);
        StiGaugeHelper.initializeName(gauge, report);
    }

    public static void radialGaugeHalfCircleN(StiGauge gauge, StiReport report) {
        StiGaugeHelper.initializeGauge(gauge, 260.0, 150.0);
        StiRadialScale radialScale1 = new StiRadialScale();
        radialScale1.setRadiusMode(StiRadiusMode.Width);
        radialScale1.setSkin(StiRadialScaleSkin.RadialScaleHalfCircleN);
        radialScale1.setStartAngle(180.0);
        radialScale1.setSweepAngle(180.0);
        radialScale1.setMaximum(100.0);
        radialScale1.setCenter(new StiPoint(0.5, (double)0.85f));
        radialScale1.setRadius(0.75);
        radialScale1.setStartWidth(0.005f);
        radialScale1.setEndWidth(0.005f);
        radialScale1.setMajorInterval(10.0);
        radialScale1.setMinorInterval(5.0);
        radialScale1.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.Gray.color()));
        StiRadialTickMarkMajor radialTickMarkMajor1 = new StiRadialTickMarkMajor();
        radialTickMarkMajor1.setPlacement(StiPlacement.Overlay);
        radialTickMarkMajor1.setOffset(0.035f);
        radialTickMarkMajor1.setRelativeWidth(0.05f);
        radialTickMarkMajor1.setRelativeHeight(0.007f);
        radialTickMarkMajor1.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.Gray.color()));
        radialTickMarkMajor1.setBorderBrush((StiBrush)new StiEmptyBrush());
        StiRadialTickMarkMinor radialTickMarkMinor1 = new StiRadialTickMarkMinor();
        radialTickMarkMinor1.setPlacement(StiPlacement.Overlay);
        radialTickMarkMinor1.setOffset(0.017f);
        radialTickMarkMinor1.setRelativeWidth(0.03f);
        radialTickMarkMinor1.setRelativeHeight(0.007f);
        radialTickMarkMinor1.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.LightGray.color()));
        radialTickMarkMinor1.setBorderBrush((StiBrush)new StiEmptyBrush());
        StiRadialTickLabelMajor radialTickLabelMajor1 = new StiRadialTickLabelMajor();
        radialTickLabelMajor1.setLabelRotationMode(StiLabelRotationMode.Automatic);
        radialTickLabelMajor1.setTextBrush((StiBrush)new StiSolidBrush(StiColorEnum.Black.color()));
        StiNeedle needle1 = new StiNeedle();
        needle1.setValue(new StiValueExpression("45"));
        needle1.setCapBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)3, (int)169, (int)244)));
        needle1.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)3, (int)169, (int)244)));
        needle1.setStartWidth(0.1f);
        needle1.setEndWidth(0.99f);
        needle1.setRelativeWidth(0.5);
        needle1.setRelativeHeight(0.04f);
        radialScale1.getItems().add(radialTickMarkMajor1);
        radialScale1.getItems().add(radialTickMarkMinor1);
        radialScale1.getItems().add(radialTickLabelMajor1);
        radialScale1.getItems().add(needle1);
        gauge.getScales().add(radialScale1);
        StiGaugeHelper.initializeName(gauge, report);
    }

    public static void radialGaugeHalfCircleS(StiGauge gauge, StiReport report) {
        StiGaugeHelper.initializeGauge(gauge, 260.0, 150.0);
        StiRadialScale radialScale1 = new StiRadialScale();
        radialScale1.setRadiusMode(StiRadiusMode.Width);
        radialScale1.setSkin(StiRadialScaleSkin.RadialScaleHalfCircleS);
        radialScale1.setStartAngle(0.0);
        radialScale1.setSweepAngle(180.0);
        radialScale1.setMaximum(100.0);
        radialScale1.setCenter(new StiPoint(0.5, (double)0.15f));
        radialScale1.setRadius(0.75);
        radialScale1.setStartWidth(0.005f);
        radialScale1.setEndWidth(0.005f);
        radialScale1.setMajorInterval(10.0);
        radialScale1.setMinorInterval(5.0);
        radialScale1.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.Gray.color()));
        StiRadialTickMarkMajor radialTickMarkMajor1 = new StiRadialTickMarkMajor();
        radialTickMarkMajor1.setPlacement(StiPlacement.Overlay);
        radialTickMarkMajor1.setOffset(0.035f);
        radialTickMarkMajor1.setRelativeWidth(0.05f);
        radialTickMarkMajor1.setRelativeHeight(0.007f);
        radialTickMarkMajor1.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.Gray.color()));
        radialTickMarkMajor1.setBorderBrush((StiBrush)new StiEmptyBrush());
        StiRadialTickMarkMinor radialTickMarkMinor1 = new StiRadialTickMarkMinor();
        radialTickMarkMinor1.setPlacement(StiPlacement.Overlay);
        radialTickMarkMinor1.setOffset(0.017f);
        radialTickMarkMinor1.setRelativeWidth(0.03f);
        radialTickMarkMinor1.setRelativeHeight(0.007f);
        radialTickMarkMinor1.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.LightGray.color()));
        radialTickMarkMinor1.setBorderBrush((StiBrush)new StiEmptyBrush());
        StiRadialTickLabelMajor radialTickLabelMajor1 = new StiRadialTickLabelMajor();
        radialTickLabelMajor1.setLabelRotationMode(StiLabelRotationMode.Automatic);
        radialTickLabelMajor1.setTextBrush((StiBrush)new StiSolidBrush(StiColorEnum.Black.color()));
        StiNeedle needle1 = new StiNeedle();
        needle1.setValue(new StiValueExpression("45"));
        needle1.setCapBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)3, (int)169, (int)244)));
        needle1.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)3, (int)169, (int)244)));
        needle1.setStartWidth(0.1f);
        needle1.setEndWidth(0.99f);
        needle1.setRelativeWidth(0.5);
        needle1.setRelativeHeight(0.04f);
        radialScale1.getItems().add(radialTickMarkMajor1);
        radialScale1.getItems().add(radialTickMarkMinor1);
        radialScale1.getItems().add(radialTickLabelMajor1);
        radialScale1.getItems().add(needle1);
        gauge.getScales().add(radialScale1);
        StiGaugeHelper.initializeName(gauge, report);
    }

    public static void radialGaugeQuarterCircleNW(StiGauge gauge, StiReport report) {
        StiGaugeHelper.radialGaugeQuarterCircle(gauge, report, StiRadialScaleSkin.RadialScaleQuarterCircleNW, 180.0, new StiPoint((double)0.9f, (double)0.9f));
    }

    public static void radialGaugeQuarterCircleNE(StiGauge gauge, StiReport report) {
        StiGaugeHelper.radialGaugeQuarterCircle(gauge, report, StiRadialScaleSkin.RadialScaleQuarterCircleNE, 270.0, new StiPoint((double)0.1f, (double)0.9f));
    }

    public static void radialGaugeQuarterCircleSW(StiGauge gauge, StiReport report) {
        StiGaugeHelper.radialGaugeQuarterCircle(gauge, report, StiRadialScaleSkin.RadialScaleQuarterCircleSW, 90.0, new StiPoint((double)0.9f, (double)0.1f));
    }

    public static void radialGaugeQuarterCircleSE(StiGauge gauge, StiReport report) {
        StiGaugeHelper.radialGaugeQuarterCircle(gauge, report, StiRadialScaleSkin.RadialScaleQuarterCircleSE, 0.0, new StiPoint((double)0.1f, (double)0.1f));
    }

    private static void radialGaugeQuarterCircle(StiGauge gauge, StiReport report, StiRadialScaleSkin scaleSkin, double startAngle, StiPoint center) {
        StiGaugeHelper.initializeGauge(gauge, 250.0, 250.0);
        StiRadialScale radialScale1 = new StiRadialScale();
        radialScale1.setSkin(scaleSkin);
        radialScale1.setStartAngle(startAngle);
        radialScale1.setSweepAngle(90.0);
        radialScale1.setMaximum(100.0);
        radialScale1.setCenter(center);
        radialScale1.setRadius(1.5);
        radialScale1.setStartWidth(0.005f);
        radialScale1.setEndWidth(0.005f);
        radialScale1.setMajorInterval(10.0);
        radialScale1.setMinorInterval(5.0);
        StiRadialTickMarkMajor radialTickMarkMajor1 = new StiRadialTickMarkMajor();
        radialTickMarkMajor1.setPlacement(StiPlacement.Overlay);
        radialTickMarkMajor1.setOffset(0.045f);
        radialTickMarkMajor1.setRelativeWidth(0.03f);
        radialTickMarkMajor1.setRelativeHeight(0.004f);
        radialTickMarkMajor1.setBorderBrush((StiBrush)new StiEmptyBrush());
        radialTickMarkMajor1.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.Gray.color()));
        StiRadialTickMarkMinor radialTickMarkMinor1 = new StiRadialTickMarkMinor();
        radialTickMarkMinor1.setPlacement(StiPlacement.Overlay);
        radialTickMarkMinor1.setOffset(0.04f);
        radialTickMarkMinor1.setRelativeWidth(0.02f);
        radialTickMarkMinor1.setRelativeHeight(0.004f);
        radialTickMarkMinor1.setBorderBrush((StiBrush)new StiEmptyBrush());
        radialTickMarkMinor1.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.Gray.color()));
        StiRadialTickLabelMajor radialTickLabelMajor1 = new StiRadialTickLabelMajor();
        radialTickLabelMajor1.setLabelRotationMode(StiLabelRotationMode.Automatic);
        StiNeedle needle1 = new StiNeedle();
        needle1.setValue(new StiValueExpression("45"));
        needle1.setCapBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)244, (int)67, (int)54)));
        needle1.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)244, (int)67, (int)54)));
        needle1.setStartWidth(0.1f);
        needle1.setEndWidth(0.99f);
        needle1.setRelativeWidth(0.5);
        needle1.setRelativeHeight(0.04f);
        radialScale1.getItems().add(radialTickMarkMajor1);
        radialScale1.getItems().add(radialTickMarkMinor1);
        radialScale1.getItems().add(radialTickLabelMajor1);
        radialScale1.getItems().add(needle1);
        gauge.getScales().add(radialScale1);
        StiGaugeHelper.initializeName(gauge, report);
    }

    public static void horizontalThermometer(StiGauge gauge, StiReport report) {
        StiGaugeHelper.initializeGauge(gauge, 300.0, 50.0);
        StiLinearScale linearScale = new StiLinearScale();
        linearScale.setOrientation(StiOrientation.Horizontal);
        linearScale.setRelativeHeight(0.85f);
        linearScale.setLeft(0.03f);
        linearScale.setStartWidth(0.17f);
        linearScale.setEndWidth(0.17f);
        linearScale.setMaximum(80.0);
        linearScale.setMajorInterval(20.0);
        linearScale.setMinorInterval(4.0);
        StiLinearBar linearBar = new StiLinearBar();
        linearBar.setSkin(StiLinearBarSkin.HorizontalThermometer);
        linearBar.setPlacement(StiPlacement.Outside);
        linearBar.setStartWidth(0.2f);
        linearBar.setEndWidth(0.2f);
        linearBar.setUseRangeColor(true);
        StiLinearIndicatorRangeInfo indicatorRange1 = new StiLinearIndicatorRangeInfo();
        indicatorRange1.setValue(0.0);
        indicatorRange1.setBrush((StiBrush)new StiGradientBrush(StiColor.fromArgb((int)137, (int)188, (int)41), StiColor.fromArgb((int)111, (int)163, (int)14), 90.0));
        StiLinearIndicatorRangeInfo indicatorRange2 = new StiLinearIndicatorRangeInfo();
        indicatorRange2.setValue(40.0);
        indicatorRange2.setBrush((StiBrush)new StiGradientBrush(StiColor.fromArgb((int)217, (int)173, (int)45), StiColor.fromArgb((int)222, (int)166, (int)0), 90.0));
        StiLinearIndicatorRangeInfo indicatorRange3 = new StiLinearIndicatorRangeInfo();
        indicatorRange3.setValue(65.0);
        indicatorRange3.setBrush((StiBrush)new StiGradientBrush(StiColor.fromArgb((int)208, (int)49, (int)52), StiColor.fromArgb((int)186, (int)6, (int)10), 90.0));
        linearBar.getRangeList().add(indicatorRange1);
        linearBar.getRangeList().add(indicatorRange2);
        linearBar.getRangeList().add(indicatorRange3);
        StiLinearTickMarkMajor tickMarkMajor = new StiLinearTickMarkMajor();
        tickMarkMajor.setPlacement(StiPlacement.Overlay);
        tickMarkMajor.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)159, (int)159, (int)159)));
        tickMarkMajor.setRelativeWidth(0.01f);
        tickMarkMajor.setRelativeHeight(0.18f);
        tickMarkMajor.setOffset(-0.1f);
        StiLinearTickMarkMinor tickMarkMinor = new StiLinearTickMarkMinor();
        tickMarkMinor.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)159, (int)159, (int)159)));
        tickMarkMinor.setRelativeWidth(0.005f);
        tickMarkMinor.setRelativeHeight(0.1f);
        tickMarkMinor.setOffset(-0.14f);
        StiLinearTickLabelMajor tickLabelMajor = new StiLinearTickLabelMajor();
        tickLabelMajor.setPlacement(StiPlacement.Inside);
        tickLabelMajor.setOffset(0.11f);
        tickLabelMajor.setTextBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)83, (int)85, (int)86)));
        tickLabelMajor.setFont(new StiFont("Arial", 10.0));
        StiStateIndicator stateIndicator = new StiStateIndicator();
        stateIndicator.setLeft(0.02f);
        stateIndicator.setTop(0.07f);
        stateIndicator.setRelativeWidth(0.083f);
        stateIndicator.setRelativeHeight(0.5);
        StiStateIndicatorFilter indicatorFilter1 = new StiStateIndicatorFilter();
        indicatorFilter1.setStartValue(0.0);
        indicatorFilter1.setEndValue(40.0);
        indicatorFilter1.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)112, (int)156, (int)28)));
        StiStateIndicatorFilter indicatorFilter2 = new StiStateIndicatorFilter();
        indicatorFilter2.setStartValue(40.0);
        indicatorFilter2.setEndValue(65.0);
        indicatorFilter2.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)225, (int)174, (int)25)));
        StiStateIndicatorFilter indicatorFilter3 = new StiStateIndicatorFilter();
        indicatorFilter3.setStartValue(65.0);
        indicatorFilter3.setEndValue(100.0);
        indicatorFilter3.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)194, (int)45, (int)48)));
        stateIndicator.getFilters().add(indicatorFilter1);
        stateIndicator.getFilters().add(indicatorFilter2);
        stateIndicator.getFilters().add(indicatorFilter3);
        linearScale.getItems().add(linearBar);
        linearScale.getItems().add(tickMarkMajor);
        linearScale.getItems().add(tickMarkMinor);
        linearScale.getItems().add(tickLabelMajor);
        linearScale.getItems().add(stateIndicator);
        gauge.getScales().add(linearScale);
        StiGaugeHelper.initializeName(gauge, report);
    }

    public static void verticalThermometer(StiGauge gauge, StiReport report) {
        StiGaugeHelper.initializeGauge(gauge, 50.0, 300.0);
        StiLinearScale linearScale = new StiLinearScale();
        linearScale.setOrientation(StiOrientation.Vertical);
        linearScale.setRelativeHeight(0.85f);
        linearScale.setStartWidth(0.17f);
        linearScale.setEndWidth(0.17f);
        linearScale.setMaximum(80.0);
        linearScale.setMajorInterval(20.0);
        linearScale.setMinorInterval(4.0);
        StiLinearBar linearBar = new StiLinearBar();
        linearBar.setSkin(StiLinearBarSkin.VerticalThermometer);
        linearBar.setPlacement(StiPlacement.Outside);
        linearBar.setStartWidth(0.2f);
        linearBar.setEndWidth(0.2f);
        linearBar.setUseRangeColor(true);
        StiLinearIndicatorRangeInfo indicatorRange1 = new StiLinearIndicatorRangeInfo();
        indicatorRange1.setValue(0.0);
        indicatorRange1.setBrush((StiBrush)new StiGradientBrush(StiColor.fromArgb((int)137, (int)188, (int)41), StiColor.fromArgb((int)111, (int)163, (int)14), 0.0));
        StiLinearIndicatorRangeInfo indicatorRange2 = new StiLinearIndicatorRangeInfo();
        indicatorRange2.setValue(40.0);
        indicatorRange2.setBrush((StiBrush)new StiGradientBrush(StiColor.fromArgb((int)217, (int)173, (int)45), StiColor.fromArgb((int)222, (int)166, (int)0), 0.0));
        StiLinearIndicatorRangeInfo indicatorRange3 = new StiLinearIndicatorRangeInfo();
        indicatorRange3.setValue(65.0);
        indicatorRange3.setBrush((StiBrush)new StiGradientBrush(StiColor.fromArgb((int)208, (int)49, (int)52), StiColor.fromArgb((int)186, (int)6, (int)10), 0.0));
        linearBar.getRangeList().add(indicatorRange1);
        linearBar.getRangeList().add(indicatorRange2);
        linearBar.getRangeList().add(indicatorRange3);
        StiLinearTickMarkMajor tickMarkMajor = new StiLinearTickMarkMajor();
        tickMarkMajor.setPlacement(StiPlacement.Overlay);
        tickMarkMajor.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)159, (int)159, (int)159)));
        tickMarkMajor.setRelativeWidth(0.18f);
        tickMarkMajor.setRelativeHeight(0.01f);
        tickMarkMajor.setOffset(-0.1f);
        StiLinearTickMarkMinor tickMarkMinor = new StiLinearTickMarkMinor();
        tickMarkMinor.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)159, (int)159, (int)159)));
        tickMarkMinor.setRelativeWidth(0.1f);
        tickMarkMinor.setRelativeHeight(0.005f);
        tickMarkMinor.setOffset(-0.14f);
        StiLinearTickLabelMajor tickLabelMajor = new StiLinearTickLabelMajor();
        tickLabelMajor.setPlacement(StiPlacement.Inside);
        tickLabelMajor.setOffset(0.07f);
        tickLabelMajor.setTextBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)83, (int)85, (int)86)));
        tickLabelMajor.setFont(new StiFont("Arial", 10.0));
        StiStateIndicator stateIndicator = new StiStateIndicator();
        stateIndicator.setLeft(0.05f);
        stateIndicator.setTop(0.9f);
        stateIndicator.setRelativeWidth(0.5);
        stateIndicator.setRelativeHeight(0.083f);
        StiStateIndicatorFilter indicatorFilter1 = new StiStateIndicatorFilter();
        indicatorFilter1.setStartValue(0.0);
        indicatorFilter1.setEndValue(40.0);
        indicatorFilter1.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)112, (int)156, (int)28)));
        StiStateIndicatorFilter indicatorFilter2 = new StiStateIndicatorFilter();
        indicatorFilter2.setStartValue(40.0);
        indicatorFilter2.setEndValue(65.0);
        indicatorFilter2.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)225, (int)174, (int)25)));
        StiStateIndicatorFilter indicatorFilter3 = new StiStateIndicatorFilter();
        indicatorFilter3.setStartValue(65.0);
        indicatorFilter3.setEndValue(100.0);
        indicatorFilter3.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)194, (int)45, (int)48)));
        stateIndicator.getFilters().add(indicatorFilter1);
        stateIndicator.getFilters().add(indicatorFilter2);
        stateIndicator.getFilters().add(indicatorFilter3);
        linearScale.getItems().add(linearBar);
        linearScale.getItems().add(tickMarkMajor);
        linearScale.getItems().add(tickMarkMinor);
        linearScale.getItems().add(tickLabelMajor);
        linearScale.getItems().add(stateIndicator);
        gauge.getScales().add(linearScale);
        StiGaugeHelper.initializeName(gauge, report);
    }

    public static void lightSpeedometer(StiGauge gauge, StiReport report) {
        StiGaugeHelper.initializeGauge(gauge, 350.0, 350.0);
        StiRadialScale radialScale1 = new StiRadialScale();
        radialScale1.setSkin(StiRadialScaleSkin.Empty);
        radialScale1.setRadius(0.65f);
        radialScale1.setStartAngle(115.0);
        radialScale1.setSweepAngle(310.0);
        radialScale1.setStartWidth(0.03f);
        radialScale1.setEndWidth(0.03f);
        radialScale1.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)81, (int)84, (int)101)));
        radialScale1.setMajorInterval(10.0);
        radialScale1.setMinorInterval(2.0);
        radialScale1.setMaximum(100.0);
        StiRadialRangeList radialRangeList1 = new StiRadialRangeList();
        StiRadialRange radialRange1 = new StiRadialRange();
        radialRange1.setStartValue(40.0);
        radialRange1.setEndValue(101.2f);
        radialRange1.setStartWidth(0.04f);
        radialRange1.setEndWidth(0.04f);
        radialRange1.setPlacement(StiPlacement.Inside);
        radialRange1.setUseValuesFromTheSpecifiedRange(false);
        radialRange1.setBrush((StiBrush)new StiGradientBrush(StiColor.fromArgb((int)213, (int)227, (int)118), StiColor.fromArgb((int)118, (int)71, (int)24), 90.0));
        radialRange1.setBorderBrush((StiBrush)new StiSolidBrush(StiColorEnum.White.color()));
        radialRangeList1.getRanges().add(radialRange1);
        StiRadialTickMarkMajor radialTickMarkMajor1 = new StiRadialTickMarkMajor();
        radialTickMarkMajor1.setSkipValues(new StiSkipValuesExpression("100"));
        radialTickMarkMajor1.setRelativeHeight(0.03f);
        radialTickMarkMajor1.setRelativeWidth(0.055f);
        radialTickMarkMajor1.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)81, (int)84, (int)101)));
        StiRadialTickMarkMinor radialTickMarkMinor1 = new StiRadialTickMarkMinor();
        radialTickMarkMinor1.setOffset(0.04f);
        radialTickMarkMinor1.setRelativeHeight(0.01f);
        radialTickMarkMinor1.setRelativeWidth(0.03f);
        radialTickMarkMinor1.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)81, (int)84, (int)101)));
        StiRadialTickMarkCustom radialTickMarkCustom1 = new StiRadialTickMarkCustom();
        radialTickMarkCustom1.setValueObj(100.0);
        radialTickMarkCustom1.setOffset(-0.057f);
        radialTickMarkCustom1.setRelativeWidth(0.08f);
        radialTickMarkCustom1.setRelativeHeight(0.03f);
        radialTickMarkCustom1.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)81, (int)84, (int)101)));
        StiRadialTickLabelMajor radialTickLabelMajor1 = new StiRadialTickLabelMajor();
        radialTickLabelMajor1.setLabelRotationMode(StiLabelRotationMode.None);
        radialTickLabelMajor1.setOffset(0.14f);
        radialTickLabelMajor1.setTextBrush((StiBrush)new StiSolidBrush(StiColorEnum.Black.color()));
        radialTickLabelMajor1.setFont(new StiFont("Arial", 13.0, StiFontStyle.Bold));
        StiNeedle needle1 = new StiNeedle();
        needle1.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)250, (int)250, (int)250)));
        needle1.setBorderBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)163, (int)163, (int)163)));
        needle1.setBorderWidth(1.0);
        needle1.setPlacement(StiPlacement.Outside);
        needle1.setRelativeWidth(0.63f);
        needle1.setRelativeHeight(0.14f);
        needle1.setSkin(StiNeedleSkin.SpeedometerNeedle);
        radialScale1.getItems().add(radialRangeList1);
        radialScale1.getItems().add(radialTickMarkMajor1);
        radialScale1.getItems().add(radialTickMarkMinor1);
        radialScale1.getItems().add(radialTickMarkCustom1);
        radialScale1.getItems().add(radialTickLabelMajor1);
        radialScale1.getItems().add(needle1);
        gauge.getScales().add(radialScale1);
        StiGaugeHelper.initializeName(gauge, report);
    }

    public static void darkSpeedometer(StiGauge gauge, StiReport report) {
        StiGaugeHelper.initializeGauge(gauge, 350.0, 350.0);
        StiRadialScale radialScale1 = new StiRadialScale();
        radialScale1.setSkin(StiRadialScaleSkin.Empty);
        radialScale1.setRadius(0.65f);
        radialScale1.setStartAngle(115.0);
        radialScale1.setSweepAngle(310.0);
        radialScale1.setStartWidth(0.03f);
        radialScale1.setEndWidth(0.03f);
        radialScale1.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)81, (int)84, (int)101)));
        radialScale1.setMajorInterval(10.0);
        radialScale1.setMinorInterval(2.0);
        radialScale1.setMaximum(200.0);
        StiRadialRangeList radialRangeList1 = new StiRadialRangeList();
        StiRadialRange radialRange1 = new StiRadialRange();
        radialRange1.setStartValue(0.0);
        radialRange1.setEndValue(60.0);
        radialRange1.setBorderWidth(1.0);
        radialRange1.setStartWidth(0.06f);
        radialRange1.setEndWidth(0.06f);
        radialRange1.setPlacement(StiPlacement.Overlay);
        radialRange1.setBrush((StiBrush)new StiGradientBrush(StiColor.fromArgb((int)101, (int)134, (int)101), StiColor.fromArgb((int)66, (int)228, (int)66), 90.0));
        StiRadialRange radialRange2 = new StiRadialRange();
        radialRange2.setStartValue(60.0);
        radialRange2.setEndValue(100.0);
        radialRange2.setBorderWidth(1.0);
        radialRange2.setStartWidth(0.06f);
        radialRange2.setEndWidth(0.06f);
        radialRange2.setPlacement(StiPlacement.Overlay);
        radialRange2.setBrush((StiBrush)new StiGradientBrush(StiColor.fromArgb((int)255, (int)255, (int)0), StiColor.fromArgb((int)143, (int)174, (int)126), 90.0));
        StiRadialRange radialRange3 = new StiRadialRange();
        radialRange3.setStartValue(100.0);
        radialRange3.setEndValue(140.0);
        radialRange3.setBorderWidth(1.0);
        radialRange3.setStartWidth(0.06f);
        radialRange3.setEndWidth(0.06f);
        radialRange3.setPlacement(StiPlacement.Overlay);
        radialRange3.setBrush((StiBrush)new StiGradientBrush(StiColor.fromArgb((int)255, (int)255, (int)0), StiColor.fromArgb((int)156, (int)156, (int)124), 90.0));
        StiRadialRange radialRange4 = new StiRadialRange();
        radialRange4.setStartValue(140.0);
        radialRange4.setEndValue(200.0);
        radialRange4.setBorderWidth(1.0);
        radialRange4.setStartWidth(0.06f);
        radialRange4.setEndWidth(0.06f);
        radialRange4.setPlacement(StiPlacement.Overlay);
        radialRange4.setBrush((StiBrush)new StiGradientBrush(StiColor.fromArgb((int)125, (int)86, (int)80), StiColor.fromArgb((int)208, (int)45, (int)44), 90.0));
        radialRangeList1.getRanges().add(radialRange1);
        radialRangeList1.getRanges().add(radialRange2);
        radialRangeList1.getRanges().add(radialRange3);
        radialRangeList1.getRanges().add(radialRange4);
        StiRadialTickMarkMajor radialTickMarkMajor1 = new StiRadialTickMarkMajor();
        radialTickMarkMajor1.setPlacement(StiPlacement.Overlay);
        radialTickMarkMajor1.setOffset(0.04f);
        radialTickMarkMajor1.setOffsetAngle(-2.0);
        radialTickMarkMajor1.setRelativeWidth(0.1f);
        radialTickMarkMajor1.setRelativeHeight(0.035f);
        radialTickMarkMajor1.setSkin(StiTickMarkSkin.TriangleLeft);
        StiRadialTickMarkMinor radialTickMarkMinor1 = new StiRadialTickMarkMinor();
        radialTickMarkMinor1.setPlacement(StiPlacement.Overlay);
        radialTickMarkMinor1.setSkipMajorValues(false);
        radialTickMarkMinor1.setRelativeWidth(0.04f);
        radialTickMarkMinor1.setRelativeHeight(0.018f);
        radialTickMarkMinor1.setSkin(StiTickMarkSkin.Rectangle);
        radialTickMarkMinor1.setSkipIndices(new StiSkipIndicesExpression("0;4;8;12;16;20;24;28;32;36;40"));
        StiRadialTickLabelMajor radialTickLabelMajor1 = new StiRadialTickLabelMajor();
        radialTickLabelMajor1.setLabelRotationMode(StiLabelRotationMode.None);
        radialTickLabelMajor1.setOffset(0.05f);
        radialTickLabelMajor1.setFont(new StiFont("Arial", 11.0));
        StiRadialTickMarkCustom radialTickMarkCustom1 = new StiRadialTickMarkCustom();
        radialTickMarkCustom1.setPlacement(StiPlacement.Inside);
        radialTickMarkCustom1.setOffset(0.3f);
        radialTickMarkCustom1.setRelativeHeight(0.05f);
        radialTickMarkCustom1.setRelativeWidth(0.05f);
        radialTickMarkCustom1.setSkin(StiTickMarkSkin.Ellipse);
        StiRadialTickMarkCustomValue custom1 = new StiRadialTickMarkCustomValue(20.0);
        custom1.setBrush((StiBrush)new StiGradientBrush(StiColor.fromArgb((int)68, (int)223, (int)68), StiColor.fromArgb((int)0, (int)153, (int)0), 90.0));
        StiRadialTickMarkCustomValue custom2 = new StiRadialTickMarkCustomValue(97.0);
        custom2.setBrush((StiBrush)new StiGradientBrush(StiColor.fromArgb((int)255, (int)255, (int)0), StiColor.fromArgb((int)186, (int)169, (int)2), 90.0));
        StiRadialTickMarkCustomValue custom3 = new StiRadialTickMarkCustomValue(173.0);
        custom3.setBrush((StiBrush)new StiGradientBrush(StiColor.fromArgb((int)184, (int)29, (int)29), StiColor.fromArgb((int)121, (int)30, (int)30), 90.0));
        radialTickMarkCustom1.getValues().add(custom1);
        radialTickMarkCustom1.getValues().add(custom2);
        radialTickMarkCustom1.getValues().add(custom3);
        StiRadialTickLabelCustom radialTickLabelCustom1 = new StiRadialTickLabelCustom();
        radialTickLabelCustom1.setPlacement(StiPlacement.Inside);
        radialTickLabelCustom1.setLabelRotationMode(StiLabelRotationMode.None);
        radialTickLabelCustom1.setFont(new StiFont("Arial", 10.0));
        radialTickLabelCustom1.getValues().add(new StiRadialTickLabelCustomValue(17.0, "Safe", 0.16f));
        radialTickLabelCustom1.getValues().add(new StiRadialTickLabelCustomValue(102.0, "Caution", 0.25));
        radialTickLabelCustom1.getValues().add(new StiRadialTickLabelCustomValue(181.0, "Danger", 0.06f));
        StiNeedle needle1 = new StiNeedle();
        needle1.setBorderBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)153, (int)9, (int)8)));
        needle1.setBrush((StiBrush)new StiGradientBrush(StiColor.fromArgb((int)255, (int)198, (int)172), StiColor.fromArgb((int)197, (int)25, (int)19), 90.0));
        needle1.setBorderWidth(1.0);
        needle1.setPlacement(StiPlacement.Outside);
        needle1.setRelativeWidth(0.57f);
        needle1.setRelativeHeight(0.17f);
        needle1.setSkin(StiNeedleSkin.SpeedometerNeedle2);
        radialScale1.getItems().add(radialRangeList1);
        radialScale1.getItems().add(radialTickMarkMajor1);
        radialScale1.getItems().add(radialTickMarkMinor1);
        radialScale1.getItems().add(radialTickLabelMajor1);
        radialScale1.getItems().add(radialTickMarkCustom1);
        radialScale1.getItems().add(radialTickLabelCustom1);
        radialScale1.getItems().add(needle1);
        gauge.getScales().add(radialScale1);
        StiGaugeHelper.initializeName(gauge, report);
    }
}

