/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.collections;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.infographics.gauge.StiGauge;
import com.stimulsoft.report.infographics.gauge.primitives.scales.StiScaleBase;
import java.util.ArrayList;
import java.util.Collection;

public class StiScaleCollection
extends ArrayList<StiScaleBase>
implements Cloneable,
IStiJsonReportObject {
    private static final long serialVersionUID = 7172823297687821700L;
    private StiGauge parent = null;

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        if (this.size() == 0) {
            return null;
        }
        JSONObject jObject = new JSONObject();
        Integer index = 0;
        for (StiScaleBase component : this) {
            jObject.AddPropertyJObject(index.toString(), component.SaveToJsonObject(mode));
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            JSONObject propJObject = (JSONObject)property.Value;
            String ident = "";
            for (Object pr : propJObject.Properties()) {
                if (!"Ident".equals(((JProperty)pr).Name)) continue;
                ident = ((JProperty)pr).Value.toString();
            }
            StiScaleBase scale = null;
            for (StiScaleBase sc : StiOptions.Services.getGaugeScales()) {
                String name = sc.getClass().getName();
                if (!name.substring(name.lastIndexOf(46) + 1).equals(ident)) continue;
                scale = sc;
            }
            if (scale == null) {
                throw new RuntimeException(String.format("Type %s is not found!", ident));
            }
            StiScaleBase scaleClone = scale.createNew();
            scaleClone.setGauge(scale.gauge);
            this.add(scaleClone);
            scaleClone.LoadFromJsonObject((JSONObject)property.Value);
        }
    }

    public void setParent(StiGauge parent) {
        this.parent = parent;
    }

    @Override
    public Object clone() {
        StiScaleCollection clone = new StiScaleCollection(this.parent);
        for (StiScaleBase scale : this) {
            clone.add((StiScaleBase)scale.clone());
        }
        return clone;
    }

    public boolean isReadOnly() {
        return false;
    }

    private void setParent(StiScaleBase element) {
        element.gauge = this.parent;
    }

    private void clearParent(StiScaleBase element) {
        element.gauge = null;
    }

    @Override
    public boolean add(StiScaleBase element) {
        boolean result = super.add(element);
        this.setParent(element);
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends StiScaleBase> elements) {
        boolean result = super.addAll(elements);
        for (StiScaleBase stiScaleBase : elements) {
            this.setParent(stiScaleBase);
        }
        return result;
    }

    @Override
    public void add(int index, StiScaleBase element) {
        super.add(index, element);
        this.setParent(element);
    }

    public boolean remove(StiScaleBase element) {
        boolean result = super.remove(element);
        if (result) {
            this.clearParent(element);
        }
        return result;
    }

    public boolean moveUp(StiScaleBase element) {
        int index = this.indexOf(element);
        if (index > 0) {
            this.remove(index);
            this.add(--index, element);
            return true;
        }
        return false;
    }

    public boolean moveDown(StiScaleBase element) {
        int index = this.indexOf(element);
        if (index != -1 && this.size() > 1 && index < this.size() - 1) {
            this.remove(index);
            this.add(++index, element);
            return true;
        }
        return false;
    }

    public StiScaleCollection(StiGauge parent) {
        this.parent = parent;
    }

    public StiScaleCollection() {
    }
}

