/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.helpers;

import com.stimulsoft.base.IStiAppExpressionCollection;
import com.stimulsoft.base.StiAppExpression;
import com.stimulsoft.base.StiAppExpressionHelper;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.helper.StiValueHelper;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReportParser;
import com.stimulsoft.report.components.StiComponent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class StiAppExpressionParser {
    public static void processExpressions(StiComponent component, boolean allowDataLoading, StiEventType eventType) {
        StiComponent appExpessions;
        if (component == null) {
            return;
        }
        StiComponent stiComponent = appExpessions = component instanceof IStiAppExpressionCollection ? component : null;
        if (appExpessions != null && appExpessions.getExpressions() == null) {
            return;
        }
        Class<?> componentClass = component.getClass();
        for (StiAppExpression expression : appExpessions.getExpressions()) {
            if (expression.isEmpty()) continue;
            try {
                Enum<?> value;
                Field field = StiAppExpressionParser.getField(componentClass, expression.getName().substring(0, 1).toLowerCase() + expression.getName().substring(1));
                if (field != null) {
                    Enum<?> value2;
                    field.setAccessible(true);
                    if (field.getType() == Boolean.class || field.getType() == Boolean.TYPE) {
                        field.set(component, StiAppExpressionParser.parseBoolExpression(component, expression.getName(), allowDataLoading));
                    }
                    if (field.getType() == String.class) {
                        field.set(component, StiAppExpressionParser.parseStringExpression(component, expression.getName(), allowDataLoading));
                    }
                    if (field.getType() == StiColor.class) {
                        field.set(component, StiAppExpressionParser.parseColorExpression(component, expression.getName(), allowDataLoading));
                    }
                    if (field.getType() == StiBrush.class) {
                        field.set(component, StiAppExpressionParser.parseBrushExpression(component, expression.getName(), allowDataLoading));
                    }
                    if (!field.getType().isEnum() || (value2 = StiAppExpressionParser.parseEnumExpression(component, expression.getName(), field.getType(), allowDataLoading)) == null) continue;
                    field.set(component, value2);
                    continue;
                }
                Method method = StiAppExpressionParser.getMethod(componentClass, "set" + expression.getName());
                if (method == null) continue;
                Class<?> parameterType = method.getParameterTypes()[0];
                if (parameterType == Boolean.class || parameterType == Boolean.TYPE) {
                    method.invoke((Object)component, StiAppExpressionParser.parseBoolExpression(component, expression.getName(), allowDataLoading));
                }
                if (parameterType == String.class) {
                    method.invoke((Object)component, StiAppExpressionParser.parseStringExpression(component, expression.getName(), allowDataLoading));
                }
                if (parameterType == StiColor.class) {
                    method.invoke((Object)component, StiAppExpressionParser.parseColorExpression(component, expression.getName(), allowDataLoading));
                }
                if (parameterType == StiBrush.class) {
                    method.invoke((Object)component, StiAppExpressionParser.parseBrushExpression(component, expression.getName(), allowDataLoading));
                }
                if (!parameterType.isEnum() || (value = StiAppExpressionParser.parseEnumExpression(component, expression.getName(), parameterType, allowDataLoading)) == null) continue;
                method.invoke((Object)component, value);
            }
            catch (Exception exception) {}
        }
    }

    public static Method getMethod(Class<?> type, String methodName) {
        for (Method method : type.getMethods()) {
            if (!method.getName().equals(methodName) || method.getParameterTypes().length != 1) continue;
            return method;
        }
        return null;
    }

    public static Field getField(Class<?> type, String fieldName) {
        try {
            return type.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            if (type.getSuperclass() != null) {
                return StiAppExpressionParser.getField(type.getSuperclass(), fieldName);
            }
            return null;
        }
    }

    public static boolean parseBoolExpression(StiComponent component, String propName, boolean allowDataLoading) {
        Object value = StiAppExpressionParser.parseExpression(component, StiAppExpressionHelper.getExpression((Object)component, (String)propName), allowDataLoading);
        return StiValueHelper.tryToBool((Object)value);
    }

    public static Enum<?> parseEnumExpression(StiComponent component, String propName, Class<?> enumType, boolean allowDataLoading) {
        Object value = StiAppExpressionParser.parseExpression(component, StiAppExpressionHelper.getExpression((Object)component, (String)propName), allowDataLoading);
        try {
            return Enum.valueOf(enumType, value.toString().trim());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String parseStringExpression(StiComponent component, String propName, boolean allowDataLoading) {
        Object value = StiAppExpressionParser.parseExpression(component, StiAppExpressionHelper.getExpression((Object)component, (String)propName), allowDataLoading);
        return value != null ? value.toString() : "";
    }

    public static StiColor parseColorExpression(StiComponent component, String propName, boolean allowDataLoading) {
        Object value = StiAppExpressionParser.parseExpression(component, StiAppExpressionHelper.getExpression((Object)component, (String)propName), allowDataLoading);
        if (value instanceof StiColor) {
            return (StiColor)value;
        }
        String strValue = value != null ? value.toString() : null;
        return StiValidationUtil.isNullOrWhiteSpace((String)strValue) ? StiColorEnum.Transparent.color() : StiColor.get((String)strValue);
    }

    public static StiBrush parseBrushExpression(StiComponent component, String propName, boolean allowDataLoading) {
        Object value = StiAppExpressionParser.parseExpression(component, StiAppExpressionHelper.getExpression((Object)component, (String)propName), allowDataLoading);
        if (value instanceof StiColor) {
            return new StiSolidBrush((StiColor)value);
        }
        if (value instanceof StiBrush) {
            return (StiBrush)value;
        }
        String strValue = value != null ? value.toString() : null;
        return new StiSolidBrush(StiValidationUtil.isNullOrWhiteSpace((String)strValue) ? StiColorEnum.Transparent.color() : StiColor.get((String)strValue));
    }

    private static Object parseExpression(StiComponent component, StiAppExpression expression, boolean allowDataLoading) {
        if (expression == null || StiValidationUtil.isNullOrWhiteSpace((String)expression.getExpression())) {
            return null;
        }
        return StiReportParser.parseObject(expression.getExpression(), component, false, null, allowDataLoading, true);
    }

    public static enum StiEventType {
        BeginRender,
        BeforePrint;

    }
}

