/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.tools.html;

import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiImageCache;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.export.service.StiHtmlExportService;
import com.stimulsoft.report.export.tools.StiImageFormat;
import java.awt.image.BufferedImage;
import java.io.File;

public class StiHtmlImageHost {
    protected StiHtmlExportService htmlExport = null;
    private StiImageCache imageCache = null;
    boolean isMhtExport = false;
    boolean forcePng = false;

    public StiHtmlImageHost(StiHtmlExportService htmlExport) {
        this.htmlExport = htmlExport;
        this.isMhtExport = false;
        this.forcePng = false;
    }

    public String getImageString(BufferedImage bmp) {
        StiImageFormat imageFormat = this.forcePng ? StiImageFormat.Png : this.htmlExport.getImageFormat();
        int imageCount = this.imageCache.getImageStoreSize();
        int imageNumber = this.imageCache.addImageInt(bmp, imageFormat);
        float imageQuality = this.htmlExport.getImageQuality();
        String baseDir = null;
        if (this.htmlExport.isFileStreamMode()) {
            File dir = new File(this.htmlExport.getFileName());
            if (!dir.exists() && !dir.mkdirs()) {
                this.htmlExport.setFileStreamMode(false);
            } else {
                baseDir = dir.getParent();
            }
        }
        if (this.htmlExport.isFileStreamMode()) {
            if (StiValidationUtil.isNotNullOrEmpty(baseDir) && baseDir.charAt(baseDir.length() - 1) != File.separatorChar) {
                baseDir = baseDir + File.separatorChar;
            }
            String fileName = new File(this.htmlExport.getFileName()).getName();
            String fileNameWithoutExtension = fileName.substring(0, fileName.lastIndexOf(46));
            String dir = fileNameWithoutExtension + ".files" + File.separatorChar;
            File dirFile = new File(baseDir + dir);
            if (!dirFile.exists()) {
                dirFile.mkdir();
            }
            String imageStr = fileNameWithoutExtension + (imageNumber + 1) + "." + (this.forcePng ? "png" : this.htmlExport.getImageFormat().name().toLowerCase());
            if (imageNumber >= imageCount) {
                StiImageHelper.saveWithDPI(bmp, new File(baseDir + dir + imageStr), imageFormat, 72, imageQuality);
            }
            return dir + imageStr;
        }
        String result = String.format("data:image/%s;base64,%s", imageFormat.name().toLowerCase(), StiImageHelper.imageToBase64(bmp, imageFormat));
        result = result.replaceAll("\\n", "");
        return result;
    }

    public StiHtmlExportService getHtmlExport() {
        return this.htmlExport;
    }

    public void setHtmlExport(StiHtmlExportService htmlExport) {
        this.htmlExport = htmlExport;
    }

    public StiImageCache getImageCache() {
        return this.imageCache;
    }

    public void setImageCache(StiImageCache imageCache) {
        this.imageCache = imageCache;
    }

    public boolean isMhtExport() {
        return this.isMhtExport;
    }

    public void setMhtExport(boolean isMhtExport) {
        this.isMhtExport = isMhtExport;
    }

    public boolean isForcePng() {
        return this.forcePng;
    }

    public void setForcePng(boolean forcePng) {
        this.forcePng = forcePng;
    }
}

