/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.tools;

import com.stimulsoft.base.StiAttribute;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.simplecomponents.StiCheckBox;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.components.simplecomponents.StiRichText;
import com.stimulsoft.report.components.simplecomponents.StiShape;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.components.simplecomponents.StiTextInCells;
import com.stimulsoft.report.components.simplecomponents.StiZipCode;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.report.options.ExportOptions;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.zip.Adler32;
import java.util.zip.DeflaterOutputStream;

public class StiExportUtils {
    public static int[] codesymbols = new int[]{32, 34, 39, 42, 44, 59, 60, 62, 91, 94, 96, 123, 124, 125};
    public static String wrongUrlSymbols = new String(codesymbols, 0, codesymbols.length);
    public static String AdditionalData = "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";
    private static String[] positivePatterns = new String[]{"$n", "n$", "$ n", "n $"};
    private static String[] negativePatterns = new String[]{"($n)", "-$n", "$-n", "$n-", "(n$)", "-n$", "n-$", "n$-", "-n $", "-$ n", "n $-", "$ n-", "$ -n", "n- $", "($ n)", "(n $)"};

    public static String getReportVersion() {
        return StiAttribute.getVersion();
    }

    public static ArrayList<String> splitString(String inputString, Boolean removeControl) {
        ArrayList<String> stringList = new ArrayList<String>();
        String st = "";
        for (int i = 0; i < inputString.length(); ++i) {
            char ch = inputString.charAt(i);
            if (ch == '\n') {
                stringList.add(StiExportUtils.trimEndWhiteSpace(st, removeControl));
                st = "";
                continue;
            }
            if (removeControl.booleanValue() && Character.isISOControl(ch) && ch != '\t') continue;
            st = st + ch;
        }
        if (!"".equals(st)) {
            stringList.add(StiExportUtils.trimEndWhiteSpace(st, removeControl));
        }
        if (stringList.size() == 0) {
            stringList.add(st);
        }
        return stringList;
    }

    public static String trimEndWhiteSpace(String inputString) {
        return StiExportUtils.trimEndWhiteSpace(inputString, true);
    }

    public static String trimEndWhiteSpace(String inputString, Boolean removeControl) {
        int index;
        if (StiOptions.Engine.getMeasureTrailingSpaces() || !ExportOptions.Txt.getTrimTrailingSpaces()) {
            return inputString;
        }
        String outputString = "";
        for (index = inputString.length(); index > 0 && Character.isWhitespace(inputString.charAt(index - 1)) && (removeControl.booleanValue() || inputString.charAt(index - 1) >= ' '); --index) {
        }
        if (index == inputString.length()) {
            outputString = inputString;
        } else if (index > 0) {
            outputString = inputString.substring(0, index);
        }
        return outputString;
    }

    public static String stringToUrl(String input) throws UnsupportedEncodingException {
        byte[] buf = input.getBytes("UTF8");
        StringBuilder output = new StringBuilder();
        for (byte byt : buf) {
            if (byt < 32 || byt > 127 || wrongUrlSymbols.indexOf((char)byt) != -1) {
                output.append(String.format("%%%02x", byt));
                continue;
            }
            output.append((char)byt);
        }
        return output.toString();
    }

    public static ByteArrayOutputStream makePdfDeflateStream(byte[] data) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflateStream = new DeflaterOutputStream(outputStream);
        deflateStream.write(data);
        deflateStream.close();
        return outputStream;
    }

    public static long getAdler32Checksum(byte[] array) {
        Adler32 checksum = new Adler32();
        checksum.update(array, 0, array.length);
        return checksum.getValue();
    }

    public static String saveComponentToString(StiComponent component) {
        return StiExportUtils.saveComponentToString(component, StiImageFormat.Png, 0.75f, 100.0f);
    }

    public static String saveComponentToString(StiComponent component, StiImageFormat imageFormat, float imageQuality, float imageResolution) {
        BufferedImage image = null;
        double zoom = imageResolution / 100.0f;
        if (component instanceof StiTextInCells) {
            image = ((StiTextInCells)component).getImage(zoom, StiExportFormat.ImagePng);
        } else if (component instanceof StiRichText) {
            StiRichText richText = (StiRichText)component.clone();
            richText.setBorder(new StiBorder());
            image = richText.getImage(zoom, StiExportFormat.ImagePng);
        } else if (component instanceof StiText) {
            StiText text = (StiText)component.clone();
            text.setBorder(new StiBorder());
            image = text.getImage(zoom, StiExportFormat.Pdf);
        } else if (component instanceof StiImage) {
            image = ((StiImage)component).getImage(zoom, StiExportFormat.ImagePng);
        } else if (component instanceof StiBarCode) {
            StiBarCode barcode = (StiBarCode)component.clone();
            barcode.setBorder(new StiBorder());
            image = barcode.getImage(zoom, StiExportFormat.ImagePng);
        } else if (component instanceof StiShape) {
            image = ((StiShape)component).getImage(zoom, StiExportFormat.ImagePng);
        } else if (component instanceof StiCheckBox) {
            StiCheckBox checkBox = (StiCheckBox)component.clone();
            checkBox.setBorder(new StiBorder());
            image = checkBox.getImage(zoom, StiExportFormat.ImagePng);
        } else if (component instanceof StiZipCode) {
            StiZipCode zipCode = (StiZipCode)component.clone();
            zipCode.setBorder(new StiBorder());
            image = zipCode.getImage(zoom, StiExportFormat.ImagePng);
        } else if (component instanceof StiChart) {
            StiChart chart = (StiChart)component.clone();
            chart.setBorder(new StiBorder());
            image = chart.getImage(zoom, StiExportFormat.ImagePng);
        }
        if (image == null) {
            return "";
        }
        return StiImageHelper.imageToBase64(image, imageFormat);
    }

    public static String getPositivePattern(int patternIndex) {
        return positivePatterns[patternIndex];
    }

    public static String getNegativePattern(int patternIndex) {
        return negativePatterns[patternIndex];
    }
}

