/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.tools;

import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.interfaces.IStiExportImage;
import com.stimulsoft.report.components.interfaces.IStiExportImageExtended;
import com.stimulsoft.report.components.interfaces.IStiTextOptions;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.tools.StiCellStyle;

public class StiCell
implements Cloneable {
    private IStiExportImage exportImage = null;
    private StiCellStyle cellStyle;
    private int left = 0;
    private int top = 0;
    private int width = 0;
    private int height = 0;
    private String text = "";
    private StiExportFormat exportFormat = StiExportFormat.None;
    private StiComponent component;

    public StiCell() {
        this(StiExportFormat.None);
    }

    public StiCell(StiExportFormat exportFormat) {
        this.exportFormat = exportFormat;
    }

    public StiCell clone() {
        StiCell result = new StiCell(this.exportFormat);
        result.setCellStyle(this.cellStyle != null ? this.cellStyle.clone() : null);
        result.setComponent(this.component);
        result.setExportImage(this.exportImage);
        result.setHeight(this.height);
        result.setLeft(this.left);
        result.setText(this.text);
        result.setTop(this.top);
        result.setWidth(this.width);
        return result;
    }

    private boolean forceExportAsImage(Object exportImage) {
        return exportImage instanceof IStiTextOptions && ((IStiTextOptions)exportImage).getTextOptions().getAngle() != 0.0f;
    }

    public void setComponent(StiComponent value) {
        this.component = value;
        if (this.component instanceof IStiExportImageExtended) {
            this.exportImage = (IStiExportImage)((Object)value);
            if (!((IStiExportImageExtended)this.exportImage).isExportAsImage(this.exportFormat) && !this.forceExportAsImage(value)) {
                this.exportImage = null;
            }
        }
    }

    public IStiExportImage getExportImage() {
        return this.exportImage;
    }

    public void setExportImage(IStiExportImage exportImage) {
        this.exportImage = exportImage;
    }

    public StiCellStyle getCellStyle() {
        return this.cellStyle;
    }

    public void setCellStyle(StiCellStyle cellStyle) {
        this.cellStyle = cellStyle;
    }

    public int getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = Math.max(height, 0);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public StiExportFormat getExportFormat() {
        return this.exportFormat;
    }

    public void setExportFormat(StiExportFormat exportFormat) {
        this.exportFormat = exportFormat;
    }

    public StiComponent getComponent() {
        return this.component;
    }
}

