/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.tools;

import java.math.BigInteger;
import java.nio.ByteBuffer;

public class BitConverter {
    public static short ToUInt16(int[] value, int startIndex) {
        return (short)(value[startIndex] << 8 | value[startIndex + 1]);
    }

    public static int ToUInt32(int[] value, int startIndex) {
        return value[startIndex] << 24 | value[startIndex + 1] << 16 | value[startIndex + 2] << 8 | value[startIndex + 3];
    }

    public static byte[] getBytes(int pos, long valueDouble) {
        long value = Double.doubleToRawLongBits(valueDouble);
        byte[] bfData = new byte[8];
        bfData[pos + 0] = (byte)(value & 0xFFL);
        bfData[pos + 1] = (byte)(value >> 8 & 0xFFL);
        bfData[pos + 2] = (byte)(value >> 16 & 0xFFL);
        bfData[pos + 3] = (byte)(value >> 24 & 0xFFL);
        bfData[pos + 4] = (byte)(value >> 32 & 0xFFL);
        bfData[pos + 5] = (byte)(value >> 40 & 0xFFL);
        bfData[pos + 6] = (byte)(value >> 48 & 0xFFL);
        bfData[pos + 7] = (byte)(value >> 56 & 0xFFL);
        return bfData;
    }

    public static byte[] inverse(byte[] arr) {
        for (int i = 0; i < arr.length / 2; ++i) {
            byte temp = arr[i];
            arr[i] = arr[arr.length - i - 1];
            arr[arr.length - i - 1] = temp;
        }
        return arr;
    }

    public static byte[] getBytes(int value) {
        return BitConverter.inverse(ByteBuffer.allocate(4).putInt(value).array());
    }

    public static byte[] getBytes(short value) {
        return BitConverter.inverse(ByteBuffer.allocate(2).putShort(value).array());
    }

    public static byte[] getBytes(BigInteger val) {
        int size;
        byte[] r1 = val.toByteArray();
        for (size = r1.length; r1[r1.length - size] == 0 && size > 1; --size) {
        }
        byte[] result = new byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = r1[r1.length - i - 1];
        }
        return result;
    }
}

