/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.service;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.licenses.StiLicenseKeyValidator;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiPagesCollection;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.service.StiExportService;
import com.stimulsoft.report.export.settings.StiDataExportSettings;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.tools.StiDataExportMode;
import com.stimulsoft.report.export.tools.StiMatrix;
import com.stimulsoft.report.export.tools.StiPagesRange;
import com.stimulsoft.report.options.ExportOptions;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;

public class StiCsvExportService
extends StiExportService {
    @Override
    public void export(StiReport report, OutputStream outputStream, StiExportSettings exportSettings) throws StiException {
        this.exportCsv(report, outputStream, (StiDataExportSettings)exportSettings);
    }

    public void exportCsv(StiReport report, OutputStream outputStream, StiDataExportSettings settings) throws StiException {
        try {
            report.invokeExporting(settings.getExportFormat());
            this.exportCsvException(report, outputStream, settings);
            report.invokeExported(settings.getExportFormat());
        }
        catch (Exception e) {
            throw new StiException((Throwable)e);
        }
    }

    private void exportCsvException(StiReport report, OutputStream outputStream, StiDataExportSettings settings) throws IOException {
        StiLicenseKeyValidator.isValidOnJavaFramework(null);
        StiPagesRange pageRange = settings.getPageRange();
        String separator = settings.getSeparator();
        Charset encoding = settings.getEncoding();
        boolean skipColumnHeaders = settings.isSkipColumnHeaders();
        StiDataExportMode mode = settings.getDataExportMode();
        if ("\\t".equals(separator)) {
            separator = "\t";
        }
        if (ExportOptions.Csv.getForcedSeparator() != null && ExportOptions.Csv.getForcedSeparator().trim().length() > 0) {
            separator = ExportOptions.Csv.getForcedSeparator().trim();
        }
        StiPagesCollection pages = pageRange.getSelectedPages(report.getRenderedPages());
        StiMatrix matrix = new StiMatrix(pages, false, this);
        matrix.scanComponentsPlacement(false);
        if (this.isStoped()) {
            return;
        }
        matrix.prepareDocument(this, mode);
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, encoding);
        this.setStatusString(StiLocalization.getValue((String)"Export", (String)"ExportingCreatingDocument"));
        if (!skipColumnHeaders) {
            for (int columnIndex = 0; columnIndex < matrix.getFields().length; ++columnIndex) {
                String text = matrix.getFields()[columnIndex].Name.replaceAll("\"", "\"\"");
                if (text.indexOf(separator) != -1) {
                    text = "\"" + text + "\"";
                }
                writer.write(text);
                if (columnIndex >= matrix.getFields().length - 1) continue;
                writer.write(separator);
            }
            writer.write("\r\n");
        }
        for (int rowIndex = 0; rowIndex < matrix.DataArrayLength; ++rowIndex) {
            this.invokeExporting(rowIndex, matrix.DataArrayLength - 1);
            if (this.isStoped()) {
                return;
            }
            for (int columnIndex = 0; columnIndex < matrix.getFields().length; ++columnIndex) {
                String text = matrix.getFields()[columnIndex].DataArray[rowIndex];
                if (text == null) {
                    text = "";
                }
                if (!"".equals(text)) {
                    if (text.indexOf(separator) != -1 || text.indexOf(34) != -1 || text.indexOf(10) != -1) {
                        text = text.replaceAll("\"", "\"\"");
                        text = "\"" + text + "\"";
                    }
                    writer.write(text);
                }
                if (columnIndex >= matrix.getFields().length - 1) continue;
                writer.write(separator);
            }
            writer.write("\r\n");
        }
        ((Writer)writer).flush();
        ((Writer)writer).close();
        if (matrix != null) {
            matrix.clear();
            matrix = null;
        }
        this.closeProgress();
    }

    @Override
    public StiExportFormat getExportFormat() {
        return StiExportFormat.Csv;
    }

    @Override
    public boolean getMultipleFiles() {
        return false;
    }
}

