/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export;

import com.stimulsoft.base.json.JSONArray;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.report.export.StiExportSettingsHelper;
import com.stimulsoft.report.export.settings.StiExportSettings;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;

public class StiExportSettingsList
extends ArrayList<StiExportSettings> {
    private static final long serialVersionUID = 3566523960942027939L;

    public String saveToString() {
        try {
            JSONArray array = new JSONArray();
            for (StiExportSettings settings : this) {
                Map<String, Object> seralized = StiExportSettingsHelper.serialise(settings);
                array.put((Object)new JSONObject(seralized));
            }
            return array.toString(2);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void saveToFile(String file) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            StiIOUtil.write((String)this.saveToString(), (OutputStream)fos);
        }
    }

    public void loadFromString(String str) {
        this.clear();
        try {
            JSONArray json = new JSONArray(str);
            for (int i = 0; i < json.length(); ++i) {
                this.add(StiExportSettingsHelper.deserialise(json.getJSONObject(i)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadFromFile(String file) throws FileNotFoundException, IOException {
        String str = StiIOUtil.toString((InputStream)new FileInputStream(file));
        this.loadFromString(str);
    }

    public <T extends StiExportSettings> T findExportSettings(Class<T> clazz) {
        for (StiExportSettings settings : this) {
            if (!settings.getClass().equals(clazz)) continue;
            return (T)settings;
        }
        return null;
    }
}

