/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export;

import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.settings.StiDataExportSettings;
import com.stimulsoft.report.export.settings.StiExcelExportSettings;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.settings.StiHtmlExportSettings;
import com.stimulsoft.report.export.settings.StiImageExportSettings;
import com.stimulsoft.report.export.settings.StiOdsExportSettings;
import com.stimulsoft.report.export.settings.StiOdtExportSettings;
import com.stimulsoft.report.export.settings.StiPdfExportSettings;
import com.stimulsoft.report.export.settings.StiPowerPointExportSettings;
import com.stimulsoft.report.export.settings.StiRtfExportSettings;
import com.stimulsoft.report.export.settings.StiTxtExportSettings;
import com.stimulsoft.report.export.settings.StiWordExportSettings;
import com.stimulsoft.report.export.settings.StiXpsExportSettings;

public class StiExportSettingsCreator {
    public static StiExportSettings New(String identName) {
        if (StiValidationUtil.isNullOrEmpty((String)identName)) {
            return null;
        }
        StiExportFormat ident = StiExportFormat.valueOf(identName);
        StiExportSettings settings = StiExportSettingsCreator.New(ident);
        settings.setOpenAfterExport(true);
        return settings;
    }

    public static StiExportSettings New(StiExportFormat ident) {
        switch (ident) {
            case Pdf: {
                return new StiPdfExportSettings();
            }
            case Xps: {
                return new StiXpsExportSettings();
            }
            case PowerPoint: {
                return new StiPowerPointExportSettings();
            }
            case Html: 
            case Html5: 
            case HtmlDiv: 
            case HtmlSpan: 
            case HtmlTable: {
                return new StiHtmlExportSettings();
            }
            case Excel: 
            case ExcelXml: 
            case ExcelBiff: {
                return new StiExcelExportSettings();
            }
            case Ods: {
                return new StiOdsExportSettings();
            }
            case Text: {
                return new StiTxtExportSettings();
            }
            case Rtf: {
                return new StiRtfExportSettings();
            }
            case Word: {
                return new StiWordExportSettings();
            }
            case Odt: {
                return new StiOdtExportSettings();
            }
            case Data: 
            case Csv: 
            case Dbf: 
            case Dif: 
            case Json: 
            case Sylk: 
            case Xml: {
                return new StiDataExportSettings();
            }
            case Image: 
            case ImageGif: 
            case ImageJpeg: 
            case ImageSvg: 
            case ImageSvgz: 
            case ImageBmp: 
            case ImagePcx: 
            case ImagePng: 
            case ImageTiff: 
            case ImageEmf: {
                return new StiImageExportSettings();
            }
        }
        throw new IllegalArgumentException();
    }
}

