/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.operations;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Stack;

public abstract class StiOperation {
    private static final String[] ERRORS_LIST = new String[]{"Syntax error", "", "The expression is empty", "Division by zero", "Unexpected end of expression", "The name ''{0}'' does not exist in the current context", "Syntax error - unprocessed lexemes remain", "( expected", ") expected", "Field, method, or property is not found: '%s'", "Operator ''{0}'' cannot be applied to operands of type ''%s'' and type ''%s''", "The function is not found: ''%s''", "No overload for method ''{0}'' takes ''{1}'' arguments", "The ''{0}'' function has invalid argument ''{1}'': cannot convert from ''{2}'' to ''{3}''", "The ''{0}'' function is not yet implemented", "The ''{0}'' method has invalid argument ''{1}'': cannot convert from ''{2}'' to ''{3}''", "''{0}'' does not contain a definition for ''{1}''"};
    private final Stack<?> stack;

    public StiOperation(Stack<?> stack) {
        this.stack = stack;
    }

    public abstract Object doOperation();

    protected int get_category(Object par) {
        if (par == null) {
            return -1;
        }
        Class<?> type = par.getClass();
        int category = 0;
        if (type == String.class || type == Character.class) {
            category = 1;
        } else if (type == BigDecimal.class) {
            category = 2;
        } else if (type == Double.class || type == Float.class) {
            category = 3;
        } else if (type == Long.class) {
            category = 4;
        } else if (type == Long.class) {
            category = 5;
        } else if (type == Integer.class || type == Short.class || type == Byte.class) {
            category = 6;
        } else if (type == Integer.class || type == Short.class || type == Byte.class) {
            category = 7;
        } else if (type == Date.class) {
            category = 8;
        } else if (type == Boolean.class) {
            category = 9;
        }
        return category;
    }

    public Stack<?> getStack() {
        return this.stack;
    }

    protected void ThrowError(int code) {
        this.ThrowError(code, "", "", "", "");
    }

    protected void ThrowError(int code, String message1) {
        this.ThrowError(code, message1, "", "", "");
    }

    protected void ThrowError(int code, String message1, String message2) {
        this.ThrowError(code, message1, message2, "", "");
    }

    protected void ThrowError(int code, String message1, String message2, String message3) {
        this.ThrowError(code, message1, message2, message3, "");
    }

    protected void ThrowError(int code, String message1, String message2, String message3, String message4) {
        String errorMessage = "Parser error: Unknown error";
        if (code < ERRORS_LIST.length) {
            errorMessage = "Parser error: " + String.format("%s, %s, %s, %s, %s ", ERRORS_LIST[code], message1, message2, message3, message4);
        }
        throw new RuntimeException(errorMessage);
    }
}

