/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.engineV2.builders;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.drawing.enums.StiStringTrimming;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.StiReportParser;
import com.stimulsoft.report.components.StiBookmark;
import com.stimulsoft.report.components.StiBookmarksCollection;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiMargins;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.bands.StiTableOfContents;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.complexcomponents.StiPanel;
import com.stimulsoft.report.components.enums.StiTextQuality;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.engine.engineV2.StiNewPageContainer;
import com.stimulsoft.report.engine.engineV2.builders.StiDataBandV2Builder;
import com.stimulsoft.report.styles.StiBaseStyle;
import com.stimulsoft.report.styles.StiStyle;
import java.util.List;

public class StiTableOfContentsV2Builder
extends StiDataBandV2Builder {
    private static String dotsString;

    @Override
    public StiComponent InternalRender(StiComponent masterComp) {
        StiComponent renderedContainer;
        StiTableOfContents masterTable = (StiTableOfContents)masterComp;
        if (masterTable.getNewPageBefore()) {
            masterTable.getReport().getEngine().NewPage();
        }
        StiComponent stiComponent = renderedContainer = masterTable.getIsFirstInReport() ? StiTableOfContentsV2Builder.renderPanelWithBookmarks(masterTable) : StiTableOfContentsV2Builder.renderTextWithNoInformation(masterTable);
        if (masterTable.getNewPageAfter()) {
            ((StiContainer)renderedContainer).getComponents().add(new StiNewPageContainer());
        }
        return renderedContainer;
    }

    private static StiComponent renderTextWithNoInformation(StiComponent comp) {
        StiTableOfContents masterTable = (StiTableOfContents)comp;
        StiPanel panel = new StiPanel();
        panel.setCanGrow(false);
        panel.setCanShrink(false);
        panel.setCanBreak(false);
        panel.setGrowToHeight(false);
        panel.setClientRectangle(masterTable.getClientRectangle());
        panel.setName(masterTable.getName());
        panel.setPage(masterTable.getPage());
        panel.setBorder((StiBorder)masterTable.getBorder().clone());
        panel.setBrush((StiBrush)masterTable.getBrush().clone());
        panel.setRightToLeft(masterTable.getRightToLeft());
        StiText text = new StiText();
        text.setClientRectangle(new StiRectangle(0.0, 0.0, panel.width, panel.getHeight()));
        text.setName(masterTable.getName());
        text.setPage(masterTable.page);
        text.setPrintable(masterTable.getPrintable());
        text.setHorAlignment(StiTextHorAlignment.Center);
        text.setVertAlignment(StiVertAlignment.Center);
        text.setRightToLeft(masterTable.getRightToLeft());
        text.text.setValue(StiLocalization.Get((String)"Errors", (String)"OneTableOfContentsAllowed"));
        panel.getComponents().add(text);
        return panel;
    }

    private static StiComponent renderPanelWithBookmarks(StiComponent comp) {
        StiTableOfContents masterComp = (StiTableOfContents)comp;
        StiPanel resultComp = new StiPanel();
        resultComp.setCanGrow(true);
        resultComp.setCanShrink(true);
        resultComp.setCanBreak(true);
        resultComp.setGrowToHeight(masterComp.getGrowToHeight());
        resultComp.setClientRectangle(masterComp.getClientRectangle());
        resultComp.setTagValue(masterComp);
        resultComp.setName(masterComp.getName());
        resultComp.setPage(masterComp.page);
        resultComp.setBorder((StiBorder)masterComp.getBorder().clone());
        resultComp.setBrush((StiBrush)masterComp.brush.clone());
        if (comp.getReport().getIsSecondPass()) {
            StiRefObject posX = new StiRefObject((Object)0.0);
            StiRefObject posY = new StiRefObject((Object)masterComp.page.getUnit().ConvertFromHInches(masterComp.getMargins().getTop()));
            StiTableOfContentsV2Builder.renderPointers(1, "TOC", masterComp, resultComp, StiTableOfContentsV2Builder.getPointers(masterComp, comp), (StiRefObject<Double>)posX, (StiRefObject<Double>)posY);
        }
        if (resultComp.getComponents().size() > 0) {
            double height = 0.0;
            for (StiComponent comp2 : resultComp.getComponents()) {
                height = Math.max(height, comp2.getBottom());
            }
            resultComp.setHeight(Math.max(resultComp.getHeight(), height) + masterComp.page.getUnit().ConvertFromHInches(masterComp.getMargins().getBottom()));
        }
        return resultComp;
    }

    private static void renderPointers(int level, String baseName, StiTableOfContents masterComp, StiPanel resultComp, StiBookmarksCollection bookmarks, StiRefObject<Double> posX, StiRefObject<Double> posY) {
        if (bookmarks == null) {
            return;
        }
        StiBaseStyle style = StiTableOfContentsV2Builder.getStyle(level, masterComp);
        int index = 1;
        for (StiBookmark bookmark : bookmarks) {
            StiText textIndex = null;
            String hyperlink = StiTableOfContentsV2Builder.getHyperlink(bookmark);
            if (!(bookmark.getParentComponent() instanceof StiReport)) {
                textIndex = new StiText();
                textIndex.setBrush(null);
                textIndex.setWordWrap(false);
                textIndex.setTop((Double)posY.argvalue);
                textIndex.setWidth(StiTableOfContentsV2Builder.fullSize(resultComp));
                textIndex.setHeight(StiTableOfContentsV2Builder.fullSize(resultComp));
                textIndex.setPage(resultComp.page);
                textIndex.setPrintable(masterComp.getPrintable());
                textIndex.setName(resultComp.getName() + "_Index_" + baseName + "_" + index);
                textIndex.setVertAlignment(StiVertAlignment.Center);
                textIndex.setTextQuality(StiTextQuality.Wysiwyg);
                textIndex.setTagValue((Object)bookmark);
                textIndex.setHyperlinkValue(hyperlink);
                textIndex.setRightToLeft(masterComp.getRightToLeft());
                textIndex.setMargins(new StiMargins(0.0, masterComp.getMargins().getRight(), 0.0, 0.0));
                if (style != null) {
                    style.SetStyleToComponent(textIndex);
                }
                textIndex.setHorAlignment(StiTextHorAlignment.Right);
                textIndex.setLeft(masterComp.getRightToLeft() ? 0.0 : resultComp.width - StiTableOfContentsV2Builder.fullSize(resultComp));
                textIndex.NewGuid();
                StiTableOfContentsV2Builder.setOffSides(masterComp.getRightToLeft(), true, false, textIndex);
                resultComp.getComponents().add(textIndex);
            }
            StiText textName = new StiText();
            textName.setBrush(null);
            textName.setWordWrap(false);
            textName.setTop((Double)posY.argvalue);
            textName.setHeight(StiTableOfContentsV2Builder.fullSize(resultComp));
            textName.setName(resultComp.getName() + "_Name_" + baseName + "_" + index);
            textName.setVertAlignment(StiVertAlignment.Center);
            textName.setPage(resultComp.page);
            textName.setPrintable(masterComp.getPrintable());
            textName.setTextQuality(StiTextQuality.Wysiwyg);
            textName.setRightToLeft(masterComp.getRightToLeft());
            textName.setMargins(new StiMargins(masterComp.getMargins().getLeft(), 0.0, 0.0, 0.0));
            if (textIndex != null) {
                textName.setHyperlinkValue(hyperlink);
                textName.setGuid(textIndex.getGuid());
            }
            textName.text.setValue(bookmark.text);
            if (textIndex != null) {
                textName.setLeft(masterComp.getRightToLeft() ? textIndex.width : (Double)posX.argvalue);
                textName.setWidth(masterComp.getRightToLeft() ? resultComp.width - textIndex.getRight() - (Double)posX.argvalue : textIndex.getLeft() - textName.getLeft());
                textName.text.setValue(textName.text.getValue() + StiTableOfContentsV2Builder.getDotsString());
            } else {
                textName.width = resultComp.width;
            }
            textName.getTextOptions().setTrimming(StiStringTrimming.None);
            if (style != null) {
                style.SetStyleToComponent(textName);
            }
            float lineSpacing = style instanceof StiStyle ? ((StiStyle)style).getLineSpacing() : 1.0f;
            textName.setHorAlignment(StiTextHorAlignment.Left);
            textName.setHeight(masterComp.getReport().getUnit().ConvertFromHInches(textName.font.getHeight() * (double)lineSpacing));
            if (textIndex != null) {
                StiTableOfContentsV2Builder.setOffSides(masterComp.getRightToLeft(), false, true, textName);
            }
            resultComp.getComponents().add(0, textName);
            if (textIndex != null) {
                textIndex.setHeight(textName.getHeight());
            }
            StiRefObject<Double> stiRefObject = posY;
            Double.valueOf((Double)stiRefObject.argvalue + textName.getHeight());
            stiRefObject.argvalue = stiRefObject.argvalue;
            if (bookmark.getBookmarks().size() > 0) {
                double resPosX = (Double)posX.argvalue;
                StiRefObject<Double> stiRefObject2 = posX;
                Double.valueOf((Double)stiRefObject2.argvalue + StiTableOfContentsV2Builder.indent(masterComp));
                stiRefObject2.argvalue = stiRefObject2.argvalue;
                StiTableOfContentsV2Builder.renderPointers(level + 1, baseName + "_" + index, masterComp, resultComp, bookmark.getBookmarks(), posX, posY);
                posX.argvalue = resPosX;
            }
            ++index;
        }
    }

    public static void postProcessTableOfContents(StiReport report) {
        boolean found = false;
        for (Object comp : report.GetComponents()) {
            if (!(comp instanceof StiTableOfContents) || !((StiTableOfContents)comp).getEnabled()) continue;
            found = true;
        }
        if (!found) {
            return;
        }
        StiComponentsCollection comps = new StiComponentsCollection();
        for (Object page : report.getRenderedPages()) {
            comps.add((StiComponent)page);
            comps.addAll(((StiContainer)page).GetComponents());
        }
        StiContainer masterComp = null;
        for (Object page : report.getPages()) {
            for (StiComponent comp : ((StiContainer)page).getComponents()) {
                if (!(comp instanceof StiTableOfContents) || masterComp != null) continue;
                masterComp = (StiTableOfContents)comp;
            }
        }
        StiComponent resultComp = null;
        if (masterComp != null) {
            for (StiComponent comp : comps) {
                if (!comp.getName().equals(masterComp.getName())) continue;
                resultComp = comp;
            }
        }
        if (resultComp != null) {
            StiTableOfContentsV2Builder.postProcessBookmarks(comps, masterComp, resultComp);
        }
        StiComponentsCollection comps2 = new StiComponentsCollection();
        for (StiComponent comp : comps) {
            if (comp.getTagValue() == null || !(comp.getTagValue() instanceof StiBookmark)) continue;
            comps2.add(comp);
        }
        for (StiComponent comp : comps2) {
            StiText textIndex;
            StiBookmark bookmark = (StiBookmark)((Object)comp.getTagValue());
            StiComponent targetComp = null;
            if (!StiValidationUtil.isNullOrWhiteSpace((String)bookmark.getComponentGuid())) {
                for (StiComponent comp2 : comps) {
                    if (!StiValidationUtil.equals((Object)comp2.getGuid(), (Object)bookmark.getComponentGuid())) continue;
                    targetComp = comp2;
                }
            }
            StiText stiText = textIndex = comp instanceof StiText ? (StiText)comp : null;
            if (targetComp != null) {
                textIndex.text.setValue(String.valueOf(report.getEngine().getPageNumbers().GetPageNumber(targetComp.page)));
            }
            textIndex.setAutoWidth(true);
            double prevRight = textIndex.getRight();
            textIndex.setWidth(textIndex.getActualSize().getWidth());
            if (!((StiDataBand)masterComp).getRightToLeft()) {
                textIndex.setLeft(prevRight - textIndex.getWidth());
            }
            textIndex.setAutoWidth(false);
            StiComponent textName = null;
            for (StiComponent c : comps) {
                if (textName != null || !StiValidationUtil.equals((Object)c.getGuid(), (Object)textIndex.getGuid()) || c == textIndex) continue;
                textName = c;
            }
            if (textName == null) continue;
            if (((StiDataBand)masterComp).getRightToLeft()) {
                textName.setWidth(textName.getRight() - textIndex.getRight());
                textName.setLeft(textIndex.getRight());
                continue;
            }
            textName.setWidth(textIndex.getLeft() - textName.getLeft());
        }
    }

    public static void postProcessBookmarks(List<StiComponent> comps, StiTableOfContents masterComp, StiComponent resultComp) {
        StiTableOfContentsV2Builder.postProcessBookmarks(comps, "TOC", resultComp, StiTableOfContentsV2Builder.getPointersForPostProcessing(masterComp, resultComp));
    }

    private static StiBookmarksCollection getPointers(StiTableOfContents masterComp, StiComponent comp) {
        StiBookmark pointer = comp.getReport().getEngine().firstPassPointer;
        if (StiValidationUtil.isNullOrWhiteSpace((String)masterComp.getReportPointer())) {
            return pointer != null ? pointer.getBookmarks() : null;
        }
        pointer.setText(StiReportParser.parse(masterComp.getReportPointer(), masterComp, true, null, true, false));
        pointer.setParentComponent(masterComp.getReport());
        StiBookmarksCollection result = new StiBookmarksCollection();
        result.add(pointer);
        return result;
    }

    private static StiBookmarksCollection getPointersForPostProcessing(StiTableOfContents masterComp, StiComponent resultComp) {
        if (StiValidationUtil.isNullOrWhiteSpace((String)masterComp.getReportPointer())) {
            return resultComp.getReport().getPointer().getBookmarks();
        }
        StiBookmarksCollection result = new StiBookmarksCollection();
        result.add(resultComp.getReport().getPointer());
        return result;
    }

    public static void postProcessBookmarks(List<StiComponent> comps, String baseName, StiComponent panel, StiBookmarksCollection bookmarks) {
        int index = 1;
        for (StiBookmark bookmark : bookmarks) {
            String strIndex = panel.getName() + "_Index_" + baseName + "_" + index;
            String strName = panel.getName() + "_Name_" + baseName + "_" + index;
            StiComponent textIndex = null;
            for (StiComponent c : comps) {
                if (textIndex != null || !StiValidationUtil.equals((Object)c.getName(), (Object)strIndex)) continue;
                textIndex = c;
            }
            if (textIndex != null) {
                textIndex.setTagValue((Object)bookmark);
                textIndex.setHyperlinkValue(StiTableOfContentsV2Builder.getHyperlink(bookmark));
            }
            StiComponent textName = null;
            for (StiComponent c : comps) {
                if (textName != null || !StiValidationUtil.equals((Object)c.getName(), (Object)strName)) continue;
                textName = c;
            }
            if (textName != null) {
                textName.setHyperlinkValue(StiTableOfContentsV2Builder.getHyperlink(bookmark));
            }
            if (bookmark.getBookmarks().size() > 0) {
                StiTableOfContentsV2Builder.postProcessBookmarks(comps, baseName + "_" + index, panel, bookmark.getBookmarks());
            }
            ++index;
        }
    }

    private static String getHyperlink(StiBookmark bookmark) {
        return "###" + bookmark.text + "#GUID#" + bookmark.getComponentGuid();
    }

    private static void setOffSides(boolean isRightToLeft, boolean setLeftOff, boolean setRightOff, StiText text) {
        if (isRightToLeft) {
            if (setLeftOff) {
                StiTableOfContentsV2Builder.setOffSide(text, StiBorderSides.Right);
            }
            if (setRightOff) {
                StiTableOfContentsV2Builder.setOffSide(text, StiBorderSides.Left);
            }
        } else {
            if (setLeftOff) {
                StiTableOfContentsV2Builder.setOffSide(text, StiBorderSides.Left);
            }
            if (setRightOff) {
                StiTableOfContentsV2Builder.setOffSide(text, StiBorderSides.Right);
            }
        }
    }

    private static void setOffSide(StiText text, StiBorderSides side) {
        if (text.getBorder().side.contains((IStiEnum)side)) {
            text.getBorder().side.remove((IStiEnum)side);
        }
    }

    private static StiBaseStyle getStyle(int level, StiTableOfContents masterComp) {
        List<StiStyle> styles = masterComp.getStylesList();
        if (level >= 1 && level <= styles.size()) {
            return styles.get(level - 1);
        }
        if (styles.size() > 0) {
            return styles.get(styles.size() - 1);
        }
        return null;
    }

    private static double fullSize(StiComponent comp) {
        return comp.getReport().getUnit().ConvertFromHInches(20.0);
    }

    private static double indent(StiTableOfContents table) {
        return table.getReport().getUnit().ConvertFromHInches(table.getIndent());
    }

    private static String getDotsString() {
        if (dotsString == null) {
            dotsString = StiStringUtil.createCopies((char)'.', (int)300);
        }
        return dotsString;
    }
}

