/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.engineV2.builders;

import com.stimulsoft.base.crypto.Crc32;
import com.stimulsoft.lib.base64.StiBase64DecoderUtil;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.dictionary.StiResource;
import com.stimulsoft.report.dictionary.enums.StiResourceType;
import com.stimulsoft.report.engine.engineV2.builders.StiViewV2Builder;
import com.stimulsoft.report.helpers.StiHyperlinkProcessor;

public class StiImageV2Builder
extends StiViewV2Builder {
    @Override
    public StiComponent InternalRender(StiComponent masterComp) {
        StiImage masterImage = (StiImage)(masterComp instanceof StiImage ? masterComp : null);
        StiComponent tempVar = super.InternalRender(masterImage);
        StiImage image = (StiImage)(tempVar instanceof StiImage ? tempVar : null);
        return image;
    }

    @Override
    public StiComponent Render(StiComponent masterComp) {
        StiImage imageComp = (StiImage)super.Render(masterComp);
        if (imageComp != null && masterComp.getReport().isStoreImagesInResources()) {
            StiResource resource = StiHyperlinkProcessor.getResourceByHyperlink(masterComp.getReport(), (String)imageComp.getImageURLValue());
            if (resource != null) {
                resource.setStorable(true);
            } else if (imageComp.existImageToDraw()) {
                byte[] imageBytes = imageComp.getImageBytesToDraw().getBytes();
                String resourceName = "image_" + Crc32.calculate((byte[])imageBytes);
                resource = StiHyperlinkProcessor.getResource(masterComp.getReport(), resourceName);
                if (resource == null) {
                    resource = new StiResource(resourceName, StiResourceType.Image, StiBase64DecoderUtil.decode((byte[])imageBytes));
                    resource.setStorable(true);
                    imageComp.getReport().getDictionary().getResources().add(resource);
                }
                imageComp.setImageURLValue("resource://" + resourceName);
            }
        }
        return imageComp;
    }
}

