/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.engineV2.builders;

import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiCrossHeaderInteraction;
import com.stimulsoft.report.components.StiFilterHelper;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.enums.StiDockStyle;
import com.stimulsoft.report.components.interfaces.IStiBreakable;
import com.stimulsoft.report.crossTab.StiCrossColumn;
import com.stimulsoft.report.crossTab.StiCrossHeader;
import com.stimulsoft.report.crossTab.StiCrossRow;
import com.stimulsoft.report.crossTab.StiCrossSummary;
import com.stimulsoft.report.crossTab.StiCrossTab;
import com.stimulsoft.report.crossTab.StiCrossTabHelper;
import com.stimulsoft.report.crossTab.StiCrossTabParams;
import com.stimulsoft.report.crossTab.core.StiCross;
import com.stimulsoft.report.crossTab.core.enums.StiSummaryDirection;
import com.stimulsoft.report.crossTab.enums.StiCrossHorAlignment;
import com.stimulsoft.report.engine.engineV2.StiEngine;
import com.stimulsoft.report.engine.engineV2.StiSubReportsHelper;
import com.stimulsoft.report.engine.engineV2.builders.StiContainerV2Builder;
import java.util.HashMap;

public class StiCrossTabV2Builder
extends StiContainerV2Builder {
    public static String getCollapsingName(StiCrossHeader header) {
        return StiCrossTabV2Builder.getCollapsingName(header.getName(), header.getHeaderLevel(), header.getHeaderValue());
    }

    public static String getCollapsingName(String componentName, int level, String value) {
        return String.format("%s.%s.%s", componentName, level, value);
    }

    public static boolean isCollapsed(StiCrossHeader masterHeader) {
        return StiCrossTabV2Builder.isCollapsed(masterHeader, masterHeader.getHeaderLevel(), masterHeader.getHeaderValue());
    }

    public static boolean isCollapsed(StiCrossHeader masterHeader, int level, Object textValue) {
        if (StiOptions.Engine.forceDisableCollapsing) {
            return false;
        }
        if (masterHeader.getInteraction() == null || masterHeader.getInteraction() instanceof StiCrossHeaderInteraction && !((StiCrossHeaderInteraction)masterHeader.getInteraction()).getCollapsingEnabled()) {
            return false;
        }
        boolean isCollapsed = true;
        if (masterHeader.getReport().getInteractionCollapsingStates() == null) {
            return isCollapsed;
        }
        Object value = masterHeader.getReport().getInteractionCollapsingStates().get(StiCrossTabV2Builder.getCollapsingName(masterHeader.getName(), level, textValue != null ? textValue.toString() : ""));
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return true;
    }

    public static void setCollapsed(StiCrossHeader masterHeader, boolean isCollapsed) {
        if (StiOptions.Engine.forceDisableCollapsing) {
            return;
        }
        if (masterHeader.getInteraction() == null || masterHeader.getInteraction() instanceof StiCrossHeaderInteraction && !((StiCrossHeaderInteraction)masterHeader.getInteraction()).getCollapsingEnabled()) {
            return;
        }
        if (masterHeader.getReport().getInteractionCollapsingStates() == null) {
            masterHeader.getReport().setInteractionCollapsingStates(new HashMap<String, Object>());
        }
        masterHeader.getReport().getInteractionCollapsingStates().put(StiCrossTabV2Builder.getCollapsingName(masterHeader), isCollapsed);
    }

    public static void MakeHorAlignment(StiCrossTab masterCrossTab, StiContainer outContainer, int startIndex, double parentWidth) {
        if (masterCrossTab.getWrap()) {
            return;
        }
        if (masterCrossTab.getHorAlignment() == StiCrossHorAlignment.Width) {
            outContainer.setLeft(0.0);
            outContainer.setWidth(parentWidth);
            StiCrossTabHelper.MakeHorAlignmentByWidth(outContainer, startIndex);
        } else if (masterCrossTab.getHorAlignment() != StiCrossHorAlignment.None) {
            outContainer.setLeft(0.0);
            outContainer.setWidth(parentWidth);
            StiRefObject maxLeft = new StiRefObject((Object)0.0);
            StiRefObject maxRight = new StiRefObject((Object)0.0);
            StiCrossTabHelper.CalculateMaxAndMin(outContainer, (StiRefObject<Double>)maxLeft, (StiRefObject<Double>)maxRight, startIndex);
            for (int index = startIndex; index < outContainer.components.size(); ++index) {
                StiComponent comp = (StiComponent)outContainer.components.get(index);
                if (masterCrossTab.getHorAlignment() == StiCrossHorAlignment.Left) {
                    comp.setLeft(comp.getLeft() - (Double)maxLeft.argvalue);
                    continue;
                }
                if (masterCrossTab.getHorAlignment() == StiCrossHorAlignment.Right) {
                    comp.setLeft(comp.getLeft() + (outContainer.getWidth() - (Double)maxRight.argvalue));
                    continue;
                }
                if (masterCrossTab.getHorAlignment() != StiCrossHorAlignment.Center) continue;
                double newLeft = (outContainer.getWidth() - ((Double)maxRight.argvalue - (Double)maxLeft.argvalue)) / 2.0;
                comp.setLeft(comp.getLeft() - ((Double)maxLeft.argvalue - newLeft));
            }
        }
    }

    public StiComponent renderCrossTabOnDataBand(StiCrossTabParams pars, StiCrossTab master, StiContainer destination, StiRectangle rect) {
        StiPage page = master.getPage();
        StiCross cross = master.getCrossTabInfo().Cross;
        StiEngine engine = master.getReport().getEngine();
        double onePageWidth = page.getPageWidth() - page.getMargins().getLeft() - page.getMargins().getRight();
        double segmentWidth = page.getUnlimitedBreakable() ? onePageWidth : 100000.0;
        int startIndex = destination.getComponents().size();
        pars.startRow = 0;
        boolean skip = false;
        boolean wrapFinished = true;
        double posY = 0.0;
        double previousSegmentHeight = 0.0;
        while (pars.startRow < cross.getRowCount()) {
            double segmentHeight;
            pars.startColumn = wrapFinished ? 0 : pars.startColumn;
            boolean needKeepTogether = master.keepCrossTabTogether && master.getParent() != null && !master.getParent().getCanBreak();
            double d = segmentHeight = pars.startRow == 0 && !skip && !needKeepTogether ? engine.getFreeSpace() - master.top : engine.getStaticBands().getReservedFreeSpace();
            if (page.getUnlimitedHeight() && !page.getUnlimitedBreakable()) {
                segmentHeight = 1.0E8;
            }
            if (segmentHeight < 0.0) {
                segmentHeight = engine.getStaticBands().getReservedFreeSpace();
            }
            if (pars.startRow == 0 || !wrapFinished) {
                StiRectangle rectMeasure = rect.clone();
                StiRefObject stiRefObject = new StiRefObject((Object)rectMeasure);
                if (this.renderColHeaders(pars, master, destination, (StiRefObject<StiRectangle>)stiRefObject, true, true) > segmentHeight) {
                    if (!skip) {
                        previousSegmentHeight = segmentHeight;
                        posY += segmentHeight;
                        skip = true;
                        continue;
                    }
                    posY -= previousSegmentHeight;
                    segmentHeight = previousSegmentHeight;
                } else if (master.getParent() != null && master.getParent() instanceof IStiBreakable && !master.getParent().getCanBreak()) {
                    posY -= previousSegmentHeight;
                }
            }
            double posX = pars.ShiftX;
            StiRefObject endRow = new StiRefObject((Object)0);
            boolean firstPage = true;
            while (pars.startColumn < cross.getColCount()) {
                StiRectangle rectSegment = new StiRectangle(posX, posY, segmentWidth - destination.getLeft() - (firstPage ? pars.ShiftX : 0.0), segmentHeight);
                StiRefObject endCol = new StiRefObject((Object)0);
                this.renderCrossTabSegment(pars, master, destination, rectSegment, (StiRefObject<Integer>)endCol, (StiRefObject<Integer>)endRow);
                pars.startColumn = (Integer)endCol.argvalue;
                if (master.getWrap()) {
                    wrapFinished = pars.startColumn >= cross.getColCount();
                    break;
                }
                if (firstPage) {
                    posX -= pars.ShiftX;
                }
                posX += segmentWidth;
                firstPage = false;
            }
            if (wrapFinished) {
                posY += segmentHeight;
                pars.startRow = (Integer)endRow.argvalue;
            }
            if (destination.getComponents().size() > 0) {
                for (StiComponent component : destination.getComponents()) {
                    posY = Math.max(posY, component.getBottom());
                }
            }
            if (wrapFinished) continue;
            posY += master.getWrapGap();
        }
        if (destination.getComponents().size() > 0 && !master.getWrap() && master.getHorAlignment() != StiCrossHorAlignment.Width) {
            double segmentPerWidth = 0.0;
            for (StiComponent c : destination.getComponents()) {
                segmentPerWidth = Math.max(segmentPerWidth, c.getRight());
            }
            if ((segmentPerWidth /= onePageWidth) > 1.0) {
                while (segmentPerWidth > (double)destination.getContainerInfoV2().SetSegmentPerWidth) {
                    ++destination.getContainerInfoV2().SetSegmentPerWidth;
                }
            }
        }
        StiCrossTabV2Builder.makeHorAlignment(master, destination, startIndex, master.parent.width, destination.getContainerInfoV2().SetSegmentPerWidth);
        StiCrossTabV2Builder.finalizeCross(destination);
        return destination;
    }

    private double renderColHeaders(StiCrossTabParams pars, StiCrossTab master, StiContainer destination, StiRefObject<StiRectangle> rect, boolean measure, boolean skipStartRowCheck) {
        int sumHeader;
        int totalHeader;
        if (pars.startRow == 0 && !skipStartRowCheck) {
            return 0.0;
        }
        if (!measure) {
            StiRectangle measureRect = ((StiRectangle)rect.argvalue).clone();
            measureRect.height = 100000.0;
            double height = this.renderColHeaders(pars, master, destination, (StiRefObject<StiRectangle>)new StiRefObject((Object)measureRect), true, skipStartRowCheck);
            if (height > ((StiRectangle)rect.argvalue).height) {
                return 0.0;
            }
        }
        StiCross cross = master.getCrossTabInfo().Cross;
        int endCol = this.getEndColumn(pars, (StiRectangle)rect.argvalue, cross, master);
        if (!measure) {
            StiRectangle rectMeasure = ((StiRectangle)rect.argvalue).clone();
            StiRefObject stiRefObject = new StiRefObject((Object)rectMeasure);
            if (this.renderColHeaders(pars, master, destination, (StiRefObject<StiRectangle>)stiRefObject, true, false) > ((StiRectangle)rect.argvalue).height) {
                return 0.0;
            }
        }
        double totalHeight = 0.0;
        int index = 0;
        int n = totalHeader = StiCrossTabHelper.IsColFieldsEmpty(master) && master.getSummaryDirection() == StiSummaryDirection.LeftToRight && cross.getSumFields().size() > 1 ? 1 : 0;
        if (cross.isTopCrossTitleVisible()) {
            if (cross.isCrossTitlePrintOnAllPages()) {
                if (!measure) {
                    StiCrossTabHelper.renderCells(master, destination, pars.startColumn, 0, endCol, 1 + totalHeader, (StiRectangle)rect.argvalue);
                }
                for (int i = 0; i < 1 + totalHeader; ++i) {
                    ((StiRectangle)rect.argvalue).y += cross.getHeights()[i];
                    ((StiRectangle)rect.argvalue).height -= cross.getHeights()[i];
                    totalHeight += cross.getHeights()[i];
                }
            }
            ++index;
        }
        if (StiCrossTabHelper.IsColFieldsEmpty(master)) {
            return totalHeight;
        }
        int n2 = sumHeader = master.getSummaryDirection() == StiSummaryDirection.LeftToRight && cross.getSumFields().size() > 1 ? 1 : 0;
        if (!measure && this.allColFieldsPresentOnAllPages(cross)) {
            StiCrossTabHelper.renderCells(master, destination, pars.startColumn, index, endCol, index + cross.getColFields().size() + sumHeader, (StiRectangle)rect.argvalue);
        }
        for (int i = 0; i < cross.getColFields().size() + sumHeader; ++i) {
            if (i < cross.getColFields().size() && ((StiCrossHeader)cross.getColFields().get(i)).getPrintOnAllPages() || i >= cross.colFields.size()) {
                if (!measure && !this.allColFieldsPresentOnAllPages(cross)) {
                    StiCrossTabHelper.renderCells(master, destination, pars.startColumn, index, endCol, index + 1, (StiRectangle)rect.argvalue);
                }
                double height = cross.getHeights().length > index ? cross.getHeights()[index] : 0.0;
                ((StiRectangle)rect.argvalue).y += height;
                ((StiRectangle)rect.argvalue).height -= height;
                totalHeight += height;
            }
            ++index;
        }
        return totalHeight;
    }

    private double renderRowHeaders(StiCrossTabParams pars, StiCrossTab master, StiContainer destination, StiRefObject<StiRectangle> rect, boolean measure) {
        int endCol;
        StiCross cross = master.crossTabInfo.Cross;
        if (!master.getRightToLeft() && pars.startColumn == 0) {
            return 0.0;
        }
        if (master.getRightToLeft() && !measure && (endCol = StiCrossTabHelper.GetEndCol(master, pars.startColumn, (StiRectangle)rect.argvalue)) == cross.getCells().length) {
            if (master.getRightToLeft() && ((StiRectangle)rect.argvalue).width != 100000.0 - pars.ShiftX - destination.getLeft()) {
                double colsWidth = 0.0;
                for (int i = pars.startColumn; i < endCol; ++i) {
                    colsWidth += cross.getWidths()[i];
                }
                ((StiRectangle)rect.argvalue).x += ((StiRectangle)rect.argvalue).width - colsWidth;
            }
            return 0.0;
        }
        double headersWidth = 0.0;
        if (!measure) {
            StiRectangle measureRect = ((StiRectangle)rect.argvalue).clone();
            measureRect.width = 100000.0;
            headersWidth = this.renderRowHeaders(pars, master, destination, (StiRefObject<StiRectangle>)new StiRefObject((Object)measureRect), true);
            if (headersWidth > ((StiRectangle)rect.argvalue).width) {
                return 0.0;
            }
            if (master.getRightToLeft()) {
                measureRect = ((StiRectangle)rect.argvalue).clone();
                measureRect.width -= headersWidth;
                int endCol2 = StiCrossTabHelper.GetEndCol(master, pars.startColumn, measureRect);
                double nonHeaderWidth = 0.0;
                for (int i = pars.startColumn; i < endCol2; ++i) {
                    nonHeaderWidth += cross.getWidths()[i];
                }
                if (((StiRectangle)rect.argvalue).width != 100000.0) {
                    ((StiRectangle)rect.argvalue).x += ((StiRectangle)rect.argvalue).width - (nonHeaderWidth + headersWidth);
                }
                ((StiRectangle)rect.argvalue).width = nonHeaderWidth + headersWidth;
            }
        }
        double resHeight = ((StiRectangle)rect.argvalue).height;
        double resY = ((StiRectangle)rect.argvalue).y;
        double resX = ((StiRectangle)rect.argvalue).x;
        this.renderCorner(pars, master, destination, rect, cross, measure);
        if (!measure) {
            StiRectangle rectMeasure = ((StiRectangle)rect.argvalue).clone();
            StiRefObject stiRefObject = new StiRefObject((Object)rectMeasure);
            if (this.renderRowHeaders(pars, master, destination, (StiRefObject<StiRectangle>)stiRefObject, true) > ((StiRectangle)rect.argvalue).width) {
                return 0.0;
            }
        }
        double totalWidth = 0.0;
        int endRow = this.getEndRow(pars, (StiRectangle)rect.argvalue, cross);
        int index = 0;
        if (cross.isLeftCrossTitleVisible() || cross.isTopCrossTitleVisible() && cross.getIsColsEmpty()) {
            if (cross.isCrossTitlePrintOnAllPages()) {
                if (!measure) {
                    StiCrossTabHelper.renderCells(master, destination, 0, pars.startRow, 1, endRow, (StiRectangle)rect.argvalue);
                }
                ((StiRectangle)rect.argvalue).x += cross.getWidths()[0];
                ((StiRectangle)rect.argvalue).width -= cross.getWidths()[0];
                totalWidth += cross.getWidths()[0];
            }
            ++index;
        }
        if (StiCrossTabHelper.IsRowFieldsEmpty(master)) {
            return totalWidth;
        }
        int inc = 1;
        if (master.getRightToLeft()) {
            index = cross.getCells().length - 1 - index;
            inc = -1;
        }
        int startIndex = index;
        double sumWidth = 0.0;
        for (StiComponent _field : cross.getRowFields()) {
            double width;
            StiCrossHeader field = (StiCrossHeader)_field;
            double d = width = cross.getWidths().length > index ? cross.getWidths()[index] : 0.0;
            if (field.getPrintOnAllPages()) {
                sumWidth += width;
                totalWidth += width;
            }
            if ((!field.getPrintOnAllPages() || field == cross.getRowFields().get(cross.getRowFields().size() - 1)) && sumWidth > 0.0) {
                if (master.getRightToLeft()) {
                    ((StiRectangle)rect.argvalue).x = resX + ((StiRectangle)rect.argvalue).width - sumWidth;
                }
                if (!measure) {
                    StiCrossTabHelper.renderCells(master, destination, startIndex, pars.startRow, index + 1, endRow, (StiRectangle)rect.argvalue);
                }
                if (!master.getRightToLeft()) {
                    ((StiRectangle)rect.argvalue).x += sumWidth;
                }
                ((StiRectangle)rect.argvalue).width -= sumWidth;
                sumWidth = 0.0;
                startIndex = index + inc;
            }
            if (!master.getRightToLeft()) {
                ++index;
                continue;
            }
            --startIndex;
        }
        if (master.getRightToLeft()) {
            ((StiRectangle)rect.argvalue).x = resX;
        }
        ((StiRectangle)rect.argvalue).y = resY;
        ((StiRectangle)rect.argvalue).height = resHeight;
        return totalWidth;
    }

    private double renderCorner(StiCrossTabParams pars, StiCrossTab master, StiContainer destination, StiRefObject<StiRectangle> rect, StiCross cross, boolean measure) {
        if (pars.startRow == 0 || StiCrossTabHelper.IsColFieldsEmpty(master)) {
            return 0.0;
        }
        if (!measure) {
            StiRectangle rectMeasure = ((StiRectangle)rect.argvalue).clone();
            StiRefObject stiRefObject = new StiRefObject((Object)rectMeasure);
            if (this.renderCorner(pars, master, destination, (StiRefObject<StiRectangle>)stiRefObject, cross, true) > ((StiRectangle)rect.argvalue).height) {
                return 0.0;
            }
        }
        double totalHeight = 0.0;
        int index = 0;
        int rowCount = 0;
        for (StiComponent c : cross.getRowFields()) {
            rowCount += ((StiCrossHeader)c).getPrintOnAllPages() ? 1 : 0;
        }
        if (cross.isTopCrossTitleVisible()) {
            if (cross.isCrossTitlePrintOnAllPages()) {
                if (!measure) {
                    StiCrossTabHelper.renderCells(master, destination, 0, 0, rowCount, 1, (StiRectangle)rect.argvalue);
                }
                ((StiRectangle)rect.argvalue).y += cross.getHeights()[0];
                ((StiRectangle)rect.argvalue).height -= cross.getHeights()[0];
                totalHeight += cross.getHeights()[0];
            }
            ++index;
        }
        if (!measure && this.allColFieldsPresentOnAllPages(cross)) {
            StiCrossTabHelper.renderCells(master, destination, 0, index, rowCount, index + cross.getColFields().size(), (StiRectangle)rect.argvalue);
        }
        for (StiComponent _field : cross.colFields) {
            StiCrossHeader field = (StiCrossHeader)_field;
            if (field.getPrintOnAllPages()) {
                if (!measure && !this.allColFieldsPresentOnAllPages(cross)) {
                    StiCrossTabHelper.renderCells(master, destination, 0, index, rowCount, index + 1, (StiRectangle)rect.argvalue);
                }
                double height = cross.getHeights().length > index ? cross.getHeights()[index] : 0.0;
                ((StiRectangle)rect.argvalue).y += height;
                ((StiRectangle)rect.argvalue).height -= height;
                totalHeight += height;
            }
            ++index;
        }
        return totalHeight;
    }

    private boolean allColFieldsPresentOnAllPages(StiCross cross) {
        boolean all = true;
        for (StiComponent c : cross.getColFields()) {
            if (((StiCrossHeader)c).getPrintOnAllPages()) continue;
            all = false;
        }
        return all;
    }

    private void renderCrossTabSegment(StiCrossTabParams pars, StiCrossTab master, StiContainer destination, StiRectangle rect, StiRefObject<Integer> endCol, StiRefObject<Integer> endRow) {
        StiCross cross = master.crossTabInfo.Cross;
        this.renderRowHeaders(pars, master, destination, (StiRefObject<StiRectangle>)new StiRefObject((Object)rect), false);
        this.renderColHeaders(pars, master, destination, (StiRefObject<StiRectangle>)new StiRefObject((Object)rect), false, false);
        endRow.argvalue = StiCrossTabHelper.GetEndRow(master, pars.startRow, rect);
        endCol.argvalue = StiCrossTabHelper.GetEndCol(master, pars.startColumn, rect);
        endRow.argvalue = StiCrossTabHelper.checkMergedRowCells(master, pars.startRow, (Integer)endRow.argvalue, pars.startColumn, (Integer)endCol.argvalue);
        if (pars.startRow < (Integer)endRow.argvalue) {
            StiCrossTabHelper.renderCells(master, destination, pars.startColumn, pars.startRow, (Integer)endCol.argvalue, (Integer)endRow.argvalue, rect);
        }
        pars.renderingIsFinished = ((Integer)endCol.argvalue).intValue() == cross.getColCount() && ((Integer)endRow.argvalue).intValue() == cross.getRowCount();
        pars.startColumn = (Integer)endCol.argvalue;
        if (((Integer)endCol.argvalue).intValue() == cross.getColCount()) {
            pars.startColumn = 0;
            pars.startRow = (Integer)endRow.argvalue;
        }
    }

    static void makeHorAlignment(StiCrossTab master, StiContainer destination, int startIndex, double parentWidth, int segmentPerWidth) {
        if (master.getWrap()) {
            return;
        }
        if (master.getHorAlignment() == StiCrossHorAlignment.Width) {
            destination.setLeft(0.0);
            destination.width = parentWidth;
            StiCrossTabHelper.MakeHorAlignmentByWidth(destination, startIndex);
        } else if (master.getHorAlignment() != StiCrossHorAlignment.None) {
            destination.setLeft(0.0);
            destination.setWidth(parentWidth * (double)(segmentPerWidth > 1 ? segmentPerWidth : 1));
            StiRefObject maxLeft = new StiRefObject((Object)0.0);
            StiRefObject maxRight = new StiRefObject((Object)0.0);
            StiCrossTabHelper.CalculateMaxAndMin(destination, (StiRefObject<Double>)maxLeft, (StiRefObject<Double>)maxRight, startIndex);
            block5: for (int index = startIndex; index < destination.getComponents().size(); ++index) {
                StiComponent comp = (StiComponent)destination.getComponents().get(index);
                switch (master.getHorAlignment()) {
                    case Left: {
                        comp.setLeft(comp.getLeft() - (Double)maxLeft.argvalue);
                        continue block5;
                    }
                    case Right: {
                        comp.setLeft(comp.getLeft() + destination.width - (Double)maxRight.argvalue);
                        continue block5;
                    }
                    case Center: {
                        double newLeft = (destination.width - ((Double)maxRight.argvalue - (Double)maxLeft.argvalue)) / 2.0;
                        comp.setLeft(comp.getLeft() - ((Double)maxLeft.argvalue - newLeft));
                    }
                }
            }
        }
    }

    private static void finalizeCross(StiContainer renderedComponent) {
        renderedComponent.canGrow = false;
        renderedComponent.canShrink = true;
        StiSize size = renderedComponent.getActualSize();
        renderedComponent.width = size.width;
        renderedComponent.setHeight(size.height);
        renderedComponent.canGrow = true;
    }

    private int getEndColumn(StiCrossTabParams pars, StiRectangle rect, StiCross cross, StiCrossTab master) {
        int index;
        double width = rect.width;
        for (index = pars.startColumn; !(index >= cross.getColCount() || (width -= cross.getWidths()[index]) < 0.0 && master.getHorAlignment() != StiCrossHorAlignment.Width); ++index) {
        }
        if (index == pars.startColumn && index + 1 <= cross.getColCount()) {
            ++index;
        }
        return index;
    }

    private int getEndRow(StiCrossTabParams pars, StiRectangle rect, StiCross cross) {
        int index;
        double height = rect.height;
        for (index = pars.startRow; index < cross.getRowCount() && !((height -= cross.getHeights()[index]) < 0.0); ++index) {
        }
        if (index == pars.startRow && index + 1 <= cross.getRowCount()) {
            ++index;
        }
        return index;
    }

    public final StiComponent RenderCrossTabOnDataBand2(StiCrossTabParams pars, StiCrossTab masterCrossTab, StiContainer renderedComponent) {
        double pageWidthStep;
        StiRectangle rect = pars.getDestinationRectangle();
        rect.x = 0.0;
        rect.y = 0.0;
        rect.width = masterCrossTab.parent.getWidth() - rect.getLeft();
        rect.height = Double.MAX_VALUE;
        int endRow = pars.getStartRow();
        int endCol = pars.getStartColumn();
        pars.startColumn = 0;
        StiPage page = masterCrossTab.page;
        double pageWidth = pageWidthStep = page.getPageWidth() - page.margins.getLeft() - page.margins.getRight();
        int pageSegment = 1;
        if (!page.getUnlimitedBreakable()) {
            rect.width = 1.0E9;
            pageWidth = 1.0E9;
            pageWidthStep = 1.0E9;
        }
        int startIndex = renderedComponent.components.size();
        boolean crossTitleVisible = masterCrossTab.crossTabInfo.Cross.leftCrossTitle != null && masterCrossTab.crossTabInfo.Cross.leftCrossTitle.getEnabled() && masterCrossTab.crossTabInfo.Cross.rightCrossTitle != null && masterCrossTab.crossTabInfo.Cross.rightCrossTitle.getEnabled();
        boolean crossTitlePrintOnAllPages = masterCrossTab.crossTabInfo.Cross.leftCrossTitle != null && masterCrossTab.crossTabInfo.Cross.leftCrossTitle.getPrintOnAllPages() && masterCrossTab.crossTabInfo.Cross.rightCrossTitle != null && masterCrossTab.crossTabInfo.Cross.rightCrossTitle.getPrintOnAllPages();
        int startRowIndex = 0;
        int pageNumber = 0;
        while (startRowIndex < masterCrossTab.crossTabInfo.Cross.getRowCount()) {
            StiRectangle rectForTab = StiRectangle.empty();
            if (masterCrossTab.getPrintTitleOnAllPages()) {
                if (startRowIndex == 0) {
                    rectForTab.height = masterCrossTab.getReport().engine.getFreeSpace();
                    if (page.getUnlimitedHeight() && !page.getUnlimitedBreakable()) {
                        rectForTab.height = 1.0E9;
                    }
                    rectForTab.height -= masterCrossTab.top;
                } else {
                    rectForTab.height = masterCrossTab.getReport().engine.getStaticBands().getReservedFreeSpace();
                }
            } else {
                rectForTab.height = 1.0E9;
            }
            while (pars.startColumn < masterCrossTab.crossTabInfo.Cross.getColCount()) {
                double offsetOnY = 0.0;
                double offsetOnX = 0.0;
                rectForTab.width = pageWidthStep;
                double widthRowHeader = 0.0;
                int countActualHeaderRowCount = this.GetActualHeaderRowCount(masterCrossTab);
                if (masterCrossTab.getWrap() && masterCrossTab.getRightToLeft()) {
                    for (int index = masterCrossTab.crossTabInfo.Cross.getWidths().length - 1; index > masterCrossTab.crossTabInfo.Cross.getWidths().length - countActualHeaderRowCount - 1; --index) {
                        widthRowHeader += masterCrossTab.crossTabInfo.Cross.getWidths()[index];
                    }
                    rectForTab.width -= widthRowHeader;
                }
                endCol = StiCrossTabHelper.GetEndCol(masterCrossTab, pars.startColumn, rectForTab);
                if (startRowIndex != 0 && masterCrossTab.getPrintTitleOnAllPages()) {
                    if (crossTitleVisible && crossTitlePrintOnAllPages) {
                        StiCrossTabHelper.RenderCells(masterCrossTab, renderedComponent instanceof StiContainer ? renderedComponent : null, pars.startColumn, 0, endCol, 1, rect);
                    }
                    rect.y += masterCrossTab.crossTabInfo.Cross.getHeights()[0];
                    offsetOnY += masterCrossTab.crossTabInfo.Cross.getHeights()[0];
                    rectForTab.height -= masterCrossTab.crossTabInfo.Cross.getHeights()[0];
                    int rowIndexEnd = this.GetActualHeaderRowCount(masterCrossTab);
                    if (rowIndexEnd != 0) {
                        int i;
                        if (crossTitleVisible) {
                            StiCrossTabHelper.RenderCells(masterCrossTab, renderedComponent instanceof StiContainer ? renderedComponent : null, pars.startColumn, 1, endCol, rowIndexEnd + 1, rect);
                            for (i = 1; i <= rowIndexEnd; ++i) {
                                rect.y += masterCrossTab.crossTabInfo.Cross.getHeights()[i];
                                offsetOnY += masterCrossTab.crossTabInfo.Cross.getHeights()[i];
                                rectForTab.height -= masterCrossTab.crossTabInfo.Cross.getHeights()[i];
                            }
                        } else {
                            StiCrossTabHelper.RenderCells(masterCrossTab, renderedComponent instanceof StiContainer ? renderedComponent : null, pars.startColumn, 0, endCol, rowIndexEnd, rect);
                            for (i = 0; i < rowIndexEnd; ++i) {
                                rect.y += masterCrossTab.crossTabInfo.Cross.getHeights()[i];
                                offsetOnY += masterCrossTab.crossTabInfo.Cross.getHeights()[i];
                                rectForTab.height -= masterCrossTab.crossTabInfo.Cross.getHeights()[i];
                            }
                        }
                    }
                    endCol = StiCrossTabHelper.GetEndCol(masterCrossTab, pars.startColumn, rectForTab);
                }
                endRow = StiCrossTabHelper.GetEndRow(masterCrossTab, startRowIndex, rectForTab);
                StiCrossTabHelper.RenderCells(masterCrossTab, renderedComponent, pars.startColumn, startRowIndex, endCol, endRow, rect);
                if (masterCrossTab.getWrap()) {
                    if (masterCrossTab.getRightToLeft() && endCol < masterCrossTab.crossTabInfo.Cross.getColCount() - 1) {
                        double _width = 0.0;
                        for (int index = pars.startColumn; index < endCol; ++index) {
                            _width += masterCrossTab.crossTabInfo.Cross.getWidths()[index];
                        }
                        rect.x += _width;
                        StiCrossTabHelper.RenderCells(masterCrossTab, renderedComponent, masterCrossTab.crossTabInfo.Cross.getWidths().length - countActualHeaderRowCount, startRowIndex, masterCrossTab.crossTabInfo.Cross.getWidths().length, endRow, rect);
                        rect.x -= _width;
                    }
                    StiSize sizeCrossTab = StiCrossTabHelper.GetCellsRect(masterCrossTab, pars.startColumn, pars.startRow, endCol, endRow);
                    if (rectForTab.height - sizeCrossTab.height < sizeCrossTab.height + masterCrossTab.getWrapGap()) {
                        rect.y = masterCrossTab.page.getHeight() * (double)(++pageNumber);
                        rect.x = 0.0;
                        rectForTab.height = startRowIndex == 0 ? masterCrossTab.getReport().engine.getFreeSpace() - masterCrossTab.top : masterCrossTab.getReport().engine.staticBands.getReservedFreeSpace();
                    } else {
                        rect.y += sizeCrossTab.height + masterCrossTab.getWrapGap();
                        rectForTab.height -= sizeCrossTab.height + masterCrossTab.getWrapGap();
                        rect.x = 0.0;
                    }
                    pars.startColumn = endCol;
                    continue;
                }
                rect.x += pageWidth - offsetOnX;
                rect.width = pageWidthStep;
                pars.startColumn = endCol;
                if (pars.startColumn < masterCrossTab.crossTabInfo.Cross.getColCount() && startRowIndex == 0) {
                    renderedComponent.getContainerInfoV2().SetSegmentPerWidth = ++pageSegment;
                }
                if (startRowIndex == 0) continue;
                rect.y -= offsetOnY;
                rectForTab.height += offsetOnY;
            }
            if (!masterCrossTab.getWrap()) {
                rect.y += rectForTab.height;
                rect.x = 0.0;
            }
            startRowIndex = endRow;
            pars.startColumn = 0;
        }
        StiCrossTabV2Builder.MakeHorAlignment(masterCrossTab, renderedComponent, startIndex, masterCrossTab.parent.getWidth());
        if (!page.getUnlimitedBreakable()) {
            double maxRight2 = 0.0;
            for (int compIndex = startIndex; compIndex < renderedComponent.components.size(); ++compIndex) {
                StiComponent comp = (StiComponent)renderedComponent.components.get(compIndex);
                maxRight2 = Math.max(comp.getRight(), maxRight2);
            }
            int pageSegmentPerWidth = page.segmentPerWidth;
            for (double pageWidth2 = page.getWidth(); pageWidth2 < maxRight2; pageWidth2 += page.getWidth()) {
                renderedComponent.getContainerInfoV2().SetSegmentPerWidth = 1;
                renderedComponent.getContainerInfoV2().SetSegmentPerWidth = ++pageSegmentPerWidth;
            }
        }
        return renderedComponent;
    }

    public final StiComponent RenderCrossTab(StiCrossTabParams pars, StiCrossTab master) {
        boolean placedOnBand = StiSubReportsHelper.GetParentBand(master) != null;
        StiContainer destination = pars.getDestinationContainer();
        if (destination == null) {
            StiComponent tempVar = super.InternalRender(master);
            destination = (StiContainer)(tempVar instanceof StiContainer ? tempVar : null);
            destination.components.Clear();
        }
        destination.setDockStyle(StiDockStyle.None);
        if (!master.page.getUnlimitedHeight() || master.page.getUnlimitedBreakable()) {
            destination.setCanBreak(true);
        }
        if (!pars.getAllowRendering()) {
            return destination;
        }
        if ((master.getDataSource() == null || master.getDataSource().getIsEmpty()) && !master.getPrintIfEmpty()) {
            pars.setRenderingIsFinished(true);
            return destination;
        }
        StiRectangle rect = pars.getDestinationRectangle().clone();
        rect.x = 0.0;
        rect.y = 0.0;
        if (placedOnBand) {
            StiPage page = master.page;
            if (!master.getRightToLeft()) {
                this.renderCrossTabOnDataBand(pars, master, destination, rect);
            } else if (!page.getUnlimitedBreakable()) {
                double right = 0.0;
                for (double width : master.crossTabInfo.Cross.getWidths()) {
                    right += width;
                }
                double onePageWidth = page.getPageWidth() - page.getMargins().getLeft() - page.margins.getRight();
                int pagesCount = (int)(right / onePageWidth) + 1;
                pars.ShiftX = (double)pagesCount * onePageWidth - right;
                this.renderCrossTabOnDataBand(pars, master, destination, rect);
            } else {
                master.setRightToLeft(false);
                this.renderCrossTabOnDataBand(pars, master, destination, rect);
                double right = 0.0;
                for (StiComponent c : destination.getComponents()) {
                    right = Math.max(right, c.getRight());
                }
                double onePageWidth = page.getPageWidth() - page.margins.getLeft() - page.margins.getRight();
                int pagesCount = (int)(right / onePageWidth) + 1;
                pars.ShiftX = (double)pagesCount * onePageWidth - right - destination.getLeft();
                destination.components.clear();
                master.setRightToLeft(true);
                StiCrossTabHelper.MakeRightToLeft(master);
                master.crossTabInfo.Cross.DoAutoSize();
                this.renderCrossTabOnDataBand(pars, master, destination, rect);
            }
            return destination;
        }
        if (master.page.getUnlimitedHeight()) {
            rect.height = 1.0E8;
            if (master.getPage().getUnlimitedBreakable()) {
                this.renderCrossTabUnlimitedBreakable(pars, master, destination, rect);
            } else {
                this.renderCrossTabUnlimited(pars, master, destination, rect);
            }
        } else {
            int endCol = 0;
            int endRow = 0;
            this.renderCrossTabOnPage(pars, master, destination, rect, (StiRefObject<Integer>)new StiRefObject((Object)endCol), (StiRefObject<Integer>)new StiRefObject((Object)endRow));
        }
        return destination;
    }

    private static StiPage getPageForCrossTab(StiContainer destination) {
        StiPage page = null;
        for (StiContainer parent = destination; page == null && parent != null; parent = parent.getParent()) {
            page = parent.getPage();
        }
        return page;
    }

    public void renderCrossTabUnlimitedBreakable(StiCrossTabParams pars, StiCrossTab master, StiContainer destination, StiRectangle rect) {
        StiPage page = StiCrossTabV2Builder.getPageForCrossTab(destination);
        page = page != null ? page : master.getReport().getRenderedPages().get(master.getReport().getRenderedPages().size() - 1);
        int endCol = StiCrossTabHelper.GetEndCol(master, pars.startColumn, rect);
        int endRow = StiCrossTabHelper.GetEndRow(master, pars.startRow, rect);
        double pageWidth = page.getWidth();
        double pageHeight = page.getHeight();
        int segmentHeightIndex = 0;
        int currentRow = 0;
        while (currentRow < endRow) {
            page.segmentPerHeight = Math.max(page.segmentPerHeight, segmentHeightIndex + 1);
            double segmentWidthIndex = 0.0;
            int currentCol = 0;
            int reachedRow = 0;
            while (currentCol < endCol) {
                page.setSegmentPerWidth((int)Math.max((double)page.segmentPerWidth.intValue(), segmentWidthIndex + 1.0));
                StiRectangle rectSegment = new StiRectangle(rect.getLeft() + segmentWidthIndex * pageWidth, rect.getTop() + (double)segmentHeightIndex * pageHeight, pars.getDestinationRectangle().getWidth(), pars.getDestinationRectangle().getHeight());
                pars.startColumn = currentCol;
                pars.startRow = currentRow;
                StiRefObject currentColRef = new StiRefObject((Object)currentCol);
                StiRefObject reachedRowRef = new StiRefObject((Object)reachedRow);
                this.renderCrossTabOnPage(pars, master, destination, rectSegment, (StiRefObject<Integer>)currentColRef, (StiRefObject<Integer>)reachedRowRef);
                currentCol = (Integer)currentColRef.argvalue;
                reachedRow = (Integer)reachedRowRef.argvalue;
                segmentWidthIndex += 1.0;
            }
            currentRow = reachedRow;
            ++segmentHeightIndex;
        }
    }

    private void renderCrossTabUnlimited(StiCrossTabParams pars, StiCrossTab master, StiContainer destination, StiRectangle rect) {
        StiCross cross = master.getCrossTabInfo().Cross;
        StiPage page = StiCrossTabV2Builder.getPageForCrossTab(destination);
        page = page != null ? page : master.getReport().getRenderedPages().get(master.getReport().getRenderedPages().size() - 1);
        int endCol = 0;
        int endRow = 0;
        this.renderCrossTabOnPage(pars, master, destination, rect, (StiRefObject<Integer>)new StiRefObject((Object)endCol), (StiRefObject<Integer>)new StiRefObject((Object)endRow));
        double totalWidth = 0.0;
        for (double width : cross.getWidths()) {
            totalWidth += width;
        }
        double segmentPerWidth = (totalWidth += master.getLeft()) / (pars.getDestinationRectangle().getWidth() + pars.getDestinationRectangle().getX());
        while (segmentPerWidth > (double)page.getSegmentPerWidth()) {
            StiPage stiPage = page;
            Integer n = stiPage.segmentPerWidth;
            Integer object = stiPage.segmentPerWidth = Integer.valueOf(stiPage.segmentPerWidth + 1);
        }
        double totalHeight = 0.0;
        for (double height : cross.getHeights()) {
            totalHeight += height;
        }
        double d = (totalHeight += master.getTop()) / (pars.getDestinationRectangle().getHeight() + pars.getDestinationRectangle().getY());
        while (d > (double)page.getSegmentPerHeight()) {
            StiPage stiPage = page;
            Integer n = stiPage.segmentPerHeight;
            Integer n2 = stiPage.segmentPerHeight = Integer.valueOf(stiPage.segmentPerHeight + 1);
        }
    }

    private void renderCrossTabOnPage(StiCrossTabParams pars, StiCrossTab master, StiContainer destination, StiRectangle rect, StiRefObject<Integer> endCol, StiRefObject<Integer> endRow) {
        this.renderCrossTabSegment(pars, master, destination, rect, endCol, endRow);
        StiCrossTabV2Builder.MakeHorAlignment(master, destination, 0, pars.getDestinationContainer() != null ? pars.getDestinationContainer().getWidth() : master.getParent().getWidth());
        StiCrossTabV2Builder.finalizeCross(destination);
    }

    private int GetActualHeaderRowCount(StiCrossTab masterCrossTab) {
        int headerRowCount = 0;
        int summaryCount = 0;
        for (StiComponent comp : masterCrossTab.components) {
            if (comp instanceof StiCrossSummary && ((StiCrossSummary)comp).getEnabled()) {
                ++summaryCount;
            }
            if (!(comp instanceof StiCrossColumn) || !((StiCrossColumn)comp).getEnabled()) continue;
            ++headerRowCount;
        }
        if (summaryCount > 1 && masterCrossTab.getSummaryDirection() == StiSummaryDirection.LeftToRight) {
            ++headerRowCount;
        }
        return headerRowCount;
    }

    private int GetActualHeaderColumnCount(StiCrossTab masterCrossTab) {
        int headerColumnCount = 0;
        int summaryCount = 0;
        for (StiComponent comp : masterCrossTab.components) {
            if (comp instanceof StiCrossSummary && ((StiCrossSummary)comp).getEnabled()) {
                ++summaryCount;
            }
            if (!(comp instanceof StiCrossRow) || !((StiCrossRow)comp).getEnabled()) continue;
            ++headerColumnCount;
        }
        if (summaryCount > 1 && masterCrossTab.getSummaryDirection() == StiSummaryDirection.UpToDown) {
            ++headerColumnCount;
        }
        return headerColumnCount;
    }

    @Override
    public void Prepare(StiComponent masterComp) {
        super.Prepare(masterComp);
        StiFilterHelper.SetFilter(masterComp);
    }

    @Override
    public StiComponent InternalRender(StiComponent masterComp) {
        StiCrossTab masterCrossTab = (StiCrossTab)(masterComp instanceof StiCrossTab ? masterComp : null);
        StiCrossTabParams pars = new StiCrossTabParams();
        boolean placedOnBand = StiSubReportsHelper.GetParentBand(masterCrossTab) != null;
        pars.setAllowRendering(placedOnBand);
        StiDataBand band = (StiDataBand)(masterComp.parent instanceof StiDataBand ? masterComp.parent : null);
        if (band != null) {
            pars.setDestinationRectangle(band.parent.getClientRectangle());
        } else {
            pars.setDestinationRectangle(masterCrossTab.getClientRectangle());
        }
        if (placedOnBand) {
            StiCrossTabHelper.CreateCross(masterCrossTab);
            return this.RenderCrossTab(pars, masterCrossTab);
        }
        StiComponent tempVar = super.InternalRender(masterComp);
        StiContainer cont = (StiContainer)(tempVar instanceof StiContainer ? tempVar : null);
        if (cont != null) {
            cont.setWidth(masterComp.getWidth());
            cont.setHeight(masterComp.getHeight());
            cont.components.Clear();
        }
        return cont;
    }
}

