/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine;

import com.stimulsoft.base.elements.StiKeyHelper;
import com.stimulsoft.base.helper.StiValueHelper;
import com.stimulsoft.base.range.DateTimeRange;
import com.stimulsoft.base.range.Range;
import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.type.StiSystemType;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.StiScriptHelper;
import com.stimulsoft.report.StiVariableExpressionHelper;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiDataParameter;
import com.stimulsoft.report.dictionary.StiDialogInfo;
import com.stimulsoft.report.dictionary.StiDialogInfoItem;
import com.stimulsoft.report.dictionary.StiDictionary;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.dictionary.dataSources.StiSqlSource;
import com.stimulsoft.report.dictionary.enums.StiDateTimeType;
import com.stimulsoft.report.dictionary.enums.StiItemsInitializationType;
import com.stimulsoft.report.dictionary.enums.StiSelectionMode;
import com.stimulsoft.report.dictionary.enums.StiVariableInitBy;
import com.stimulsoft.report.engine.parser.StiAsmCommand;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.engine.parser.enums.StiAsmCommandType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class StiVariableHelper {
    private static ConcurrentHashMap<String, Hashtable<String, String>> ReportToLabels = new ConcurrentHashMap();

    public static void setVariableLabel(StiReport report, StiVariable variable, String label) {
        String variableName;
        if (report == null || label == null) {
            return;
        }
        String string = variableName = variable != null ? variable.name : null;
        if (StiValidationUtil.isNullOrWhiteSpace((String)variableName)) {
            return;
        }
        report.setKey(StiKeyHelper.getOrGeneratedKey((String)report.getKey()));
        Hashtable<String, String> labels = ReportToLabels.get(report.getKey());
        if (labels == null) {
            labels = new Hashtable();
            ReportToLabels.put(report.getKey(), labels);
        }
        labels.put(variableName, label);
    }

    public static String getVariableLabel(StiReport report, String variableName) {
        if (report == null) {
            return "";
        }
        if (StiValidationUtil.isNullOrWhiteSpace((String)variableName)) {
            return "";
        }
        report.setKey(StiKeyHelper.getOrGeneratedKey((String)report.getKey()));
        Hashtable<String, String> labels = ReportToLabels.get(report.getKey());
        if (labels == null) {
            return "";
        }
        String value = labels.get(variableName);
        if (value == null) {
            return "";
        }
        return value;
    }

    public static void setDefaultValueForRequestFromUserVariablesIfUserItems(StiReport report) {
        if (report == null) {
            return;
        }
        StiVariableHelper.initDateTimeVariables(report);
        StiText tempText = new StiText();
        tempText.setName(StiVariableExpressionHelper.ParserCompId);
        if (report.getPages().size() > 0) {
            tempText.setPage(report.getPages().get(0));
        }
        Iterator iterator = report.getDictionary().getVariables().iterator();
        while (iterator.hasNext()) {
            StiVariable variable = (StiVariable)iterator.next();
            StiDialogInfo info = variable.getDialogInfo();
            if (!variable.getRequestFromUser() || info.getItemsInitializationType() != StiItemsInitializationType.Items || variable.getSystemType().isList() || report.getModifiedVariables().containsKey(variable.getName())) continue;
            try {
                if (variable.getSelection() == StiSelectionMode.FromVariable && variable.getInitBy() == StiVariableInitBy.Expression) {
                    Object newValue = null;
                    try {
                        if (variable.getSystemType().isRange() && variable.getValue() != null && variable.getValue().contains("<<|>>")) {
                            int pos = variable.getValue().indexOf("<<|>>");
                            newValue = variable.getSystemType().getInstance();
                            ((Range)newValue).setFromObject(StiScriptHelper.parseTextValue("{" + variable.getValue().substring(0, pos) + "}", tempText));
                            ((Range)newValue).setToObject(StiScriptHelper.parseTextValue("{" + variable.getValue().substring(pos + 5) + "}", tempText));
                        } else {
                            newValue = StiScriptHelper.parseTextValue("{" + variable.getValue() + "}", tempText);
                        }
                    }
                    catch (Exception pos) {
                        // empty catch block
                    }
                    if (variable.getType() == StiSystemTypeEnum.SystemDateOnly) {
                        newValue = StiValueHelper.tryToNullableDateOnly(newValue);
                    } else if (variable.getType() == StiSystemTypeEnum.SystemTimeOnly) {
                        newValue = StiValueHelper.tryToNullableTimeOnly((Object)newValue);
                    } else if (info.getDateTimeType() != StiDateTimeType.Date || newValue instanceof StiDateTime) {
                        // empty if block
                    }
                    if (!report.isReportRenderingAfterSubmit) {
                        int index;
                        int n = index = newValue != null && info.getKeys() != null ? info.getKeys().indexOf(newValue.toString()) : -1;
                        if (index != -1) {
                            StiVariableHelper.setVariableLabel(report, variable, info.getValues().get(index));
                        }
                    }
                }
                if (variable.getSelection() == StiSelectionMode.FromVariable && variable.getInitBy() == StiVariableInitBy.Value && !report.isReportRenderingAfterSubmit) {
                    int index;
                    int n = index = variable.getValueObject() != null && info.getKeys() != null ? info.getKeys().indexOf(variable.getValueObject().toString()) : -1;
                    if (index != -1) {
                        StiVariableHelper.setVariableLabel(report, variable, info.getValues().get(index));
                    }
                }
                if (variable.getSelection() != StiSelectionMode.First || info.getKeys() == null || info.getKeys().size() <= 0 || !variable.getType().getSystemType().isList() || variable.getType().getSystemType().isRange()) continue;
                Object newValue = StiReport.changeType(info.getKeys().get(0), variable.getSystemType());
                report.set(variable.getName(), newValue);
                if (report.isReportRenderingAfterSubmit) continue;
                StiVariableHelper.setVariableLabel(report, variable, info.getValues().get(0));
            }
            catch (Exception exception) {}
        }
    }

    public static void setDefaultValueForRequestFromUserVariables(StiReport report, boolean haveVars) {
        StiVariable variable;
        StiDataSource ds;
        Hashtable<String, Boolean> vars = new Hashtable<String, Boolean>();
        StiText tempText = new StiText();
        tempText.setName("**VariableRequestFromUser**");
        tempText.setPage(report.getPages().get(0));
        StiVariableHelper.initDateTimeVariables(report);
        if (report.isReportRenderingAfterSubmit) {
            return;
        }
        Hashtable<String, String> hashSql = new Hashtable<String, String>();
        Iterator iterator = report.getDictionary().getDataSources().iterator();
        while (iterator.hasNext()) {
            ds = (StiDataSource)iterator.next();
            StiSqlSource sql = ds instanceof StiSqlSource ? (StiSqlSource)ds : null;
            if (sql == null) continue;
            hashSql.put(ds.getName(), sql.getSqlCommand());
        }
        if (!report.isReportRenderingAfterSubmit) {
            iterator = report.getDictionary().getVariables().iterator();
            while (iterator.hasNext()) {
                variable = (StiVariable)iterator.next();
                if (!variable.getRequestFromUser() || !variable.getSystemType().isList() || report.getModifiedVariables().containsKey(variable.getName()) || variable.getDialogInfo().getValues() == null) continue;
                StringBuilder str = new StringBuilder();
                List<String> values = variable.getDialogInfo().getValues();
                for (int i = 0; i < values.size(); ++i) {
                    str.append(values.get(i));
                    if (i == values.size() - 1) continue;
                    str.append(",");
                }
                StiVariableHelper.setVariableLabel(report, variable, str.toString());
            }
        }
        iterator = report.getDictionary().getVariables().iterator();
        while (iterator.hasNext()) {
            variable = (StiVariable)iterator.next();
            if (!variable.getRequestFromUser() || report.getModifiedVariables().containsKey(variable.getName()) || variable.isRange() || variable.isList()) continue;
            try {
                vars.put(variable.getName(), true);
                if (variable.getSelection() == StiSelectionMode.FromVariable && variable.getInitBy() == StiVariableInitBy.Expression) {
                    int index;
                    Object newValue = StiScriptHelper.parseTextValue("{" + variable.getValue() + "}", tempText);
                    if (variable.getSystemType().getEnumType() == StiSystemTypeEnum.SystemDateOnly) {
                        newValue = StiValueHelper.tryToNullableDateOnly((Object)newValue);
                    }
                    if (variable.getSystemType().getEnumType() == StiSystemTypeEnum.SystemTimeOnly) {
                        newValue = StiValueHelper.tryToNullableTimeOnly((Object)newValue);
                    }
                    if (!report.isReportRenderingAfterSubmit && newValue != null && (index = variable.getDialogInfo().getKeys().indexOf(newValue.toString())) != -1) {
                        StiVariableHelper.setVariableLabel(report, variable, variable.getDialogInfo().getValues().get(index));
                    }
                    report.setVariable(variable.getName(), newValue);
                    haveVars = true;
                }
                if (variable.getSelection() == StiSelectionMode.FromVariable && variable.getInitBy() == StiVariableInitBy.Value && !report.isReportRenderingAfterSubmit) {
                    int index;
                    int n = index = variable.getValueObject() != null ? variable.getDialogInfo().getKeys().indexOf(variable.getValueObject().toString()) : -1;
                    if (index != -1) {
                        StiVariableHelper.setVariableLabel(report, variable, variable.getDialogInfo().getValues().get(index));
                    }
                }
                if (variable.getSelection() != StiSelectionMode.First) continue;
                Object newValue = StiReport.changeType(variable.getDialogInfo().getKeys().get(0), variable.getType().getSystemType());
                report.setVariable(variable.getName(), newValue);
                haveVars = true;
                if (report.isReportRenderingAfterSubmit) continue;
                StiVariableHelper.setVariableLabel(report, variable, variable.getDialogInfo().getValues().get(0));
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel >= 10) {
                    e.printStackTrace();
                }
                haveVars = true;
            }
        }
        if (!haveVars) {
            return;
        }
        iterator = report.getDictionary().getDataSources().iterator();
        while (iterator.hasNext()) {
            ds = (StiDataSource)iterator.next();
            StiSqlSource sql = ds instanceof StiSqlSource ? (StiSqlSource)ds : null;
            if (sql == null) continue;
            try {
                boolean found;
                String oldSql = (String)hashSql.get(ds.getName());
                String newSql = sql.getFinalSqlCommand();
                boolean bl = found = oldSql != newSql;
                if (!found) {
                    found = StiVariableHelper.checkExpressionForVariables(sql.getSqlCommand(), tempText, vars);
                }
                if (!found) {
                    for (StiDataParameter parameter : sql.getParameters()) {
                        if (StiValidationUtil.isNullOrWhiteSpace((String)parameter.getExpression()) || !StiVariableHelper.checkExpressionForVariables(parameter.getExpression(), tempText, vars)) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) continue;
                ds.disconnect();
                ds.connect();
            }
            catch (Exception exception) {}
        }
    }

    private static boolean checkExpressionForVariables(String expression, StiComponent component, Hashtable<String, Boolean> vars) {
        block4: {
            try {
                boolean storeToPrint = false;
                Object result = StiParser.ParseTextValue(expression, component, storeToPrint, false, true, false);
                if (result != null && result instanceof List) {
                    for (StiAsmCommand asmCommand : (List)result) {
                        String varName;
                        if (asmCommand.Type != StiAsmCommandType.PushVariable || !vars.containsKey(varName = asmCommand.Parameter1.toString())) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel < 10) break block4;
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean FillItemsOfVariables(StiReport report) {
        return StiVariableHelper.FillItemsOfVariables(report, null);
    }

    public static boolean FillItemsOfVariables(StiReport report, Boolean modeItems) {
        StiVariable variable;
        StiRefObject modified = new StiRefObject((Object)false);
        Iterator iterator = report.getDictionary().getVariables().iterator();
        while (iterator.hasNext() && !StiVariableHelper.fillItemsOfVariable(variable = (StiVariable)iterator.next(), report, (StiRefObject<Boolean>)modified, modeItems)) {
        }
        return (Boolean)modified.argvalue;
    }

    public static boolean fillItemsOfVariable(StiVariable variable, StiReport report, StiRefObject<Boolean> modified) {
        return StiVariableHelper.fillItemsOfVariable(variable, report, modified, null);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean fillItemsOfVariable(StiVariable variable, StiReport report, StiRefObject<Boolean> modified, Boolean modeItems) {
        boolean processColumns;
        if (variable.getDialogInfo() == null) {
            return false;
        }
        boolean processItems = modeItems == null || modeItems == true;
        boolean bl = processColumns = modeItems == null || modeItems == false;
        if (variable.getDialogInfo().getItemsInitializationType() == StiItemsInitializationType.Items && processItems) {
            if (report.isReportRenderingAfterSubmit) {
                return false;
            }
            List<StiDialogInfoItem> items = variable.getDialogInfo().getDialogInfoItems(variable.getType());
            items = variable.getDialogInfo().orderBy(items);
            if (items != null && items.size() > 0) {
                List list = (List)(report.getVariable(variable.getName()) instanceof List ? report.getVariable(variable.getName()) : null);
                if (list == null) {
                    return false;
                }
                if (list.size() > 0) {
                    return true;
                }
                list.clear();
                for (StiDialogInfoItem item : items) {
                    list.add(item.KeyObject);
                }
            }
        } else if (variable.getDialogInfo().getItemsInitializationType() == StiItemsInitializationType.Columns && processColumns) {
            Object[] valuesBinding;
            if (variable.getDialogInfo().getKeys() != null && variable.getDialogInfo().getKeys().size() > 0 || variable.getDialogInfo().getValues() != null && variable.getDialogInfo().getValues().size() > 0 || variable.getDialogInfo().checkedStates != null && variable.getDialogInfo().checkedStates.size() > 0) {
                return false;
            }
            Object[] keys = !StiValidationUtil.isNullOrEmpty((String)variable.getDialogInfo().getKeysColumn()) ? StiDataColumn.GetDatasFromDataColumn(report.getDictionary(), variable.getDialogInfo().getKeysColumn()) : null;
            Object[] values = !StiValidationUtil.isNullOrEmpty((String)variable.getDialogInfo().getValuesColumn()) ? StiDataColumn.GetDatasFromDataColumn(report.getDictionary(), variable.getDialogInfo().getValuesColumn()) : null;
            Boolean[] checkedStates = !StiValidationUtil.isNullOrEmpty((String)variable.getDialogInfo().getCheckedColumn()) ? StiVariableHelper.getChecked(report.getDictionary(), variable.getDialogInfo().getCheckedColumn(), variable.getDialogInfo().getKeysColumn(), variable.getDialogInfo().getValuesColumn()) : null;
            Object[] objectArray = valuesBinding = !StiValidationUtil.isNullOrEmpty((String)variable.getDialogInfo().getBindingValuesColumn()) ? StiDataColumn.GetDatasFromDataColumn(report.getDictionary(), variable.getDialogInfo().getBindingValuesColumn()) : null;
            if (keys == null) {
                keys = new Object[]{};
            }
            if (values == null) {
                values = new Object[]{};
            }
            if (checkedStates == null) {
                checkedStates = new Boolean[]{};
            }
            if (valuesBinding == null) {
                valuesBinding = new Object[]{};
            }
            int length = Math.max(keys.length, values.length);
            length = Math.max(length, checkedStates.length);
            HashMap hashKeysValuesBinding = new HashMap();
            if (keys.length > 0) {
                ArrayList<Object> keys1 = new ArrayList<Object>();
                ArrayList<String> values1 = new ArrayList<String>();
                ArrayList<Object> valuesBinding1 = new ArrayList<Object>();
                ArrayList<Boolean> states1 = new ArrayList<Boolean>();
                for (int index = 0; index < length; ++index) {
                    Object key = keys.length > index ? keys[index] : null;
                    String value = values.length > index ? values[index].toString() : "";
                    Object object = values.length > index ? values[index] : null;
                    Object valueBinding = valuesBinding.length > index ? valuesBinding[index] : null;
                    Boolean state = checkedStates != null && checkedStates.length > index ? StiValueHelper.tryToBool((Object)checkedStates[index]) : true;
                    if (object instanceof StiDateTime) {
                        StiDateTime dateTimeValue = (StiDateTime)values[index];
                        switch (variable.getDialogInfo().getDateTimeType()) {
                            case DateAndTime: {
                                value = dateTimeValue.toString();
                                break;
                            }
                            case Date: {
                                value = dateTimeValue.format("MM/dd/yyyy");
                                break;
                            }
                            case Time: {
                                value = dateTimeValue.format("MM/dd/yyyy hh:mm:ss a");
                            }
                        }
                    }
                    if (!hashKeysValuesBinding.containsKey(key)) {
                        keys1.add(key);
                        values1.add(value);
                        valuesBinding1.add(valueBinding);
                        ArrayList<Object> list = new ArrayList<Object>();
                        list.add(valueBinding);
                        states1.add(state);
                        hashKeysValuesBinding.put(key, list);
                        continue;
                    }
                    List listValueBinding = (List)hashKeysValuesBinding.get(key);
                    listValueBinding.add(valueBinding);
                }
                keys = keys1.toArray();
                values = values1.toArray();
                valuesBinding = valuesBinding1.toArray();
                checkedStates = states1.toArray(new Boolean[0]);
                length = Math.max(keys.length, values.length);
                length = Math.max(length, checkedStates.length);
            }
            ArrayList<StiDialogInfoItem> items = new ArrayList<StiDialogInfoItem>();
            StiSystemType type = variable.getSystemType();
            for (int index = 0; index < length; ++index) {
                void var19_39;
                Object key = keys.length > index ? keys[index] : null;
                String value = values.length > index ? values[index].toString() : "";
                Boolean state = checkedStates != null && checkedStates.length > index ? checkedStates[index] : true;
                Object valueBinding = valuesBinding.length > index ? valuesBinding[index] : null;
                Object var19_29 = null;
                if (!type.isRange() && type.isInteger()) {
                    StiDialogInfoItem.StiLongDialogInfoItem stiLongDialogInfoItem = new StiDialogInfoItem.StiLongDialogInfoItem();
                } else if (!type.isRange() && type.getEnumType() == StiSystemTypeEnum.SystemString) {
                    StiDialogInfoItem.StiStringDialogInfoItem stiStringDialogInfoItem = new StiDialogInfoItem.StiStringDialogInfoItem();
                } else if (!(type.isRange() || type.getEnumType() != StiSystemTypeEnum.SystemFloat && type.getEnumType() != StiSystemTypeEnum.SystemDouble)) {
                    StiDialogInfoItem.StiDoubleDialogInfoItem stiDoubleDialogInfoItem = new StiDialogInfoItem.StiDoubleDialogInfoItem();
                } else if (!type.isRange() && type.getEnumType() == StiSystemTypeEnum.SystemDecimal) {
                    StiDialogInfoItem.StiDecimalDialogInfoItem stiDecimalDialogInfoItem = new StiDialogInfoItem.StiDecimalDialogInfoItem();
                } else if (!type.isRange() && type.getEnumType() == StiSystemTypeEnum.SystemDateTime) {
                    StiDialogInfoItem.StiDateTimeDialogInfoItem stiDateTimeDialogInfoItem = new StiDialogInfoItem.StiDateTimeDialogInfoItem();
                } else if (!type.isRange() && type.getEnumType() == StiSystemTypeEnum.SystemTimeSpan) {
                    StiDialogInfoItem.StiTimeSpanDialogInfoItem stiTimeSpanDialogInfoItem = new StiDialogInfoItem.StiTimeSpanDialogInfoItem();
                } else if (!type.isRange() && type.getEnumType() == StiSystemTypeEnum.SystemBoolean) {
                    StiDialogInfoItem.StiBoolDialogInfoItem stiBoolDialogInfoItem = new StiDialogInfoItem.StiBoolDialogInfoItem();
                } else if (!type.isRange() && type.getEnumType() == StiSystemTypeEnum.SystemChar) {
                    StiDialogInfoItem.StiCharDialogInfoItem stiCharDialogInfoItem = new StiDialogInfoItem.StiCharDialogInfoItem();
                } else if (!type.isRange() && type.getEnumType() == StiSystemTypeEnum.SystemGuid) {
                    StiDialogInfoItem.StiGuidDialogInfoItem stiGuidDialogInfoItem = new StiDialogInfoItem.StiGuidDialogInfoItem();
                }
                if (key != null) {
                    var19_39.KeyObject = key;
                }
                var19_39.setValue(value);
                var19_39.ValueBinding = (List)hashKeysValuesBinding.get(key);
                var19_39.checked = state;
                items.add((StiDialogInfoItem)var19_39);
            }
            ArrayList<StiDialogInfoItem> itemsFiltered = new ArrayList<StiDialogInfoItem>();
            HashMap<Object, Object> hash = new HashMap<Object, Object>();
            for (StiDialogInfoItem item : items) {
                if (hash.containsKey(item.KeyObject) && !(item instanceof StiDialogInfoItem.StiRangeDialogInfoItem)) continue;
                hash.put(item.KeyObject, item.KeyObject);
                itemsFiltered.add(item);
            }
            List<StiDialogInfoItem> resultItem = variable.getDialogInfo().isBindingValue() ? items : itemsFiltered;
            resultItem = variable.getDialogInfo().orderBy(resultItem);
            variable.getDialogInfo().setDialogInfoItems(resultItem, variable.getSystemType());
            ArrayList<Object> lKeys = new ArrayList<Object>();
            for (StiDialogInfoItem stiDialogInfoItem : resultItem) {
                lKeys.add(stiDialogInfoItem.KeyObject);
            }
            keys = lKeys.toArray();
            if (variable.isList() && keys != null && keys.length > 0) {
                StiVariableHelper.fillVariableList(variable, report, keys);
                modified.argvalue = true;
            }
        }
        return false;
    }

    private static void initDateTimeVariables(StiReport report) {
        if (report.isReportRenderingAfterSubmit) {
            return;
        }
        Iterator iterator = report.dictionary.variables.iterator();
        while (iterator.hasNext()) {
            DateTimeRange range;
            StiVariable variable = (StiVariable)iterator.next();
            if (variable.getDialogInfo().getDateTimeType() != StiDateTimeType.Date || !variable.getRequestFromUser() || variable.getInitBy() != StiVariableInitBy.Value || variable.getType() != StiSystemTypeEnum.SystemDateTime || !variable.getSystemType().isValueType() && !variable.getSystemType().isRange()) continue;
            if (!variable.getSystemType().isRange()) {
                report.setVariable(variable.getName(), new StiDateTime(StiVariable.GetDateTimeFromValue(variable.getNativeValue())));
                continue;
            }
            DateTimeRange dateTimeRange = range = variable.getValueObject() instanceof DateTimeRange ? (DateTimeRange)variable.getValueObject() : null;
            if (range == null) {
                return;
            }
            report.setVariable(variable.getName(), new DateTimeRange(range.getFromDate(), !range.getToDate().equals((Object)StiDateTime.MaxValue) ? range.getToDate().addDays(1L).addMilliseconds(-1L) : range.getToDate()));
        }
    }

    private static Boolean[] getChecked(StiDictionary dictionary, String dataColumn, String keysDataColumn, String valuesDataColumn) {
        Object[] array;
        if (StiValidationUtil.isNullOrEmpty((String)dataColumn)) {
            return new Boolean[0];
        }
        int index = dataColumn.indexOf(";");
        if (index == -1) {
            return new Boolean[0];
        }
        String dataSourceName = dataColumn.substring(0, index);
        String expression = "{" + dataColumn.substring(index + 1) + "}";
        StiDataSource dataSource = dictionary.getDataSources().get(dataSourceName);
        if (dataSource == null) {
            if (!StiValidationUtil.isNullOrWhiteSpace((String)keysDataColumn)) {
                dataSource = StiDataColumn.GetDataSourceFromDataColumn(dictionary, keysDataColumn);
            } else if (!StiValidationUtil.isNullOrWhiteSpace((String)valuesDataColumn)) {
                dataSource = StiDataColumn.GetDataSourceFromDataColumn(dictionary, valuesDataColumn);
            }
            if (dataSource == null) {
                return new Boolean[0];
            }
        }
        if ((array = StiDataColumn.getDatasFromDataSourceWithExpression(dataSource, expression, null, true)) == null) {
            return null;
        }
        Boolean[] result = new Boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = StiValueHelper.tryToBool((Object)array[i]);
        }
        return result;
    }

    private static void fillVariableList(StiVariable variable, StiReport compiledReport, Object[] keys) {
        ArrayList<Object> list;
        ArrayList<Object> arrayList = list = compiledReport.get(variable.name) instanceof List ? (ArrayList<Object>)compiledReport.get(variable.name) : null;
        if (list == null) {
            list = new ArrayList<Object>();
        }
        list.clear();
        for (Object key : keys) {
            try {
                list.add(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

