/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.functions;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.drawing.StiGlareBrush;
import com.stimulsoft.base.drawing.StiGlassBrush;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.drawing.StiHatchBrush;
import com.stimulsoft.base.drawing.StiHatchStyle;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiGraphicsUnit;

public class StiFunctionsDrawing {
    public static StiColor ARGB(int alpha, int red, int green, int blue) {
        return StiColor.fromArgb((int)alpha, (int)red, (int)green, (int)blue);
    }

    public static StiColor RGB(int red, int green, int blue) {
        return StiColor.fromArgb((int)255, (int)red, (int)green, (int)blue);
    }

    public static StiColor colorValue(String value) {
        return StiColor.get((String)value);
    }

    public static StiColor colorFade(Object color, double fadeAmount) {
        if (fadeAmount == 0.0) {
            return StiFunctionsDrawing.GetColor(color);
        }
        if (fadeAmount > 0.0) {
            return StiColorUtils.light((StiColor)StiFunctionsDrawing.GetColor(color), (int)((int)(fadeAmount * 255.0)));
        }
        return StiColorUtils.dark((StiColor)StiFunctionsDrawing.GetColor(color), (int)((int)((1.0 - fadeAmount) * 255.0)));
    }

    public static StiSolidBrush solidBrushValue(Object color) {
        return new StiSolidBrush(StiFunctionsDrawing.GetColor(color));
    }

    public static StiGradientBrush gradientBrushValue(Object startColor, Object endColor, double angle) {
        return new StiGradientBrush(StiFunctionsDrawing.GetColor(startColor), StiFunctionsDrawing.GetColor(endColor), angle);
    }

    public static StiGlareBrush glareBrushValue(Object startColor, Object endColor, double angle, double focus, double scale) {
        return new StiGlareBrush(StiFunctionsDrawing.GetColor(startColor), StiFunctionsDrawing.GetColor(endColor), angle, (float)focus, (float)scale);
    }

    public static StiGlassBrush glassBrushValue(Object color, boolean drawHatch, double blendFactor) {
        return new StiGlassBrush(StiFunctionsDrawing.GetColor(color), drawHatch, (float)blendFactor);
    }

    public static StiHatchBrush hatchBrushValue(StiHatchStyle style, Object foreColor, Object backColor) {
        return new StiHatchBrush(style, StiFunctionsDrawing.GetColor(foreColor), StiFunctionsDrawing.GetColor(backColor));
    }

    private static StiColor GetColor(Object color) {
        if (color == null) {
            return StiColor.Transparent;
        }
        if (color instanceof StiColor) {
            return (StiColor)color;
        }
        if (color instanceof StiBrush) {
            return StiBrush.ToColor((StiBrush)((StiBrush)color));
        }
        return StiColor.get((String)color.toString());
    }

    public static StiFont fontValue(String name, double size) {
        return new StiFont(name, size);
    }

    public static StiFont fontValue(String name, double size, int style) {
        return new StiFont(name, size, style, StiGraphicsUnit.Point);
    }
}

