/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.functions;

import com.stimulsoft.base.DBNull;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.Func;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.crossTab.StiCrossSummary;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObject;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import java.util.List;
import java.util.Objects;

public class StiFunctionsData {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAllDataRowNullOrEmpty(Object dataSource, String dataColumn) throws StiException {
        if (!(dataSource instanceof StiDataSource) && !(dataSource instanceof StiBusinessObject)) {
            throw new StiException("Function IsAllDataRowNullOrEmpty: First argument can't be equal to null. Please provide name of Data Source or name of Business Object.");
        }
        if (dataColumn == null) {
            throw new StiException("Function IsAllDataRowNullOrEmpty: Second argument can't be equal to null. Please provide name of Data Column.");
        }
        StiDataSource dataSourceObject = (StiDataSource)dataSource;
        String guid = StiGuid.newGuidString();
        dataSourceObject.saveState(guid);
        Object value = null;
        try {
            if (dataSourceObject != null) {
                dataSourceObject.First();
                while (!dataSourceObject.getIsEof()) {
                    value = dataSourceObject.get(dataColumn);
                    if (!StiFunctionsData.isNullOrEmpty(value)) {
                        boolean bl = false;
                        return bl;
                    }
                    dataSourceObject.Next();
                }
                boolean bl = true;
                return bl;
            }
        }
        finally {
            dataSourceObject.RestoreState(guid);
        }
        return false;
    }

    public static boolean isDataEmpty(Object dataSource) throws StiException {
        if (!(dataSource instanceof StiDataSource) && !(dataSource instanceof StiBusinessObject)) {
            throw new StiException("Function IsDataEmpty: an argument can't be equal to null. Please provide a data source or a business object.");
        }
        if (dataSource instanceof StiDataSource) {
            return ((StiDataSource)dataSource).isEmpty();
        }
        return false;
    }

    public static boolean isNullOrEmpty(Object dataSource, String dataColumn) throws StiException {
        if (!(dataSource instanceof StiDataSource) && !(dataSource instanceof StiBusinessObject)) {
            throw new StiException("Function IsNullOrEmpty: First argument can't be equal to null. Please provide name of Data Source or name of Business Object.");
        }
        if (dataColumn == null) {
            throw new StiException("Function IsNullOrEmpty: Second argument can't be equal to null. Please provide name of Data Column.");
        }
        if (dataSource instanceof StiDataSource) {
            return StiFunctionsData.isNullOrEmpty(((StiDataSource)dataSource).get(dataColumn));
        }
        return false;
    }

    public static boolean isNullOrEmpty(Object value) {
        return value == null || value == DBNull.Value || value.toString().length() == 0;
    }

    public static boolean isNullOrWhiteSpace(Object dataSource, String dataColumn) throws StiException {
        if (!(dataSource instanceof StiDataSource) && !(dataSource instanceof StiBusinessObject)) {
            throw new StiException("Function IsNullOrWhiteSpace: First argument can't be equal to null. Please provide name of Data Source or name of Business Object.");
        }
        if (dataColumn == null) {
            throw new StiException("Function IsNullOrWhiteSpace: Second argument can't be equal to null. Please provide name of Data Column.");
        }
        if (dataSource instanceof StiDataSource) {
            return StiFunctionsData.isNullOrWhiteSpace(((StiDataSource)dataSource).get(dataColumn));
        }
        return false;
    }

    public static boolean isNullOrWhiteSpace(Object value) {
        return value == null || value == DBNull.Value || StiValidationUtil.isNullOrWhiteSpace((String)value.toString());
    }

    public static boolean isNumeric(Object value) {
        if (value == null || value == DBNull.Value) {
            return false;
        }
        try {
            Double.parseDouble(value.toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Object vLookup(Object value, Object dataObject, String dataColumnToLook, String dataColumnToReturn) {
        return StiFunctionsData.vLookup(value, dataObject, dataColumnToLook, dataColumnToReturn, false, false);
    }

    public static Object vLookupStr(Object value, Object dataObject, String dataColumnToLook, String dataColumnToReturn, boolean exactMatch) {
        return StiFunctionsData.vLookup(value, dataObject, dataColumnToLook, dataColumnToReturn, true, exactMatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object vLookup(Object value, Object dataObject, String dataColumnToLook, String dataColumnToReturn, boolean asString, boolean exactMatch) {
        Object result;
        block16: {
            if (!(dataObject instanceof StiDataSource) && !(dataObject instanceof StiBusinessObject)) {
                throw new NullPointerException("Function Vlookup: Second argument can't be equal to null. Please provide name of Data Source or name of Business Object.");
            }
            if (dataColumnToLook == null) {
                throw new NullPointerException("Function Vlookup: Third argument can't be equal to null. Please provide name of Data Column to lookup value.");
            }
            StiDataSource dataSource = dataObject instanceof StiDataSource ? (StiDataSource)dataObject : null;
            StiBusinessObject businessObject = dataObject instanceof StiBusinessObject ? (StiBusinessObject)((Object)dataObject) : null;
            String guid = StiGuid.newGuidString();
            if (dataSource != null) {
                dataSource.saveState(guid);
            }
            if (businessObject != null) {
                businessObject.SaveState(guid);
            }
            result = null;
            try {
                if (dataSource == null) break block16;
                StiDataColumn dc = dataSource.getColumns().get(dataColumnToLook);
                if (dc == null || dataSource.getColumns().get(dataColumnToReturn) == null) {
                    Object var11_11 = null;
                    return var11_11;
                }
                boolean convertNulls = dataSource.getDictionary() != null && dataSource.getDictionary().getReport() != null && dataSource.getDictionary().getReport().getConvertNulls();
                Object cValue = StiReport.changeType(value, dc.getSystemType(), convertNulls);
                String sValue = Func.Convert.toString(value);
                dataSource.First();
                dataSource.ResetData();
                dataSource.ResetDetailsRows();
                while (!dataSource.getIsEof()) {
                    block17: {
                        try {
                            Object current;
                            boolean found = false;
                            if (asString) {
                                current = Func.Convert.toString(dataSource.get(dataColumnToLook));
                                found = exactMatch ? Objects.equals(current, sValue) : ((String)current).contains(sValue);
                            } else {
                                current = StiReport.changeType(dataSource.get(dataColumnToLook), dc.getSystemType(), convertNulls);
                                found = Objects.equals(current, cValue);
                            }
                            if (!found) break block17;
                            result = dataSource.get(dataColumnToReturn);
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    dataSource.Next();
                }
            }
            finally {
                if (dataSource != null) {
                    dataSource.RestoreState(guid);
                }
                if (businessObject != null) {
                    businessObject.RestoreState(guid);
                }
            }
        }
        return result;
    }

    public static String joinColumnContent(Object dataSource, String dataColumn, String delimiter) {
        return StiFunctionsData.joinColumnContent(dataSource, dataColumn, delimiter, false);
    }

    public static String joinColumnContent(Object dataSource, String dataColumn, String delimiter, boolean distinct) {
        StiBusinessObject businessObject;
        if (!(dataSource instanceof StiDataSource) && !(dataSource instanceof StiBusinessObject)) {
            throw new NullPointerException("Function JoinColumnContent: First argument can't be equal to null. Please provide name of Data Source or name of Business Object.");
        }
        if (dataColumn == null) {
            throw new NullPointerException("Function JoinColumnContent: Second argument can't be equal to null. Please provide name of Data Column.");
        }
        StiDataSource dataSourceObject = dataSource instanceof StiDataSource ? (StiDataSource)dataSource : null;
        StiBusinessObject stiBusinessObject = businessObject = dataSource instanceof StiBusinessObject ? (StiBusinessObject)((Object)dataSource) : null;
        if (dataSourceObject != null) {
            return Func.EngineHelper.joinColumnContent(dataSourceObject, dataColumn, delimiter, distinct);
        }
        return null;
    }

    public static String toQueryString(List list, String quotationMark, String dateTimeFormat) {
        return StiFunctionsData.toQueryString(list, quotationMark, dateTimeFormat, true);
    }

    public static String toQueryString(List list, String quotationMark, String dateTimeFormat, boolean needEscape) {
        return Func.EngineHelper.toQueryString(list, quotationMark, dateTimeFormat, needEscape);
    }

    public static Object coalesce(Object[] args) {
        if (args.length == 0) {
            return null;
        }
        for (Object arg : args) {
            if (arg == null || arg == DBNull.Value) continue;
            return arg;
        }
        return null;
    }

    public static String coalesceStr(Object[] args) {
        if (args.length == 0) {
            return null;
        }
        for (Object arg : args) {
            String st = (String)arg;
            if (StiValidationUtil.isNullOrEmpty((String)st)) continue;
            return st;
        }
        return null;
    }

    public static int getRealPageNumber(Object sender) {
        return Func.EngineHelper.getRealPageNumber(sender);
    }

    public static String getCrossTabColumnValue(Object sender) {
        StiCrossSummary summary = sender instanceof StiCrossSummary ? (StiCrossSummary)sender : null;
        return summary != null ? summary.getCrossColumnValue() : null;
    }

    public static String getCrossTabRowValue(Object sender) {
        StiCrossSummary summary = sender instanceof StiCrossSummary ? (StiCrossSummary)sender : null;
        return summary != null ? summary.getCrossRowValue() : null;
    }
}

