/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.functions;

import com.stimulsoft.base.IStiAppFunction;
import com.stimulsoft.base.StiAppFunctions;
import com.stimulsoft.base.system.type.StiSystemType;
import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.base.utils.StiXmlHelper;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.dictionary.functions.StiFunction;
import com.stimulsoft.report.enums.StiReportLanguageType;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StiFunctions {
    private static final String[] FUNCS = new String[]{"FunctionsData.xml", "FunctionsMath.xml", "FunctionsDateTime.xml", "FunctionsDrawing.xml", "FunctionsProgramming.xml", "FunctionsStrings.xml", "FunctionsTotals.xml"};

    public static Hashtable<String, List<StiFunction>> getFunctionsGrouppedInCategories() {
        StiFunction[] functions;
        Hashtable<String, List<StiFunction>> hash = new Hashtable<String, List<StiFunction>>();
        for (StiFunction function : functions = StiFunctions.getFunctions(false)) {
            List<Object> list;
            if (!hash.containsKey(function.getCategory())) {
                list = new ArrayList();
                hash.put(function.getCategory(), list);
            } else {
                list = hash.get(function.getCategory());
            }
            list.add(function);
        }
        return hash;
    }

    public static StiFunction[] getFunctions(boolean isCompile) {
        ArrayList<IStiAppFunction> list = new ArrayList<IStiAppFunction>();
        Hashtable tempFuncs = isCompile ? StiAppFunctions.functionsToCompile : StiAppFunctions.functions;
        for (String functionName : tempFuncs.keySet()) {
            IStiAppFunction[] functionsList;
            for (IStiAppFunction function : functionsList = StiFunctions.getFunctions(null, functionName, isCompile)) {
                list.add(function);
            }
        }
        return list.toArray(new StiFunction[0]);
    }

    public static IStiAppFunction[] getFunctions(StiReport report, String functionName, boolean isCompile) {
        List list;
        if (isCompile) {
            List list2;
            if (!StiAppFunctions.functionsToCompile.containsKey(functionName)) {
                if (report != null && report.getScriptLanguage() == StiReportLanguageType.VB) {
                    functionName = functionName.toLowerCase();
                    list2 = (List)StiAppFunctions.functionsToCompileLower.get(functionName);
                } else {
                    list2 = (List)StiAppFunctions.functionsToCompile.get(functionName);
                }
                if (list2 == null) {
                    return null;
                }
            } else {
                list2 = (List)StiAppFunctions.functionsToCompile.get(functionName);
            }
            return list2.toArray(new IStiAppFunction[0]);
        }
        if (!StiAppFunctions.functions.containsKey(functionName)) {
            if (report != null && report.getScriptLanguage() == StiReportLanguageType.VB) {
                functionName = functionName.toLowerCase();
                list = (List)StiAppFunctions.functionsLower.get(functionName);
            } else {
                list = (List)StiAppFunctions.functions.get(functionName);
            }
            if (list == null) {
                return null;
            }
        } else {
            list = (List)StiAppFunctions.functions.get(functionName);
        }
        return list.toArray(new IStiAppFunction[0]);
    }

    public static IStiAppFunction addFunction(String category, String functionName, String typeOfFunction, StiSystemType returnType) {
        return StiFunctions.addFunction(category, functionName, "", typeOfFunction, returnType, "", null, null);
    }

    public static IStiAppFunction addFunction(String category, String functionName, String description, String typeOfFunction, StiSystemType returnType, String returnDescription) {
        return StiFunctions.addFunction(category, functionName, description, typeOfFunction, returnType, returnDescription, null, null);
    }

    public static IStiAppFunction addFunction(String category, String functionName, String description, String typeOfFunction, StiSystemType returnType, String returnDescription, StiSystemType[] argumentTypes, String[] argumentNames) {
        return StiFunctions.addFunction(category, functionName, functionName, description, typeOfFunction, returnType, returnDescription, argumentTypes, argumentNames, null);
    }

    public static StiFunction addFunction(String category, String groupFunctionName, String functionName, String description, String typeOfFunction, StiSystemType returnType, String returnDescription, StiSystemType[] argumentTypes, String[] argumentNames, String[] argumentDescriptions) {
        List<StiFunction> list;
        if (StiValidationUtil.isNullOrEmpty((String)groupFunctionName)) {
            groupFunctionName = functionName;
        }
        StiFunction function = new StiFunction(category, groupFunctionName, functionName, description, typeOfFunction, returnType, returnDescription, argumentTypes, argumentNames, argumentDescriptions);
        if (!StiAppFunctions.functions.containsKey(groupFunctionName)) {
            list = new ArrayList();
            StiAppFunctions.functions.put(groupFunctionName, list);
            StiAppFunctions.functionsLower.put(groupFunctionName.toLowerCase(), list);
        } else {
            list = (List)StiAppFunctions.functions.get(groupFunctionName);
        }
        list.add(function);
        if (!StiAppFunctions.functionsToCompile.containsKey(functionName)) {
            list = new ArrayList();
            StiAppFunctions.functionsToCompile.put(functionName, list);
            StiAppFunctions.functionsToCompileLower.put(functionName.toLowerCase(), list);
        } else {
            list = (List)StiAppFunctions.functionsToCompile.get(functionName);
        }
        list.add(function);
        return function;
    }

    public static void init() {
    }

    static {
        try {
            for (String fName : FUNCS) {
                Document doc = StiXmlHelper.loadXML((InputStream)StiResourceUtil.getStream((String)("/functions/" + fName)));
                NodeList cats = doc.getElementsByTagName("Category");
                for (int i = 0; i < cats.getLength(); ++i) {
                    Node ncategory = cats.item(i);
                    String category = ncategory.getAttributes().getNamedItem("Name") != null ? ncategory.getAttributes().getNamedItem("Name").getNodeValue() : ncategory.getAttributes().getNamedItem("name").getNodeValue();
                    NodeList functions = ncategory.getChildNodes();
                    for (int j = 0; j < functions.getLength(); ++j) {
                        Node function = functions.item(j);
                        if (function.getNodeType() != 1) continue;
                        String groupFunctionName = "";
                        String functionName = "";
                        String description = "";
                        String typeOfFunction = null;
                        StiSystemType returnType = null;
                        String returnDescription = "";
                        ArrayList<StiSystemType> argumentTypes = new ArrayList<StiSystemType>();
                        ArrayList<String> argumentNames = new ArrayList<String>();
                        ArrayList<String> argumentDescriptions = new ArrayList<String>();
                        NodeList attrs = function.getChildNodes();
                        for (int k = 0; k < attrs.getLength(); ++k) {
                            Node attr = attrs.item(k);
                            if (attr.getNodeType() != 1) continue;
                            String nodeName = attr.getNodeName();
                            if ("Group".equals(nodeName)) {
                                groupFunctionName = attr.getTextContent();
                                continue;
                            }
                            if ("Name".equals(nodeName)) {
                                functionName = attr.getTextContent();
                                continue;
                            }
                            if ("Description".equals(nodeName)) {
                                description = attr.getTextContent();
                                continue;
                            }
                            if ("TypeOfFunction".equals(nodeName)) {
                                typeOfFunction = attr.getTextContent();
                                continue;
                            }
                            if ("ReturnType".equals(nodeName)) {
                                returnType = StiSystemType.getSystemType((String)attr.getTextContent());
                                continue;
                            }
                            if ("ReturnDescription".equals(nodeName)) {
                                returnDescription = attr.getTextContent();
                                continue;
                            }
                            if ("ArgumentType".equals(nodeName)) {
                                argumentTypes.add(StiSystemType.getSystemType((String)attr.getTextContent()));
                                continue;
                            }
                            if ("ArgumentName".equals(nodeName)) {
                                argumentNames.add(attr.getTextContent());
                                continue;
                            }
                            if (!"ArgumentDescription".equals(nodeName)) continue;
                            argumentDescriptions.add(attr.getTextContent());
                        }
                        if (typeOfFunction == null) {
                            StiFunctions.addFunction(category, groupFunctionName, functionName, description, "System.Object", returnType, returnDescription, argumentTypes.toArray(new StiSystemType[0]), argumentNames.toArray(new String[0]), argumentDescriptions.toArray(new String[0])).setUseFullPath(false);
                            continue;
                        }
                        StiFunctions.addFunction(category, groupFunctionName, functionName, description, typeOfFunction, returnType, returnDescription, argumentTypes.toArray(new StiSystemType[0]), argumentNames.toArray(new String[0]), argumentDescriptions.toArray(new String[0]));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

