/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.databases;

import com.stimulsoft.base.StiBaseOptions;
import com.stimulsoft.base.StiJsonConverterVersion;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.data.StiDataLoaderHelper;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONArray;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.licenses.StiCryptHelper;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.lib.base64.StiBase64DecoderUtil;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiJsonToDataSetConverter;
import com.stimulsoft.report.StiNameCreation;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiDataColumnsCollection;
import com.stimulsoft.report.dictionary.StiDatabaseInformation;
import com.stimulsoft.report.dictionary.adapters.StiAbstractAdapter;
import com.stimulsoft.report.dictionary.data.DataSet;
import com.stimulsoft.report.dictionary.data.DataTable;
import com.stimulsoft.report.dictionary.dataSources.StiDataStoreSource;
import com.stimulsoft.report.dictionary.dataSources.StiDataTableSource;
import com.stimulsoft.report.dictionary.databases.StiFileDatabase;
import com.stimulsoft.report.helpers.StiUniversalDataLoader;
import com.stimulsoft.report.json.StiJsonToDataSetConverterV2;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class StiJsonDatabase
extends StiFileDatabase {
    private InputStream dataIS = null;
    private Object jsonObject = null;
    private String jsonData = null;
    private Map<String, String> headers = new HashMap<String, String>();

    public StiJsonDatabase() {
        this("", "");
    }

    public StiJsonDatabase(String name) {
        super(name);
    }

    public StiJsonDatabase(String name, String pathData) {
        super(name);
        this.pathData = pathData;
    }

    public StiJsonDatabase(String name, File pathData) {
        super(name);
        this.pathData = pathData.getAbsolutePath();
    }

    public StiJsonDatabase(String name, InputStream dataIS) {
        super(name);
        this.dataIS = dataIS;
    }

    @StiSerializable
    public String getHeadersString() {
        if (this.headers == null || this.headers.keySet().size() == 0) {
            return "";
        }
        JSONObject value = new JSONObject(this.headers);
        String json = value.toString();
        try {
            return StiCryptHelper.encrypt((String)json, (String)"ndaabwlQk8v7rtCx1NQqyg==");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public void setHeadersString(String value) {
        this.headers = new HashMap<String, String>();
        if (!StiValidationUtil.isNullOrEmpty((String)value)) {
            try {
                byte[] bytes = StiBase64DecoderUtil.decode((String)value);
                String json = new String(StiCryptHelper.decrypt((byte[])bytes, (String)"ndaabwlQk8v7rtCx1NQqyg=="), "UTF-8");
                JSONObject jObject = new JSONObject(json);
                Iterator i = jObject.keys();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    this.headers.put(key, jObject.getString(key));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    @Override
    public String getServiceName() {
        return "JSON";
    }

    @Override
    public void connect(StiDataStoreSource source, StiReport report) {
        this.connect(source, true, report);
    }

    @Override
    public void connect(StiDataStoreSource source, Boolean fillTable, StiReport report) {
        try {
            if (this.jsonObject == null) {
                this.jsonObject = this.getJSONObject(report);
            }
            if (fillTable.booleanValue()) {
                this.fillTable(source, report);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getJsonData() {
        return this.jsonData;
    }

    public void setJsonData(String jsonData) {
        this.jsonData = jsonData;
    }

    @StiSerializable
    public String getEmbeddedData() {
        return this.jsonData;
    }

    public void setEmbeddedData(String embeddedData) {
        this.jsonData = embeddedData;
    }

    @Override
    public void disconnect() {
        this.jsonObject = null;
    }

    public void fillTable(StiDataStoreSource source, StiReport report) throws FileNotFoundException, JSONException, IOException {
        DataSet dataSet = StiBaseOptions.getDefaultJsonConverterVersion() == StiJsonConverterVersion.ConverterV1 ? StiJsonToDataSetConverter.getDataTable(this.getJSONObject(report)) : StiJsonToDataSetConverterV2.getDataSet(this.getJSONObject(report), source);
        boolean found = false;
        for (DataTable table : dataSet.getTables()) {
            if (!source.getNameInSource().equals(table.getName()) && !source.getNameInSource().endsWith("." + table.getName()) && !source.getNameInSource().endsWith(".root_" + table.getName())) continue;
            source.setDataTable(table);
            found = true;
        }
        if (!found && dataSet.getTables() != null && dataSet.getTables().size() == 1 && StiOptions.Dictionary.AllowConnectToFirstTableForEmptyDataSource) {
            source.setDataTable((DataTable)dataSet.getTables().get(0));
        }
    }

    public Object getJSONObject(StiReport report) throws FileNotFoundException, JSONException, IOException {
        StiDataLoaderHelper.Data data;
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        if (StiValidationUtil.isNotNullOrEmpty((String)this.pathData) && (data = StiUniversalDataLoader.loadSingle(report, this.parsePath(this.pathData, report), this.headers)) != null && data.array != null) {
            String dataS = new String(data.array, "UTF-8");
            if (dataS.length() > 0 && dataS.charAt(0) == '\ufeff') {
                dataS = dataS.substring(1);
            }
            try {
                return new JSONObject(dataS);
            }
            catch (Exception e) {
                return new JSONArray(dataS);
            }
        }
        if (this.dataIS != null && this.dataIS.markSupported()) {
            try {
                this.dataIS.reset();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.getEmbeddedData() != null) {
            return new JSONObject(this.getEmbeddedData());
        }
        return this.dataIS != null ? new JSONObject(StiIOUtil.toString((InputStream)this.dataIS)) : null;
    }

    @Override
    public StiDatabaseInformation getDatabaseInformation(Connection con, StiAbstractAdapter adapter, StiReport report) throws Exception {
        StiDatabaseInformation info = new StiDatabaseInformation();
        DataSet dataSet = StiBaseOptions.getDefaultJsonConverterVersion() == StiJsonConverterVersion.ConverterV1 ? StiJsonToDataSetConverter.getDataTable(this.getJSONObject(report)) : StiJsonToDataSetConverterV2.getDataSet(this.getJSONObject(report));
        for (DataTable table : dataSet.getTables()) {
            if (table == null) continue;
            DataTable dTable = new DataTable(table.getName(), new StiDataColumnsCollection());
            Iterator iterator = table.getColumns().iterator();
            while (iterator.hasNext()) {
                StiDataColumn field = (StiDataColumn)iterator.next();
                dTable.getColumns().add(new StiDataColumn(field.getName(), field.getName(), field.getSystemType()));
            }
            info.getTables().add(dTable);
        }
        return info;
    }

    @Override
    public void applyDatabaseInformation(StiDatabaseInformation information, StiReport report, StiDatabaseInformation informationAll) {
        for (DataTable dataTable : information.getTables()) {
            StiDataTableSource source = new StiDataTableSource(this.getName() + "." + dataTable.getTableName(), StiNameCreation.createName(report, dataTable.getTableName(), false, false, true));
            Iterator iterator = dataTable.getColumns().iterator();
            while (iterator.hasNext()) {
                StiDataColumn dataColumn = (StiDataColumn)iterator.next();
                StiDataColumn column = new StiDataColumn(dataColumn.getName(), dataColumn.getName(), dataColumn.getSystemType());
                source.getColumns().add(column);
                column.setDataSource(source);
            }
            report.getDictionary().getDataSources().add(source);
            source.setDictionary(report.getDictionary());
        }
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyStringNullOfEmpty("PathData", this.getPathData());
        jObject.AddPropertyStringNullOfEmpty("EmbeddedData", this.getEmbeddedData());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("PathData")) {
                this.setPathData((String)property.Value);
                continue;
            }
            if (property.Name.equals("EmbeddedData")) {
                this.setEmbeddedData((String)property.Value);
                continue;
            }
            if (!property.Name.equals("XmlType")) continue;
        }
    }
}

