/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.dataSources;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.system.StiCollection;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.dictionary.StiDictionary;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.dictionary.dataSources.StiDataStoreSource;
import com.stimulsoft.report.dictionary.dataSources.StiDataTableSource;
import com.stimulsoft.report.dictionary.enums.StiConnectionOrder;
import com.stimulsoft.report.dictionary.enums.StiSortOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class StiDataSourcesCollection
extends StiCollection<StiDataSource>
implements IStiJsonReportObject {
    private static final long serialVersionUID = 6757756030999302184L;
    private StiDictionary dictionary;
    private static final Comparator<StiDataSource> BY_CORRECT_NAME = new Comparator<StiDataSource>(){

        @Override
        public int compare(StiDataSource value1, StiDataSource value2) {
            return value1.getName().compareTo(value2.getName());
        }
    };

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        if (this.size() == 0) {
            return null;
        }
        JSONObject jObject = new JSONObject();
        Integer index = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            StiDataSource dataSource = (StiDataSource)iterator.next();
            jObject.AddPropertyJObject(index.toString(), dataSource.SaveToJsonObject(mode));
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        List<Class<?>> classes = StiOptions.Services.getDataSource();
        for (JProperty property : jObject.Properties()) {
            JSONObject propJObject = (JSONObject)property.Value;
            JProperty ident = propJObject.Properties().FirstOrDefault("Ident");
            Class<?> clazz = null;
            String identName = (String)ident.Value;
            for (Class<?> claz : classes) {
                String name = claz.getName();
                if (!name.substring(name.lastIndexOf(46) + 1).equals(identName)) continue;
                clazz = claz;
            }
            if (clazz == null) continue;
            StiDataSource dataSource = null;
            try {
                dataSource = (StiDataSource)clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            dataSource.setDictionary(this.dictionary);
            dataSource.LoadFromJsonObject(propJObject);
            this.add(dataSource);
        }
    }

    public StiDataSourcesCollection() {
    }

    public StiDataSourcesCollection(StiDictionary dictionary) {
        this.dictionary = dictionary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(StiSortOrder order) {
        StiDataSourcesCollection stiDataSourcesCollection = this;
        synchronized (stiDataSourcesCollection) {
            if (order == StiSortOrder.Asc) {
                Collections.sort(this, BY_CORRECT_NAME);
            } else {
                Collections.sort(this, Collections.reverseOrder(BY_CORRECT_NAME));
            }
        }
    }

    public boolean exist(String dataSourceName) {
        return this.getIndexByName(dataSourceName) > -1;
    }

    public boolean contains(String dataSourceName) {
        return this.exist(dataSourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndexByName(String dataSourceName) {
        StiDataSourcesCollection stiDataSourcesCollection = this;
        synchronized (stiDataSourcesCollection) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                StiDataSource source = (StiDataSource)iterator.next();
                if (!StiValidationUtil.equals((Object)source.getName(), (Object)dataSourceName) && (!(source instanceof StiDataStoreSource) || !StiValidationUtil.equals((Object)((StiDataStoreSource)source).getNameInSource(), (Object)dataSourceName))) continue;
                return this.indexOf(source);
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StiDataSource get(String dataSourceName) {
        StiDataSourcesCollection stiDataSourcesCollection = this;
        synchronized (stiDataSourcesCollection) {
            int index = this.getIndexByName(dataSourceName);
            return index >= 0 ? (StiDataSource)this.get(index) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareData() {
        StiDataSourcesCollection stiDataSourcesCollection = this;
        synchronized (stiDataSourcesCollection) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                StiDataSource dataSource = (StiDataSource)iterator.next();
                dataSource.prepareData();
            }
        }
    }

    protected Comparator<? super StiDataSource> getComporator() {
        return BY_CORRECT_NAME;
    }

    public void connect() throws StiException {
        this.connect(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(boolean fillTable) throws StiException {
        StiDataSourcesCollection stiDataSourcesCollection = this;
        synchronized (stiDataSourcesCollection) {
            ArrayList dataSources = new ArrayList();
            dataSources.addAll(this);
            Collections.sort(dataSources, new Comparator<StiDataSource>(){

                @Override
                public int compare(StiDataSource o1, StiDataSource o2) {
                    return o1.connectionOrder.compareTo(o2.connectionOrder);
                }
            });
            for (StiDataSource dataSource : dataSources) {
                if (dataSource.connectionOrder.intValue() == StiConnectionOrder.None.getValue() || !dataSource.connectOnStart || !fillTable && !(dataSource instanceof StiDataTableSource)) continue;
                dataSource.connect(fillTable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        StiDataSourcesCollection stiDataSourcesCollection = this;
        synchronized (stiDataSourcesCollection) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                StiDataSource dataSource = (StiDataSource)iterator.next();
                dataSource.disconnect();
            }
        }
    }
}

