/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.data;

import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.lib.utils.XMLGregorianCalendarImpl;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.data.DataCell;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Logger;

public class StiDateDataCell
extends DataCell {
    private static Logger LOGGER = Logger.getLogger("com.stimulsoft.report.dictionary.data.StiDateDataCell");
    private static final String DATE_STRING_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private StiDateTime value;

    public StiDateDataCell(StiDataColumn column, Object value) {
        block15: {
            super(column, value != null ? value.toString() : "");
            try {
                if (value instanceof Calendar) {
                    this.value = new StiDateTime((Calendar)value);
                    break block15;
                }
                if (value instanceof Date) {
                    this.value = new StiDateTime((Date)value);
                    break block15;
                }
                if (value instanceof ZonedDateTime) {
                    this.value = new StiDateTime((ZonedDateTime)value);
                    break block15;
                }
                if (value instanceof StiDateTime) {
                    this.value = (StiDateTime)value;
                    break block15;
                }
                if (value != null && StiValidationUtil.isNotNullOrEmpty((String)value.toString())) {
                    int attemtp = 0;
                    boolean passed = false;
                    while (!passed) {
                        try {
                            switch (attemtp) {
                                case 0: {
                                    this.value = new StiDateTime((Calendar)new XMLGregorianCalendarImpl(value.toString()).toGregorianCalendar());
                                    break;
                                }
                                case 1: {
                                    SimpleDateFormat formatter = new SimpleDateFormat(DATE_STRING_FORMAT, Locale.ENGLISH);
                                    this.value = new StiDateTime(formatter.parse(value.toString()));
                                    break;
                                }
                                case 2: {
                                    SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.ENGLISH);
                                    this.value = new StiDateTime(formatter.parse(value.toString()));
                                    break;
                                }
                                default: {
                                    this.value = null;
                                    if (StiOptions.Engine.logLevel < 10) break;
                                    LOGGER.warning("Unparsable datetime: " + value.toString() + " column: " + column.getName());
                                }
                            }
                            passed = true;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        ++attemtp;
                    }
                    break block15;
                }
                this.value = null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public StiDateTime getValue() {
        return this.value;
    }
}

