/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.data;

import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.data.StiDBNullCell;

public class DataCell {
    private static final String STR_NULL = "";
    private String value;
    private final StiDataColumn column;

    public DataCell(StiDataColumn column, String value) {
        this.column = column;
        this.value = value;
    }

    public String getColumnName() {
        return this.column.getName();
    }

    public StiSystemTypeEnum getType() {
        return this.column.getType();
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isNotEmpty() {
        return this.value != null;
    }

    public Object clone() {
        return new DataCell(this.column, this.value);
    }

    public String toString() {
        return String.format("%s (%s)", this.getValue(), this.column);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataCell other = (DataCell)obj;
        return !(this.getValue() == null ? other.getValue() != null : !this.getValue().equals(other.getValue()));
    }

    public static DataCell createEmpty(StiDataColumn column) {
        return new StiDBNullCell(column);
    }

    public String getEmptyValue() {
        return STR_NULL;
    }
}

