/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.aggregateFunctions;

import com.stimulsoft.base.DBNull;
import com.stimulsoft.base.StiObjectConverter;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiAggregateFunctionService;

public class StiMaxIntFunctionService
extends StiAggregateFunctionService {
    private long maximum;

    public StiMaxIntFunctionService() {
    }

    public StiMaxIntFunctionService(boolean runningTotal) {
        super(runningTotal);
    }

    @Override
    public void CalcItem(Object value) {
        if (value == null || value == DBNull.Value) {
            return;
        }
        long val = StiObjectConverter.ConvertToInt64((Object)value);
        if (this.maximum < val) {
            this.maximum = val;
        }
    }

    @Override
    public boolean getRecureParam() {
        return true;
    }

    @Override
    public Class GetResultType() {
        return Long.class;
    }

    public String getServiceName() {
        return "MaxI";
    }

    @Override
    public Object GetValue() {
        return this.maximum;
    }

    @Override
    public void Init() {
        if (!this.getRunningTotal() || this.IsFirstInit) {
            this.maximum = Long.MIN_VALUE;
        }
    }

    @Override
    public void SetValue(Object value) {
        this.maximum = (Long)value;
    }
}

