/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.aggregateFunctions;

import com.stimulsoft.base.DBNull;
import com.stimulsoft.base.StiObjectConverter;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiAggregateFunctionService;

public class StiAvgIntFunctionService
extends StiAggregateFunctionService {
    private long summary;
    private long count;

    public String getServiceName() {
        return "AvgI";
    }

    @Override
    public void Init() {
        if (!this.getRunningTotal() || this.IsFirstInit) {
            this.summary = 0L;
            this.count = 0L;
        }
    }

    @Override
    public void CalcItem(Object value) {
        if (value == null || value == DBNull.Value) {
            return;
        }
        this.summary += StiObjectConverter.ConvertToInt64((Object)value);
        ++this.count;
    }

    @Override
    public Object GetValue() {
        if (this.count == 0L) {
            return 0;
        }
        return this.summary / this.count;
    }

    @Override
    public void SetValue(Object value) {
        throw new IllegalArgumentException("You can't set calculation result to AvgI function!");
    }

    @Override
    public Class GetResultType() {
        return Long.class;
    }

    @Override
    public boolean getRecureParam() {
        return true;
    }

    public StiAvgIntFunctionService(boolean runningTotal) {
        super(runningTotal);
    }

    public StiAvgIntFunctionService() {
    }
}

