/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.aggregateFunctions;

import com.stimulsoft.base.DBNull;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiAggregateFunctionService;

public class StiAvgDoubleFunctionService
extends StiAggregateFunctionService {
    private double summary;
    private long count;

    public StiAvgDoubleFunctionService(boolean runningTotal) {
        super(runningTotal);
    }

    public StiAvgDoubleFunctionService() {
    }

    public String getServiceName() {
        return "AvgD";
    }

    @Override
    public void Init() {
        if (!this.getRunningTotal() || this.IsFirstInit) {
            this.summary = 0.0;
            this.count = 0L;
        }
    }

    @Override
    public void CalcItem(Object value) {
        if (value == null || value == DBNull.Value) {
            return;
        }
        this.summary += Double.parseDouble(value.toString());
        ++this.count;
    }

    @Override
    public Object GetValue() {
        if (this.count == 0L) {
            return 0.0;
        }
        return this.summary / (double)this.count;
    }

    @Override
    public void SetValue(Object value) {
        throw new IllegalArgumentException("You can't set calculation result to Avg function!");
    }

    @Override
    public Class GetResultType() {
        return Double.class;
    }

    @Override
    public boolean getRecureParam() {
        return true;
    }
}

