/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary;

import com.stimulsoft.base.DBNull;
import com.stimulsoft.report.components.bands.StiHierarchicalBand;
import com.stimulsoft.report.dictionary.StiDataSort;
import com.stimulsoft.report.dictionary.StiSort;
import com.stimulsoft.report.dictionary.data.DataRow;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;

public class StiHierarchicalDataSort {
    private final StiDataSource dataSource;
    private final ArrayList<String> sortColumns;
    private String keyColumn = null;
    private String masterKeyColumn = null;
    private String parentValue = null;

    public final int Compare(Object x, Object y) {
        try {
            if (x == y) {
                return 0;
            }
            DataRow row1 = (DataRow)(x instanceof DataRow ? x : null);
            DataRow row2 = (DataRow)(y instanceof DataRow ? y : null);
            Object key1 = row1.getValue(this.keyColumn);
            Object key2 = row2.getValue(this.keyColumn);
            return StiDataSort.CompareValues(key1, key2);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private String GetParentValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value == DBNull.Value) {
            return "";
        }
        String str = value.toString();
        if (str.trim().length() == 0) {
            return "";
        }
        return str;
    }

    public final void Process(Hashtable rowToConditions) {
        if (this.dataSource.detailRows == null) {
            return;
        }
        Hashtable values = new Hashtable();
        this.CreateTree(values);
        this.dataSource.RowToLevel = new Hashtable();
        this.SetLevelAndSort(rowToConditions, values, this.parentValue, 0);
        ArrayList rows = new ArrayList();
        this.CreateRowList(values, rows, this.parentValue);
        this.dataSource.detailRows = rows;
    }

    private void CreateTree(Hashtable values) {
        for (DataRow row : this.dataSource.detailRows) {
            Object masterKey = row.getValue(this.masterKeyColumn);
            ArrayList<DataRow> rowItems = values.get(masterKey = this.GetParentValue(masterKey)) instanceof ArrayList ? values.get(masterKey) : null;
            if (rowItems == null) {
                rowItems = new ArrayList<DataRow>();
                values.put(masterKey, rowItems);
            }
            rowItems.add(row);
        }
    }

    private void SetLevelAndSort(Hashtable rowToConditions, Hashtable values, Object masterKey, int level) {
        Object objectValue = values.get(this.GetParentValue(masterKey));
        ArrayList list = (ArrayList)(objectValue instanceof ArrayList ? objectValue : null);
        if (list != null) {
            for (DataRow row : list) {
                this.dataSource.RowToLevel.put(row, level);
                Object key = row.getValue(this.keyColumn);
                Object tempVar = rowToConditions.clone();
                this.SetLevelAndSort((Hashtable)(tempVar instanceof Hashtable ? tempVar : null), values, key, level + 1);
            }
            StiDataSort dataSort = new StiDataSort(rowToConditions, null, StiSort.creatByStringArray(this.sortColumns), this.dataSource);
            ArrayList<DataRow> listOfDetailRows = new ArrayList<DataRow>();
            for (DataRow row : list) {
                listOfDetailRows.add(row);
            }
            Collections.sort(listOfDetailRows, dataSort);
            list.clear();
            for (DataRow row : listOfDetailRows) {
                list.add(row);
            }
            dataSort.Clear();
        }
    }

    private void CreateRowList(Hashtable values, ArrayList rows, Object masterKey) {
        ArrayList list = values.get(this.GetParentValue(masterKey)) instanceof ArrayList ? values.get(this.GetParentValue(masterKey)) : null;
        if (list != null) {
            for (DataRow row : list) {
                rows.add(row);
                Object key = row.getValue(this.keyColumn);
                this.CreateRowList(values, rows, key);
            }
        }
    }

    public StiHierarchicalDataSort(StiDataSource dataSource, StiHierarchicalBand band, ArrayList<String> sortColumns) {
        this.dataSource = dataSource;
        this.keyColumn = band.getKeyDataColumn();
        this.masterKeyColumn = band.getMasterKeyDataColumn();
        this.parentValue = band.getParentValue();
        this.sortColumns = sortColumns;
        if (this.keyColumn == null || this.keyColumn.trim().length() == 0) {
            throw new IllegalArgumentException("Property 'KeyDataColumn' of '" + band.getName() + "'is not filled!");
        }
        if (this.masterKeyColumn == null || this.masterKeyColumn.trim().length() == 0) {
            throw new IllegalArgumentException("Property 'MasterKeyDataColumn' of '" + band.getName() + "'is not filled!");
        }
        if (!dataSource.columns.contains(this.keyColumn)) {
            throw new IllegalArgumentException("Column '" + this.keyColumn + "' does not present in '" + dataSource.getName() + "'");
        }
        if (!dataSource.columns.contains(this.masterKeyColumn)) {
            throw new IllegalArgumentException("Column '" + this.masterKeyColumn + "' does not present in '" + dataSource.getName() + "'");
        }
        if (this.parentValue == null) {
            this.parentValue = "";
        }
    }
}

